/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;

public class RenderingUtils {
    static final double PI_TWO = Math.PI * 2;

    public static void drawRect(@NotNull GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.m_280656_(x, x + width, y, color);
        guiGraphics.m_280656_(x, x + width, y + height, color);
        guiGraphics.m_280315_(x, y, y + height, color);
        guiGraphics.m_280315_(x + width, y, y + height, color);
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int[] color) {
        float[] alpha = new float[4];
        float[] red = new float[4];
        float[] green = new float[4];
        float[] blue = new float[4];
        for (int i = 0; i < 4; ++i) {
            alpha[i] = (float)(color[i] >> 24 & 0xFF) / 255.0f;
            red[i] = (float)(color[i] >> 16 & 0xFF) / 255.0f;
            green[i] = (float)(color[i] >> 8 & 0xFF) / 255.0f;
            blue[i] = (float)(color[i] & 0xFF) / 255.0f;
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(mat, (float)right, (float)top, (float)zLevel).m_85950_(red[0], green[0], blue[0], alpha[0]).m_5752_();
        bufferbuilder.m_252986_(mat, (float)left, (float)top, (float)zLevel).m_85950_(red[1], green[1], blue[1], alpha[1]).m_5752_();
        bufferbuilder.m_252986_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(red[2], green[2], blue[2], alpha[2]).m_5752_();
        bufferbuilder.m_252986_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(red[3], green[3], blue[3], alpha[3]).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderPureColorSquare(PoseStack mStack, int x, int y, int width, int height) {
        Matrix4f mat = mStack.m_85850_().m_252922_();
        boolean zLevel = false;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        for (int i = 0; i <= width; ++i) {
            float val = (float)i / (float)width * 360.0f / 360.0f;
            Color top = new Color(Color.HSBtoRGB(val, 1.0f, 1.0f));
            bufferbuilder.m_252986_(mat, (float)(x + i), (float)y, (float)zLevel).m_85950_((float)top.getRed() / 255.0f, (float)top.getGreen() / 255.0f, (float)top.getBlue() / 255.0f, (float)top.getAlpha() / 255.0f).m_5752_();
            bufferbuilder.m_252986_(mat, (float)(x + i), (float)(y + height), (float)zLevel).m_85950_((float)top.getRed() / 255.0f, (float)top.getGreen() / 255.0f, (float)top.getBlue() / 255.0f, (float)top.getAlpha() / 255.0f).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void renderColorSquare(@NotNull GuiGraphics guiGraphics, int x, int y, int width, int height) {
        Color bot;
        Color top;
        float val;
        int i;
        Matrix4f mat = guiGraphics.m_280168_().m_85850_().m_252922_();
        boolean zLevel = false;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        for (i = 0; i < width; ++i) {
            val = (float)i / (float)width * 360.0f / 360.0f;
            top = new Color(Color.HSBtoRGB(val, 1.0f, 0.0f));
            bot = new Color(Color.HSBtoRGB(val, 1.0f, 1.0f));
            bufferbuilder.m_252986_(mat, (float)(x + i), (float)y, (float)zLevel).m_85950_((float)top.getRed() / 255.0f, (float)top.getGreen() / 255.0f, (float)top.getBlue() / 255.0f, (float)top.getAlpha() / 255.0f).m_5752_();
            bufferbuilder.m_252986_(mat, (float)(x + i), (float)y + (float)height / 2.0f, (float)zLevel).m_85950_((float)bot.getRed() / 255.0f, (float)bot.getGreen() / 255.0f, (float)bot.getBlue() / 255.0f, (float)bot.getAlpha() / 255.0f).m_5752_();
        }
        for (i = 0; i < width; ++i) {
            val = (float)i / (float)width * 360.0f / 360.0f;
            top = new Color(Color.HSBtoRGB(val, 1.0f, 1.0f));
            bot = new Color(Color.HSBtoRGB(val, 0.0f, 1.0f));
            bufferbuilder.m_252986_(mat, (float)(x + i), (float)y + (float)height / 2.0f, (float)zLevel).m_85950_((float)top.getRed() / 255.0f, (float)top.getGreen() / 255.0f, (float)top.getBlue() / 255.0f, (float)top.getAlpha() / 255.0f).m_5752_();
            bufferbuilder.m_252986_(mat, (float)(x + i), (float)(y + height), (float)zLevel).m_85950_((float)bot.getRed() / 255.0f, (float)bot.getGreen() / 255.0f, (float)bot.getBlue() / 255.0f, (float)bot.getAlpha() / 255.0f).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void fill(@NotNull GuiGraphics guiGraphics, double pMinX, double pMinY, double pMaxX, double pMaxY, int pColor) {
        Matrix4f pMatrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        if (pMinX < pMaxX) {
            double i = pMinX;
            pMinX = pMaxX;
            pMaxX = i;
        }
        if (pMinY < pMaxY) {
            double j = pMinY;
            pMinY = pMaxY;
            pMaxY = j;
        }
        float f3 = (float)(pColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(pColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(pColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(pColor & 0xFF) / 255.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_252986_(pMatrix, (float)pMinX, (float)pMaxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(pMatrix, (float)pMaxX, (float)pMaxY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(pMatrix, (float)pMaxX, (float)pMinY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        bufferbuilder.m_252986_(pMatrix, (float)pMinX, (float)pMinY, 0.0f).m_85950_(f, f1, f2, f3).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void drawTexturedCircle(GuiGraphics guiGraphics, double x, double y, double radius, double u, double v, double texRadius, int sides, double percent, double startAngle) {
        double cos;
        double sin;
        double rad;
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        double z = 100.0;
        RenderSystem.enableBlend();
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder buffer = tesselator.m_85915_();
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_7421_((float)u, (float)v).m_5752_();
        int i = 0;
        while ((double)i <= percent * (double)sides) {
            rad = Math.PI * 2 * ((double)i / (double)sides + startAngle);
            sin = Math.sin(rad);
            cos = Math.cos(rad);
            float xPos = (float)(x + sin * radius);
            float yPos = (float)(y + cos * radius);
            buffer.m_252986_(matrix4f, xPos, yPos, (float)z).m_7421_((float)(u + sin * texRadius), (float)(v + cos * texRadius)).m_5752_();
            ++i;
        }
        if (percent == 1.0) {
            rad = Math.PI * 2 * (percent + startAngle);
            sin = Math.sin(rad);
            cos = Math.cos(rad);
            buffer.m_252986_(matrix4f, (float)(x + sin * radius), (float)(y + cos * radius), (float)z).m_7421_((float)(u + sin * texRadius), (float)(v + cos * texRadius)).m_5752_();
        }
        tesselator.m_85914_();
        RenderSystem.disableBlend();
        GL11.glDisable((int)2848);
    }

    public static void drawSmoothCircle(GuiGraphics guiGraphics, double x, double y, double radius, int sides, double percent, double startAngle) {
        double cos;
        double sin;
        double rad;
        Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
        double z = 100.0;
        float[] colors = RenderSystem.getShaderColor();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::m_172811_);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_252986_(matrix4f, (float)x, (float)y, (float)z).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_5752_();
        int i = 0;
        while ((double)i <= percent * (double)sides) {
            rad = Math.PI * 2 * ((double)i / (double)sides + startAngle);
            sin = Math.sin(rad);
            cos = Math.cos(rad);
            float xPos = (float)(x + sin * radius);
            float yPos = (float)(y + cos * radius);
            buffer.m_252986_(matrix4f, xPos, yPos, (float)z).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_5752_();
            ++i;
        }
        rad = Math.PI * 2 * (percent + startAngle);
        sin = Math.sin(rad);
        cos = Math.cos(rad);
        buffer.m_252986_(matrix4f, (float)(x + sin * radius), (float)(y + cos * radius), (float)z).m_85950_(colors[0], colors[1], colors[2], 1.0f).m_5752_();
        RenderSystem.disableBlend();
        GL11.glDisable((int)2848);
        tesselator.m_85914_();
    }

    public static void drawTexturedRing(PoseStack stack, double x, double y, double innerRadius, double outerRadius, double u, double v, double texInnerRadius, double texOuterRadius, int sides, double percent, double startAngle) {
        float cos;
        float sin;
        float rad;
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        float z = 100.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShader(GameRenderer::m_172817_);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85817_);
        int i = 0;
        while ((double)i <= percent * (double)sides) {
            rad = (float)(Math.PI * 2 * ((double)i / (double)sides + startAngle));
            sin = (float)Math.sin(rad);
            cos = (float)(-Math.cos(rad));
            buffer.m_252986_(matrix4f, (float)(x + (double)sin * outerRadius), (float)(y + (double)cos * outerRadius), z).m_7421_((float)(u + (double)sin * texOuterRadius), (float)(v + (double)cos * texOuterRadius)).m_5752_();
            buffer.m_252986_(matrix4f, (float)(x + (double)sin * innerRadius), (float)(y + (double)cos * innerRadius), z).m_7421_((float)(u + (double)sin * texInnerRadius), (float)(v + (double)cos * texInnerRadius)).m_5752_();
            ++i;
        }
        rad = (float)(Math.PI * 2 * (percent + startAngle));
        sin = (float)Math.sin(rad);
        cos = (float)(-Math.cos(rad));
        buffer.m_252986_(matrix4f, (float)(x + (double)sin * outerRadius), (float)(y + (double)cos * outerRadius), z).m_7421_((float)(u + (double)sin * texOuterRadius), (float)(v + (double)cos * texOuterRadius)).m_5752_();
        buffer.m_252986_(matrix4f, (float)(x + (double)sin * innerRadius), (float)(y + (double)cos * innerRadius), z).m_7421_((float)(u + (double)sin * texInnerRadius), (float)(v + (double)cos * texInnerRadius)).m_5752_();
        tesselator.m_85914_();
        GL11.glDisable((int)2848);
        RenderSystem.disableBlend();
    }
}

