/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.commands;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonBodies;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.RequestClientData;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncSpinStatus;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncSize;
import by.dragonsurvivalteam.dragonsurvival.network.player.SynchronizeDragonCap;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncAltarCooldown;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.List;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;

public class DragonCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        RootCommandNode rootCommandNode = commandDispatcher.getRoot();
        LiteralCommandNode dragon = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dragon").requires(commandSource -> commandSource.m_6761_(2))).executes(context -> {
            String type = (String)context.getArgument("dragon_type", String.class);
            return DragonCommand.runCommand(type, "central", 1, false, ((CommandSourceStack)context.getSource()).m_81375_());
        })).build();
        ArgumentCommandNode dragonType = ((RequiredArgumentBuilder)Commands.m_82129_((String)"dragon_type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            SuggestionsBuilder builder1 = null;
            for (String value : DragonTypes.getAllSubtypes()) {
                String val = value.toLowerCase(Locale.ENGLISH);
                builder1 = builder1 == null ? builder.suggest(val) : builder1.suggest(val);
            }
            builder1 = builder1 == null ? builder.suggest("human") : builder1.suggest("human");
            return builder1.buildFuture();
        }).executes(context -> {
            String type = (String)context.getArgument("dragon_type", String.class);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            return DragonCommand.runCommand(type, "central", 1, false, serverPlayer);
        })).build();
        ArgumentCommandNode dragonBody = ((RequiredArgumentBuilder)Commands.m_82129_((String)"dragon_body", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            SuggestionsBuilder sgBuilder = null;
            for (String val : DragonBodies.getBodies()) {
                sgBuilder = sgBuilder == null ? builder.suggest(val) : sgBuilder.suggest(val.toLowerCase(Locale.ENGLISH));
            }
            return sgBuilder.buildFuture();
        }).executes(context -> {
            String type = (String)context.getArgument("dragon_type", String.class);
            String body = (String)context.getArgument("dragon_body", String.class);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            return DragonCommand.runCommand(type, body, 1, false, serverPlayer);
        })).build();
        ArgumentCommandNode dragonStage = ((RequiredArgumentBuilder)Commands.m_82129_((String)"dragon_stage", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).suggests((context, builder) -> builder.suggest(1).suggest(2).suggest(3).suggest(4).buildFuture()).executes(context -> {
            String type = (String)context.getArgument("dragon_type", String.class);
            String body = (String)context.getArgument("dragon_body", String.class);
            int stage = (Integer)context.getArgument("dragon_stage", Integer.TYPE);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            return DragonCommand.runCommand(type, body, stage, false, serverPlayer);
        })).build();
        ArgumentCommandNode giveFlight = ((RequiredArgumentBuilder)Commands.m_82129_((String)"flight", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            String type = (String)context.getArgument("dragon_type", String.class);
            String body = (String)context.getArgument("dragon_body", String.class);
            int stage = (Integer)context.getArgument("dragon_stage", Integer.TYPE);
            boolean flight = (Boolean)context.getArgument("flight", Boolean.TYPE);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            return DragonCommand.runCommand(type, body, stage, flight, serverPlayer);
        })).build();
        ArgumentCommandNode target = ((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            String type = (String)context.getArgument("dragon_type", String.class);
            String body = (String)context.getArgument("dragon_body", String.class);
            int stage = (Integer)context.getArgument("dragon_stage", Integer.TYPE);
            boolean flight = (Boolean)context.getArgument("flight", Boolean.TYPE);
            EntitySelector selector = (EntitySelector)context.getArgument("target", EntitySelector.class);
            List serverPlayers = selector.m_121166_((CommandSourceStack)context.getSource());
            serverPlayers.forEach(player -> DragonCommand.runCommand(type, body, stage, flight, player));
            return 1;
        })).build();
        rootCommandNode.addChild((CommandNode)dragon);
        dragon.addChild((CommandNode)dragonType);
        dragonType.addChild((CommandNode)dragonBody);
        dragonBody.addChild((CommandNode)dragonStage);
        dragonStage.addChild((CommandNode)giveFlight);
        giveFlight.addChild((CommandNode)target);
    }

    private static int runCommand(String type, String body, int stage, boolean flight, ServerPlayer player) {
        AbstractDragonBody dragonBody;
        DragonStateHandler cap = DragonUtils.getHandler((Entity)player);
        AbstractDragonType dragonType1 = type.equalsIgnoreCase("human") ? null : DragonTypes.getStaticSubtype(type);
        AbstractDragonBody abstractDragonBody = dragonBody = body.equalsIgnoreCase("none") ? null : DragonBodies.getStatic(body);
        if (dragonType1 == null && cap.getType() != null) {
            DragonCommand.reInsertClawTools((Player)player, cap);
        }
        cap.setType(dragonType1, (Player)player);
        cap.setBody(dragonBody, (Player)player);
        cap.setHasFlight(flight);
        cap.getMovementData().spinLearned = flight;
        DragonLevel dragonLevel = DragonLevel.values()[Mth.m_14045_((int)(stage - 1), (int)0, (int)(DragonLevel.values().length - 1))];
        float size = stage == 4 ? 40.0f : (float)dragonLevel.size;
        cap.setSize(size, (Player)player);
        cap.setPassengerId(-1);
        cap.growing = true;
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncAltarCooldown(player.m_19879_(), Functions.secondsToTicks(ServerConfig.altarUsageCooldown)));
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SynchronizeDragonCap(player.m_19879_(), cap.isHiding(), cap.getType(), cap.getBody(), cap.getSize(), cap.hasFlight(), 0));
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSpinStatus(player.m_19879_(), cap.getMovementData().spinAttack, cap.getMovementData().spinCooldown, cap.getMovementData().spinLearned));
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSize(player.m_19879_(), size));
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestClientData(cap.getType(), cap.getBody(), cap.getLevel()));
        player.m_6210_();
        return 1;
    }

    public static void reInsertClawTools(Player player, DragonStateHandler dragonStateHandler) {
        for (int i = 0; i < 4; ++i) {
            ServerPlayer serverPlayer;
            ItemStack stack = dragonStateHandler.getClawToolData().getClawsInventory().m_8020_(i);
            if (!(player instanceof ServerPlayer) || (serverPlayer = (ServerPlayer)player).m_36356_(stack)) continue;
            serverPlayer.m_9236_().m_7967_((Entity)new ItemEntity(serverPlayer.m_9236_(), serverPlayer.m_20182_().f_82479_, serverPlayer.m_20182_().f_82480_, serverPlayer.m_20182_().f_82481_, stack));
        }
        dragonStateHandler.getClawToolData().getClawsInventory().m_6211_();
    }
}

