/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.data.DataBlockTagProvider;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DragonDoor
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final EnumProperty<DragonDoorOpenRequirement> OPEN_REQ = EnumProperty.m_61587_((String)"open_req", DragonDoorOpenRequirement.class);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public DragonDoor(BlockBehaviour.Properties properties, DragonDoorOpenRequirement DragonDoorOpenRequirement2) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)Part.BOTTOM))).m_61124_(OPEN_REQ, (Comparable)((Object)DragonDoorOpenRequirement2))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: 
            case AIR: {
                return (Boolean)state.m_61143_((Property)OPEN);
            }
        }
        return false;
    }

    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (facing.m_122434_() == Direction.Axis.Y && stateIn.m_60713_(facingState.m_60734_())) {
            return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING)))).m_61124_((Property)OPEN, (Comparable)((Boolean)facingState.m_61143_((Property)OPEN)))).m_61124_(HINGE, (Comparable)((DoorHingeSide)facingState.m_61143_(HINGE)))).m_61124_((Property)POWERED, (Comparable)((Boolean)facingState.m_61143_((Property)POWERED)));
        }
        return this.m_7898_(stateIn, (LevelReader)level, currentPos) ? super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos) : Blocks.f_50016_.m_49966_();
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean validType;
        boolean validPower = state.m_61143_(OPEN_REQ) == DragonDoorOpenRequirement.NONE || state.m_61143_(OPEN_REQ) == DragonDoorOpenRequirement.POWER;
        boolean bl = validType = state.m_61143_(OPEN_REQ) == DragonDoorOpenRequirement.SEA && blockIn == DSBlocks.seaPressurePlate || state.m_61143_(OPEN_REQ) == DragonDoorOpenRequirement.FOREST && blockIn == DSBlocks.forestPressurePlate || state.m_61143_(OPEN_REQ) == DragonDoorOpenRequirement.CAVE && blockIn == DSBlocks.cavePressurePlate;
        if (validPower || validType) {
            boolean flag;
            boolean bl2 = worldIn.m_276867_(pos) || worldIn.m_276867_(pos.m_121945_(state.m_61143_(PART) == Part.BOTTOM ? Direction.UP : Direction.DOWN)) ? true : (flag = false);
            if (blockIn != this && flag != (Boolean)state.m_61143_((Property)POWERED)) {
                if (flag != (Boolean)state.m_61143_((Property)OPEN)) {
                    this.playSound(null, worldIn, pos, state, flag);
                }
                worldIn.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag)), 2);
            }
        }
    }

    private void playSound(@Nullable Entity entity, Level level, BlockPos blockPosition, BlockState blockState, boolean isOpening) {
        level.m_245803_(entity, blockPosition, this.getSound(blockState, isOpening), SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    private SoundEvent getSound(BlockState blockState, boolean isOpening) {
        if (blockState.m_204336_(DataBlockTagProvider.WOODEN_DRAGON_DOORS)) {
            return isOpening ? SoundEvents.f_12627_ : SoundEvents.f_12626_;
        }
        return isOpening ? SoundEvents.f_12056_ : SoundEvents.f_12055_;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        boolean canOpen;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        switch ((DragonDoorOpenRequirement)((Object)blockState.m_61143_(OPEN_REQ))) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                boolean bl = true;
                break;
            }
            case CAVE: {
                boolean bl = DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.CAVE);
                break;
            }
            case FOREST: {
                boolean bl = DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.FOREST);
                break;
            }
            case SEA: {
                boolean bl = DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.SEA);
                break;
            }
            case POWER: {
                boolean bl = true;
                break;
            }
            case LOCKED: {
                boolean bl = canOpen = true;
            }
        }
        if (canOpen) {
            blockState = (BlockState)((BlockState)blockState.m_61122_((Property)OPEN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
            level.m_7731_(blockPos, blockState, 10);
            this.playSound((Entity)player, level, blockPos, blockState, (Boolean)blockState.m_61143_((Property)OPEN));
            if (blockState.m_61143_(PART) == Part.TOP) {
                level.m_7731_(blockPos.m_6625_(2), (BlockState)((BlockState)blockState.m_61124_(PART, (Comparable)((Object)Part.BOTTOM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockPos.m_6625_(2)).m_76152_() == Fluids.f_76193_)), 10);
                level.m_7731_(blockPos.m_7495_(), (BlockState)((BlockState)blockState.m_61124_(PART, (Comparable)((Object)Part.MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(blockPos.m_7495_()).m_76152_() == Fluids.f_76193_)), 10);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return state.m_61143_(OPEN_REQ) == DragonDoorOpenRequirement.NONE ? PushReaction.DESTROY : PushReaction.IGNORE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (BlockState)state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING))).m_61122_(HINGE);
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(PART) == Part.BOTTOM ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (state.m_61143_(PART) == Part.BOTTOM) {
            return blockstate.m_60783_((BlockGetter)worldIn, blockpos, Direction.UP);
        }
        return blockstate.m_60734_() == this;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean flag = (Boolean)state.m_61143_((Property)OPEN) == false;
        boolean flag1 = state.m_61143_(HINGE) == DoorHingeSide.RIGHT;
        switch (direction) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        if (blockpos.m_123342_() < 255 && context.m_43725_().m_8055_(blockpos.m_7494_()).m_60629_(context) && context.m_43725_().m_8055_(blockpos.m_6630_(2)).m_60629_(context)) {
            Level world = context.m_43725_();
            boolean flag = world.m_276867_(blockpos) || world.m_276867_(blockpos.m_7494_());
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HINGE, (Comparable)this.getHinge(context))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(flag))).m_61124_(PART, (Comparable)((Object)Part.BOTTOM))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_ && context.m_43725_().m_8055_(blockpos).m_60734_() == DSBlocks.seaDoor));
        }
        return null;
    }

    private DoorHingeSide getHinge(BlockPlaceContext blockItemUseContext) {
        boolean flag1;
        Level iblockreader = blockItemUseContext.m_43725_();
        BlockPos blockpos = blockItemUseContext.m_8083_();
        Direction direction = blockItemUseContext.m_8125_();
        BlockPos blockpos1 = blockpos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = blockpos.m_121945_(direction1);
        BlockState blockstate = iblockreader.m_8055_(blockpos2);
        BlockPos blockpos3 = blockpos1.m_121945_(direction1);
        BlockState blockstate1 = iblockreader.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = blockpos.m_121945_(direction2);
        BlockState blockstate2 = iblockreader.m_8055_(blockpos4);
        BlockPos blockpos5 = blockpos1.m_121945_(direction2);
        BlockState blockstate3 = iblockreader.m_8055_(blockpos5);
        int i = (blockstate.m_60838_((BlockGetter)iblockreader, blockpos2) ? -1 : 0) + (blockstate1.m_60838_((BlockGetter)iblockreader, blockpos3) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)iblockreader, blockpos4) ? 1 : 0) + (blockstate3.m_60838_((BlockGetter)iblockreader, blockpos5) ? 1 : 0);
        boolean flag = blockstate.m_60713_((Block)this) && blockstate.m_61143_(PART) == Part.BOTTOM;
        boolean bl = flag1 = blockstate2.m_60713_((Block)this) && blockstate2.m_61143_(PART) == Part.BOTTOM;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3d = blockItemUseContext.m_43720_();
                double d0 = vec3d.f_82479_ - (double)blockpos.m_123341_();
                double d1 = vec3d.f_82481_ - (double)blockpos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public void m_6240_(Level worldIn, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(worldIn, player, pos, Blocks.f_50016_.m_49966_(), te, stack);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)Part.MIDDLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_)), 3);
        worldIn.m_7731_(pos.m_6630_(2), (BlockState)((BlockState)state.m_61124_(PART, (Comparable)((Object)Part.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.m_6425_(pos.m_6630_(2)).m_76152_() == Fluids.f_76193_)), 3);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        if (!worldIn.m_5776_()) {
            BlockPos bottomPos;
            BlockState bottomState;
            Part part = (Part)((Object)state.m_61143_(PART));
            if (part != Part.MIDDLE && !player.m_7500_()) {
                BlockPos middlePos = part == Part.BOTTOM ? pos.m_7494_() : pos.m_7495_();
                BlockState middleState = worldIn.m_8055_(middlePos);
                if (middleState.m_60734_() == state.m_60734_()) {
                    worldIn.m_7731_(middlePos, Blocks.f_50016_.m_49966_(), 35);
                    worldIn.m_5898_(player, 2001, middlePos, Block.m_49956_((BlockState)middleState));
                }
            } else if (part != Part.BOTTOM && player.m_7500_() && (bottomState = worldIn.m_8055_(bottomPos = part == Part.MIDDLE ? pos.m_7495_() : pos.m_6625_(2))).m_60734_() == state.m_60734_()) {
                worldIn.m_7731_(bottomPos, Blocks.f_50016_.m_49966_(), 35);
                worldIn.m_5898_(player, 2001, bottomPos, Block.m_49956_((BlockState)bottomState));
            }
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PART, FACING, OPEN, HINGE, POWERED, OPEN_REQ, WATERLOGGED});
    }

    public static enum Part implements StringRepresentable
    {
        BOTTOM,
        MIDDLE,
        TOP;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum DragonDoorOpenRequirement implements StringRepresentable
    {
        NONE,
        POWER,
        CAVE,
        FOREST,
        SEA,
        LOCKED;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

