/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class DragonPressurePlates
extends PressurePlateBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public PressurePlateType type;

    public DragonPressurePlates(BlockBehaviour.Properties p_i48445_1_, PressurePlateType type) {
        super(PressurePlateBlock.Sensitivity.EVERYTHING, p_i48445_1_, BlockSetType.f_271400_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_55249_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return f_49285_;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState state2, LevelAccessor level, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, dir, state2, level, pos, pos2);
    }

    protected int m_6693_(Level pLevel, BlockPos pPos) {
        AABB axisalignedbb = f_49287_.m_82338_(pPos);
        List list = pLevel.m_45933_(null, axisalignedbb);
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                if (entity.m_6090_()) continue;
                return switch (this.type) {
                    default -> throw new IncompatibleClassChangeError();
                    case PressurePlateType.DRAGON -> {
                        if (DragonUtils.isDragon(entity)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case PressurePlateType.HUMAN -> {
                        if (!DragonUtils.isDragon(entity)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case PressurePlateType.SEA -> {
                        if (DragonUtils.isDragonType(entity, (AbstractDragonType)DragonTypes.SEA)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case PressurePlateType.FOREST -> {
                        if (DragonUtils.isDragonType(entity, (AbstractDragonType)DragonTypes.FOREST)) {
                            yield 15;
                        }
                        yield 0;
                    }
                    case PressurePlateType.CAVE -> DragonUtils.isDragonType(entity, (AbstractDragonType)DragonTypes.CAVE) ? 15 : 0;
                };
            }
        }
        return 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{FACING});
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        if (state.m_61138_((Property)FACING)) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_());
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, @NotNull Rotation rotation) {
        if (state.m_61138_((Property)FACING)) {
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
        }
        return state;
    }

    @NotNull
    public BlockState m_6943_(BlockState state, @NotNull Mirror mirror) {
        if (state.m_61138_((Property)FACING)) {
            return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
        }
        return state;
    }

    public static enum PressurePlateType {
        DRAGON,
        HUMAN,
        SEA,
        CAVE,
        FOREST;

    }
}

