/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.blocks;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncMagicSourceStatus;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.DSTileEntities;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicPlaceholder;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicTileEntity;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.SpawningUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class SourceOfMagicBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final VoxelShape SHAPE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.25, (double)1.0);
    public static final VoxelShape OUTLINE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
    public static final VoxelShape FULL_OUTLINE = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.99, (double)1.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty PRIMARY_BLOCK = BooleanProperty.m_61465_((String)"primary");
    public static final BooleanProperty FILLED = BooleanProperty.m_61465_((String)"filled");
    static final BooleanProperty BACK_BLOCK = BooleanProperty.m_61465_((String)"back");
    static final BooleanProperty TOP_BLOCK = BooleanProperty.m_61465_((String)"top");

    public SourceOfMagicBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PRIMARY_BLOCK, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BACK_BLOCK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOP_BLOCK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)));
    }

    private static void breakBlock(Level world, BlockPos pos) {
        world.m_46961_(pos, !(world.m_7702_(pos) instanceof SourceOfMagicPlaceholder));
        world.m_46747_(pos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos position, RandomSource random) {
        if (state.m_60734_() == DSBlocks.caveSourceOfMagic) {
            if (level.m_6425_(position).m_205070_(FluidTags.f_13131_)) {
                double d0 = position.m_123341_();
                double d1 = position.m_123342_();
                double d2 = position.m_123343_();
                level.m_7107_((ParticleOptions)ParticleTypes.f_123774_, d0 + 0.5, d1, d2 + 0.5, 0.0, 0.04, 0.0);
                level.m_7107_((ParticleOptions)ParticleTypes.f_123774_, d0 + (double)random.m_188501_(), d1 + (double)random.m_188501_(), d2 + (double)random.m_188501_(), 0.0, 0.04, 0.0);
            } else if (((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
                double d0 = position.m_123341_();
                double d1 = position.m_123342_();
                double d2 = position.m_123343_();
                level.m_7107_((ParticleOptions)ParticleTypes.f_123756_, d0 + (double)random.m_188501_(), d1 + (double)random.m_188501_(), d2 + (double)random.m_188501_(), 0.0, 0.04, 0.0);
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState superState = null;
        BlockPos blockPos = context.m_8083_();
        Level world = context.m_43725_();
        Player playerEntity = context.m_43723_();
        Direction direction = playerEntity.m_6350_();
        if (SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction.m_122428_()), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction).m_121945_(direction.m_122428_()), world, context)) {
            superState = (BlockState)super.m_5573_(context).m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
        }
        if (superState != null) {
            if (SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction.m_122424_()), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction).m_121945_(direction.m_122427_()), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction.m_122427_()), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122428_()), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122427_()), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction).m_7494_(), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction).m_7494_().m_121945_(direction.m_122427_()), world, context) && SpawningUtils.isAirOrFluid(blockPos.m_121945_(direction).m_7494_().m_121945_(direction.m_122428_()), world, context)) {
                return superState;
            }
            if (world.m_5776_()) {
                playerEntity.m_213846_((Component)Component.m_237115_((String)"ds.space.occupied"));
            }
        }
        return null;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (placer != null) {
            Direction direction = placer.m_6350_();
            SourceOfMagicBlock.setPlaceholder(worldIn, state, pos, pos.m_121945_(direction.m_122424_()));
            SourceOfMagicBlock.setPlaceholder(worldIn, (BlockState)state.m_61124_((Property)BACK_BLOCK, (Comparable)Boolean.valueOf(true)), pos, pos.m_121945_(direction));
            SourceOfMagicBlock.setPlaceholder(worldIn, state, pos, pos.m_121945_(direction.m_122427_()));
            SourceOfMagicBlock.setPlaceholder(worldIn, state, pos, pos.m_121945_(direction.m_122428_()));
            SourceOfMagicBlock.setPlaceholder(worldIn, (BlockState)state.m_61124_((Property)BACK_BLOCK, (Comparable)Boolean.valueOf(true)), pos, pos.m_121945_(direction).m_121945_(direction.m_122427_()));
            SourceOfMagicBlock.setPlaceholder(worldIn, (BlockState)state.m_61124_((Property)BACK_BLOCK, (Comparable)Boolean.valueOf(true)), pos, pos.m_121945_(direction).m_121945_(direction.m_122428_()));
            SourceOfMagicBlock.setPlaceholder(worldIn, state, pos, pos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122428_()));
            SourceOfMagicBlock.setPlaceholder(worldIn, state, pos, pos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122427_()));
            SourceOfMagicBlock.setPlaceholder(worldIn, (BlockState)state.m_61124_((Property)TOP_BLOCK, (Comparable)Boolean.valueOf(true)), pos, pos.m_7494_().m_121945_(direction));
            SourceOfMagicBlock.setPlaceholder(worldIn, state, pos, pos.m_7494_().m_121945_(direction).m_121945_(direction.m_122428_()));
            SourceOfMagicBlock.setPlaceholder(worldIn, state, pos, pos.m_7494_().m_121945_(direction).m_121945_(direction.m_122427_()));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{f_54117_, WATERLOGGED, PRIMARY_BLOCK, BACK_BLOCK, TOP_BLOCK, FILLED});
    }

    private static void setPlaceholder(Level world, BlockState state, BlockPos root, BlockPos newPos) {
        world.m_46597_(newPos, (BlockState)state.m_61124_((Property)PRIMARY_BLOCK, (Comparable)Boolean.valueOf(false)));
        SourceOfMagicPlaceholder placeHolder6 = (SourceOfMagicPlaceholder)world.m_7702_(newPos);
        placeHolder6.rootPos = root;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor world, BlockPos blockPos, BlockPos blockPos1) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(blockState, direction, blockState1, world, blockPos, blockPos1);
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.m_60734_() instanceof SourceOfMagicBlock)) {
            if (((Boolean)state.m_61143_((Property)PRIMARY_BLOCK)).booleanValue()) {
                BlockEntity tileentity = worldIn.m_7702_(pos);
                if (tileentity instanceof Container) {
                    Containers.m_19002_((Level)worldIn, (BlockPos)pos, (Container)((Container)tileentity));
                    worldIn.m_46717_(pos, (Block)this);
                }
                super.m_6810_(state, worldIn, pos, newState, isMoving);
                Direction direction = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
                SourceOfMagicBlock.breakBlock(worldIn, pos);
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_121945_(direction.m_122424_()));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_121945_(direction));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_121945_(direction.m_122427_()));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_121945_(direction.m_122428_()));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_121945_(direction).m_121945_(direction.m_122427_()));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_121945_(direction).m_121945_(direction.m_122428_()));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122428_()));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_121945_(direction.m_122424_()).m_121945_(direction.m_122427_()));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_7494_().m_121945_(direction));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_7494_().m_121945_(direction).m_121945_(direction.m_122428_()));
                SourceOfMagicBlock.breakBlock(worldIn, pos.m_7494_().m_121945_(direction).m_121945_(direction.m_122427_()));
            } else {
                BlockEntity tile = worldIn.m_7702_(pos);
                if (tile instanceof SourceOfMagicPlaceholder) {
                    SourceOfMagicPlaceholder placeholder = (SourceOfMagicPlaceholder)tile;
                    BlockPos rootPos = placeholder.rootPos;
                    if (worldIn.m_7702_(rootPos) instanceof SourceOfMagicTileEntity) {
                        this.m_6810_(worldIn.m_8055_(rootPos), worldIn, rootPos, Blocks.f_50628_.m_49966_(), isMoving);
                    }
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        BlockPos pos1 = pos;
        if (blockEntity instanceof SourceOfMagicPlaceholder) {
            pos1 = ((SourceOfMagicPlaceholder)blockEntity).rootPos;
        }
        if (!player.m_6047_()) {
            if (player instanceof ServerPlayer) {
                BlockPos finalPos = pos1;
                SourceOfMagicTileEntity blockEntity1 = this.getBlockEntity(worldIn, pos1);
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity1, packetBuffer -> packetBuffer.m_130064_(finalPos));
            }
        } else if (DragonUtils.isDragon((Entity)player) && player.m_21205_().m_41619_() && player.m_146900_().m_60734_() == state.m_60734_()) {
            SourceOfMagicTileEntity source;
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            if (!handler.getMagicData().onMagicSource && (source = this.getBlockEntity(worldIn, pos1)) != null && !source.m_7983_() && worldIn.m_5776_()) {
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncMagicSourceStatus(player.m_19879_(), true, 0));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_8133_(BlockState pState, Level pLevel, BlockPos pPos, int pId, int pParam) {
        super.m_8133_(pState, pLevel, pPos, pId, pParam);
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        return blockentity != null && blockentity.m_7531_(pId, pParam);
    }

    public RenderShape m_7514_(BlockState state) {
        return (Boolean)state.m_61143_((Property)PRIMARY_BLOCK) != false ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState pState, Level pLevel, BlockPos pPos) {
        BlockEntity blockentity = pLevel.m_7702_(pPos);
        return blockentity instanceof MenuProvider ? (MenuProvider)blockentity : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)TOP_BLOCK) != false || (Boolean)state.m_61143_((Property)BACK_BLOCK) != false ? FULL_OUTLINE : OUTLINE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)TOP_BLOCK) != false ? FULL_OUTLINE : SHAPE;
    }

    public void m_213898_(BlockState p_225542_1_, ServerLevel world, BlockPos pos, RandomSource p_225542_4_) {
        BlockPos blockpos = pos.m_7494_();
        if (world.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            world.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (world.f_46441_.m_188501_() - world.f_46441_.m_188501_()) * 0.8f);
            world.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.25, (double)blockpos.m_123343_() + 0.5, 8, 0.5, 0.25, 0.5, 0.0);
        }
    }

    public void m_7892_(BlockState pState, Level world, BlockPos pos, Entity entity) {
        SourceOfMagicTileEntity source;
        BlockEntity blockEntity = world.m_7702_(pos);
        BlockPos pos1 = pos;
        if (blockEntity instanceof SourceOfMagicPlaceholder) {
            pos1 = ((SourceOfMagicPlaceholder)blockEntity).rootPos;
        }
        if ((source = this.getBlockEntity(world, pos1)) != null && SourceOfMagicBlock.shouldHarmPlayer(pState, entity)) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemE = (ItemEntity)entity;
                ItemStack stack = itemE.m_32055_();
                ItemStack tileStack = source.m_8020_(0);
                if (SourceOfMagicTileEntity.consumables.containsKey(stack.m_41720_())) {
                    if (source.m_7983_()) {
                        source.m_6836_(0, stack);
                        itemE.m_6074_();
                    } else if (ItemStack.m_41656_((ItemStack)tileStack, (ItemStack)stack) && tileStack.m_41613_() < tileStack.m_41741_()) {
                        int left = tileStack.m_41741_() - tileStack.m_41613_();
                        int toAdd = Math.min(stack.m_41613_(), left);
                        itemE.m_32055_().m_41774_(toAdd);
                        tileStack.m_41764_(tileStack.m_41613_() + toAdd);
                    }
                    return;
                }
            }
            if (ServerConfig.damageWrongSourceOfMagic.booleanValue()) {
                entity.m_6469_(pState.m_60734_() == DSBlocks.caveSourceOfMagic ? entity.m_269291_().m_269047_() : (pState.m_60734_() == DSBlocks.seaSourceOfMagic ? entity.m_269291_().m_269063_() : entity.m_269291_().m_269325_()), 1.0f);
            }
        }
        super.m_7892_(pState, world, pos, entity);
    }

    public static boolean shouldHarmPlayer(BlockState state, Entity entity) {
        DragonStateHandler handler = DragonStateProvider.getHandler(entity);
        AbstractDragonType type = handler != null ? handler.getType() : null;
        Block block = state.m_60734_();
        if (block == DSBlocks.caveSourceOfMagic && !DragonUtils.isDragonType(type, (AbstractDragonType)DragonTypes.CAVE)) {
            return true;
        }
        if (block == DSBlocks.seaSourceOfMagic && !DragonUtils.isDragonType(type, (AbstractDragonType)DragonTypes.SEA)) {
            return true;
        }
        return block == DSBlocks.forestSourceOfMagic && !DragonUtils.isDragonType(type, (AbstractDragonType)DragonTypes.FOREST);
    }

    public SourceOfMagicTileEntity getBlockEntity(Level world, BlockPos pos) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof SourceOfMagicTileEntity ? (SourceOfMagicTileEntity)entity : null;
    }

    public boolean m_7361_(@NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockState state, @NotNull FluidState fluidState) {
        if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && fluidState.m_76152_() == Fluids.f_76193_) {
            if (!level.m_5776_()) {
                level.m_7731_(position, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.TRUE), 3);
                level.m_186469_(position, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack m_142598_(@NotNull LevelAccessor level, @NotNull BlockPos position, @NotNull BlockState state) {
        BlockEntity blockEntity;
        BlockEntity entity = level.m_7702_(position);
        BlockPos rootPosition = null;
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_7731_(position, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
            return Items.f_42447_.m_7968_();
        }
        if (entity instanceof SourceOfMagicPlaceholder) {
            SourceOfMagicPlaceholder placeholder = (SourceOfMagicPlaceholder)entity;
            rootPosition = placeholder.rootPos;
        } else if (entity instanceof SourceOfMagicTileEntity) {
            SourceOfMagicTileEntity source = (SourceOfMagicTileEntity)entity;
            return this.updateAndTakeLiquid(level, position, state, source);
        }
        if (rootPosition != null && (blockEntity = level.m_7702_(rootPosition)) instanceof SourceOfMagicTileEntity) {
            SourceOfMagicTileEntity source = (SourceOfMagicTileEntity)blockEntity;
            return this.updateAndTakeLiquid(level, rootPosition, level.m_8055_(rootPosition), source);
        }
        return ItemStack.f_41583_;
    }

    private ItemStack updateAndTakeLiquid(LevelAccessor level, BlockPos position, BlockState state, SourceOfMagicTileEntity source) {
        if (!((Boolean)state.m_61143_((Property)FILLED)).booleanValue()) {
            return ItemStack.f_41583_;
        }
        level.m_7731_(position, (BlockState)state.m_61124_((Property)FILLED, (Comparable)Boolean.valueOf(false)), 3);
        Item item = source.m_8020_(0).m_41720_();
        Block block = state.m_60734_();
        boolean decrementStack = false;
        if (item == DSItems.elderDragonDust) {
            decrementStack = true;
        } else if (item == DSItems.elderDragonBone) {
            decrementStack = level.m_213780_().m_188503_(3) == 0;
        } else if (item == DSItems.dragonHeartShard) {
            decrementStack = level.m_213780_().m_188503_(5) == 0;
        } else if (item == DSItems.weakDragonHeart) {
            decrementStack = level.m_213780_().m_188503_(15) == 0;
        } else if (item == DSItems.elderDragonHeart) {
            boolean bl = decrementStack = level.m_213780_().m_188503_(50) == 0;
        }
        if (decrementStack) {
            source.m_7407_(0, 1);
        }
        if (block == DSBlocks.caveSourceOfMagic) {
            return Items.f_42448_.m_7968_();
        }
        if (block == DSBlocks.seaSourceOfMagic || block == DSBlocks.forestSourceOfMagic) {
            return Items.f_42447_.m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (!((Boolean)pState.m_61143_((Property)PRIMARY_BLOCK)).booleanValue()) {
            return DSTileEntities.sourceOfMagicPlaceholder.m_155264_(pPos, pState);
        }
        return DSTileEntities.sourceOfMagicTileEntity.m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return pLevel.m_5776_() ? null : BaseEntityBlock.m_152132_(pBlockEntityType, DSTileEntities.sourceOfMagicTileEntity, SourceOfMagicTileEntity::serverTick);
    }
}

