/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability;

import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.VillageRelationShips;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.RequestClientData;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawsMenu;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncSize;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.CompleteDataSync;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonModifiers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Capabilities {
    public static Capability<VillageRelationShips> VILLAGE_RELATIONSHIP = CapabilityManager.get((CapabilityToken)new CapabilityToken<VillageRelationShips>(){});
    public static Capability<DragonStateHandler> GENERIC_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DragonStateHandler>(){});
    public static Capability<EntityStateHandler> ENTITY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<EntityStateHandler>(){});
    public static Capability<DragonStateHandler> DRAGON_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<DragonStateHandler>(){});

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.m_9236_().m_5776_() && Capabilities.isFakePlayer(player)) {
                return;
            }
            DragonStateProvider provider = new DragonStateProvider();
            event.addCapability(new ResourceLocation("dragonsurvival", "playerstatehandler"), (ICapabilityProvider)provider);
        } else if (entity instanceof LivingEntity) {
            EntityStateProvider provider = new EntityStateProvider();
            event.addCapability(new ResourceLocation("dragonsurvival", "entitystatehandler"), (ICapabilityProvider)provider);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean isFakePlayer(Player player) {
        return player instanceof FakeClientPlayer;
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            DragonStateProvider.getCap((Entity)serverPlayer).ifPresent(handler -> {
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new RequestClientData(handler.getType(), handler.getBody(), handler.getLevel()));
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SyncDragonClawsMenu(serverPlayer.m_19879_(), handler.getClawToolData().isMenuOpen(), handler.getClawToolData().getClawsInventory()));
            });
            Capabilities.syncCapability((Player)serverPlayer);
            DragonModifiers.updateModifiers((Player)serverPlayer);
        }
    }

    public static void syncCapability(Player player) {
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new CompleteDataSync(player));
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent playerRespawnEvent) {
        Player player = playerRespawnEvent.getEntity();
        Capabilities.syncCapability(player);
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSize(player.m_19879_(), cap.getSize())));
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        Capabilities.syncCapability(player);
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> cap.getSkinData().compileSkin());
    }

    @SubscribeEvent
    public static void onTrackingStart(PlayerEvent.StartTracking startTracking) {
        Player trackingPlayer = startTracking.getEntity();
        if (trackingPlayer instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)trackingPlayer;
            Entity tracked = startTracking.getTarget();
            if (tracked instanceof ServerPlayer) {
                DragonStateProvider.getCap(tracked).ifPresent(dragonStateHandler -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> target), (Object)new CompleteDataSync(tracked.m_19879_(), dragonStateHandler.writeNBT())));
            }
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone e) {
        Player player = e.getEntity();
        Player original = e.getOriginal();
        original.reviveCaps();
        DragonStateProvider.getCap((Entity)player).ifPresent(capNew -> original.getCapability(DRAGON_CAPABILITY).ifPresent(capOld -> {
            CompoundTag nbt = capOld.writeNBT();
            capNew.readNBT(nbt);
            capNew.getSkinData().compileSkin();
            if (ServerConfig.preserveRoyalChaseEffectAfterDeath.booleanValue() && capOld.getVillageRelationShips().evilStatusDuration > 0) {
                player.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, capOld.getVillageRelationShips().evilStatusDuration));
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new CompleteDataSync(player.m_19879_(), nbt));
        }));
        DragonModifiers.updateModifiers(player);
        original.invalidateCaps();
        player.m_6210_();
    }

    @SubscribeEvent
    public static void clearCache(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.clearCache(player);
        }
    }
}

