/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability;

import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.objects.DragonMovementData;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.ClawInventory;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.EmoteCap;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.MagicCap;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.SkinCap;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.SubCap;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.VillageRelationShips;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonBodies;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonModifiers;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;

public class DragonStateHandler
extends EntityStateHandler {
    public static final int NO_ENTITY = -1;
    public final Supplier<SubCap>[] caps = new Supplier[]{this::getSkinData, this::getMagicData, this::getEmoteData, this::getClawToolData, this::getVillageRelationShips};
    public ItemStack storedMainHandWeapon = ItemStack.f_41583_;
    public boolean switchedWeapon;
    public ItemStack storedMainHandTool = ItemStack.f_41583_;
    public boolean switchedTool;
    public int switchedToolSlot = -1;
    public int toolSwapLayer;
    public boolean hasFlown;
    public boolean growing = true;
    public boolean treasureResting;
    public int treasureRestTimer;
    public int treasureSleepTimer;
    public int altarCooldown;
    public boolean hasUsedAltar;
    public boolean refreshBody;
    public int lastSync;
    private final DragonMovementData movementData = new DragonMovementData(0.0, 0.0, 0.0, false);
    private final ClawInventory clawToolData = new ClawInventory(this);
    private final EmoteCap emoteData = new EmoteCap(this);
    private final MagicCap magicData = new MagicCap(this);
    private final SkinCap skinData = new SkinCap(this);
    private final VillageRelationShips villageRelationShips = new VillageRelationShips(this);
    private final Map<String, Double> savedDragonSize = new ConcurrentHashMap<String, Double>();
    private AbstractDragonType dragonType;
    private AbstractDragonBody dragonBody;
    private int passengerId = -1;
    private boolean isHiding;
    private boolean hasFlight;
    private boolean areWingsSpread;
    private double size;

    public void setSize(double size, Player player) {
        this.setSize(size);
        this.updateModifiers(player);
    }

    private void updateModifiers(Player player) {
        if (this.isDragon()) {
            DragonModifiers.updateSizeModifiers(player);
        } else {
            this.checkAndRemoveModifier(player.m_21051_(Attributes.f_22276_), DragonModifiers.getHealthModifier(player));
            this.checkAndRemoveModifier(player.m_21051_(Attributes.f_22281_), DragonModifiers.getDamageModifier(player));
            this.checkAndRemoveModifier(player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()), DragonModifiers.getSwimSpeedModifier(player));
            this.checkAndRemoveModifier(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()), DragonModifiers.getBlockReachModifier(player));
            this.checkAndRemoveModifier(player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()), DragonModifiers.getEntityReachModifier(player));
            this.checkAndRemoveModifier(player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), DragonModifiers.getStepHeightModifier(player));
        }
    }

    private void checkAndRemoveModifier(@Nullable AttributeInstance attribute, @Nullable AttributeModifier modifier) {
        if (attribute != null && modifier != null && attribute.m_22109_(modifier)) {
            attribute.m_22130_(modifier);
        }
    }

    public void setFreeLook(boolean isFreeLook) {
        this.movementData.wasFreeLook = this.movementData.isFreeLook;
        this.movementData.isFreeLook = isFreeLook;
    }

    public void setFirstPerson(boolean isFirstPerson) {
        this.movementData.isFirstPerson = isFirstPerson;
    }

    public void setBite(boolean bite) {
        this.movementData.bite = bite;
    }

    public void setDesiredMoveVec(Vec2 desiredMoveVec) {
        this.movementData.desiredMoveVec = desiredMoveVec;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", this.dragonType != null ? this.dragonType.getTypeName() : "none");
        tag.m_128359_("subtype", this.dragonType != null ? this.dragonType.getSubtypeName() : "none");
        tag.m_128359_("dragonBody", this.dragonBody != null ? this.dragonBody.getBodyName() : "none");
        if (this.isDragon()) {
            tag.m_128365_("typeData", (Tag)this.dragonType.writeNBT());
            if (this.dragonBody != null) {
                tag.m_128365_("bodyData", (Tag)this.dragonBody.writeNBT());
            }
            DragonMovementData movementData = this.getMovementData();
            tag.m_128379_("bite", movementData.bite);
            tag.m_128379_("dig", movementData.dig);
            tag.m_128379_("isHiding", this.isHiding());
            tag.m_128405_("spinCooldown", movementData.spinCooldown);
            tag.m_128405_("spinAttack", movementData.spinAttack);
            tag.m_128347_("size", this.getSize());
            tag.m_128379_("growing", this.growing);
            tag.m_128379_("isFlying", this.isWingsSpread());
            tag.m_128379_("resting", this.treasureResting);
            tag.m_128405_("restingTimer", this.treasureRestTimer);
        }
        if (this.isDragon() || ServerConfig.saveAllAbilities.booleanValue()) {
            tag.m_128379_("spinLearned", this.getMovementData().spinLearned);
            tag.m_128379_("hasWings", this.hasFlight());
        }
        tag.m_128347_("seaSize", this.getSavedDragonSize(DragonTypes.SEA.getTypeName()));
        tag.m_128347_("caveSize", this.getSavedDragonSize(DragonTypes.CAVE.getTypeName()));
        tag.m_128347_("forestSize", this.getSavedDragonSize(DragonTypes.FOREST.getTypeName()));
        for (int i = 0; i < this.caps.length; ++i) {
            tag.m_128365_("cap_" + i, (Tag)this.caps[i].get().writeNBT());
        }
        tag.m_128405_("altarCooldown", this.altarCooldown);
        tag.m_128379_("usedAltar", this.hasUsedAltar);
        if (this.lastPos != null) {
            tag.m_128365_("lastPos", (Tag)Functions.newDoubleList(this.lastPos.f_82479_, this.lastPos.f_82480_, this.lastPos.f_82481_));
        }
        tag.m_128405_("lastAfflicted", this.lastAfflicted);
        return tag;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        this.dragonType = tag.m_128431_().contains("subtype") ? DragonTypes.newDragonTypeInstance(tag.m_128461_("subtype")) : DragonTypes.newDragonTypeInstance(tag.m_128461_("type"));
        if (this.dragonType != null && tag.m_128441_("typeData")) {
            this.dragonType.readNBT(tag.m_128469_("typeData"));
        }
        this.dragonBody = DragonBodies.newDragonBodyInstance(tag.m_128461_("dragonBody"));
        if (this.dragonBody != null && tag.m_128441_("bodyData")) {
            this.dragonBody.readNBT(tag.m_128469_("bodyData"));
        }
        if (this.isDragon()) {
            this.setBite(tag.m_128471_("bite"));
            this.getMovementData().headYawLastFrame = this.getMovementData().headYaw;
            this.getMovementData().bodyYawLastFrame = this.getMovementData().bodyYaw;
            this.getMovementData().headPitchLastFrame = this.getMovementData().headPitch;
            this.setIsHiding(tag.m_128471_("isHiding"));
            this.getMovementData().dig = tag.m_128471_("dig");
            this.setWingsSpread(tag.m_128471_("isFlying"));
            this.getMovementData().spinCooldown = tag.m_128451_("spinCooldown");
            this.getMovementData().spinAttack = tag.m_128451_("spinAttack");
            this.setSize(tag.m_128459_("size"));
            this.growing = !tag.m_128441_("growing") || tag.m_128471_("growing");
            this.treasureResting = tag.m_128471_("resting");
            this.treasureRestTimer = tag.m_128451_("restingTimer");
            if (this.getSize() == 0.0) {
                this.setSize(DragonLevel.NEWBORN.size);
            }
        }
        if (this.isDragon() || ServerConfig.saveAllAbilities.booleanValue()) {
            this.getMovementData().spinLearned = tag.m_128471_("spinLearned");
            this.setHasFlight(tag.m_128471_("hasWings"));
        }
        this.setSavedDragonSize(DragonTypes.SEA.getTypeName(), tag.m_128459_("seaSize"));
        this.setSavedDragonSize(DragonTypes.CAVE.getTypeName(), tag.m_128459_("caveSize"));
        this.setSavedDragonSize(DragonTypes.FOREST.getTypeName(), tag.m_128459_("forestSize"));
        for (int i = 0; i < this.caps.length; ++i) {
            if (!tag.m_128441_("cap_" + i)) continue;
            this.caps[i].get().readNBT((CompoundTag)tag.m_128423_("cap_" + i));
        }
        this.altarCooldown = tag.m_128451_("altarCooldown");
        this.hasUsedAltar = tag.m_128471_("usedAltar");
        if (tag.m_128441_("lastPos")) {
            ListTag listnbt = tag.m_128437_("lastPos", 6);
            this.lastPos = new Vec3(listnbt.m_128772_(0), listnbt.m_128772_(1), listnbt.m_128772_(2));
        }
        this.lastAfflicted = tag.m_128451_("lastAfflicted");
        this.getSkinData().compileSkin();
    }

    public void setMovementData(double bodyYaw, double headYaw, double headPitch, Vec3 deltaMovement) {
        this.movementData.headYawLastFrame = this.movementData.headYaw;
        this.movementData.bodyYawLastFrame = this.movementData.bodyYaw;
        this.movementData.headPitchLastFrame = this.movementData.headPitch;
        this.movementData.deltaMovementLastFrame = this.movementData.deltaMovement;
        this.movementData.bodyYaw = bodyYaw;
        this.movementData.headYaw = headYaw;
        this.movementData.headPitch = headPitch;
        this.movementData.deltaMovement = deltaMovement;
    }

    public void setSize(double size) {
        if (size != this.size) {
            DragonLevel oldLevel = this.getLevel();
            this.size = size;
            if (oldLevel != this.getLevel()) {
                this.requestClientData();
            }
            if (this.dragonType != null) {
                this.setSavedDragonSize(this.dragonType.getTypeName(), size);
            }
        }
    }

    public double getSavedDragonSize(String type) {
        Double value = this.savedDragonSize.get(type);
        value = value == null ? 0.0 : value;
        return value;
    }

    public void setSavedDragonSize(String type, double size) {
        Double value = this.savedDragonSize.get(type);
        if (size == 0.0 || value != null && value == size) {
            return;
        }
        this.savedDragonSize.put(type, size);
    }

    public void requestClientData() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientProxy.requestClientData(this);
        }
    }

    @Nullable
    public AbstractDragonType getType() {
        return this.dragonType;
    }

    public AbstractDragonBody getBody() {
        return this.dragonBody;
    }

    public String getTypeName() {
        if (this.dragonType == null) {
            return "human";
        }
        return this.dragonType.getTypeName();
    }

    public String getTypeNameLowerCase() {
        if (this.dragonType == null) {
            return "human";
        }
        return this.dragonType.getTypeNameLowerCase();
    }

    public String getSubtypeName() {
        if (this.dragonType == null) {
            return "human";
        }
        return this.dragonType.getSubtypeName();
    }

    public void setType(AbstractDragonType type, Player player) {
        AbstractDragonType oldType = this.dragonType;
        this.setType(type);
        if (!player.m_9236_().m_5776_() && oldType != this.dragonType) {
            DragonModifiers.updateTypeModifiers(player);
        }
    }

    public void setType(AbstractDragonType type) {
        if (type != null && !Objects.equals(this.dragonType, type)) {
            this.growing = true;
            this.getMagicData().initAbilities(type);
        }
        if (type != null) {
            if (Objects.equals(this.dragonType, type)) {
                return;
            }
            this.dragonType = DragonTypes.newDragonTypeInstance(type.getSubtypeName());
        } else {
            this.dragonType = null;
        }
    }

    public void setBody(AbstractDragonBody body, Player player) {
        AbstractDragonBody oldBody = this.dragonBody;
        this.setBody(body);
        if (!player.m_9236_().m_5776_() && oldBody != this.dragonBody) {
            DragonModifiers.updateBodyModifiers(player);
        }
    }

    public void setBody(AbstractDragonBody body) {
        if (body != null) {
            if (!body.equals(this.dragonBody)) {
                this.dragonBody = DragonBodies.newDragonBodyInstance(body.getBodyName());
                this.refreshBody = true;
            }
        } else {
            this.dragonBody = null;
        }
    }

    public DragonLevel getLevel() {
        if (this.size < 20.0) {
            return DragonLevel.NEWBORN;
        }
        if (this.size < 30.0) {
            return DragonLevel.YOUNG;
        }
        return DragonLevel.ADULT;
    }

    public boolean canHarvestWithPaw(BlockState state) {
        if (!this.isDragon()) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = this.getClawToolData().getClawsInventory().m_8020_(i);
            if (!stack.m_41735_(state)) continue;
            return true;
        }
        return this.canHarvestWithPawNoTools(state);
    }

    public boolean canHarvestWithPawNoTools(BlockState blockState) {
        int harvestLevel;
        if (!this.isDragon()) {
            return false;
        }
        boolean initialCheck = this.getFakeTool(blockState).m_41735_(blockState);
        if (initialCheck) {
            return true;
        }
        int n = blockState.m_204336_(BlockTags.f_144284_) ? 3 : (blockState.m_204336_(BlockTags.f_144285_) ? 2 : (harvestLevel = blockState.m_204336_(BlockTags.f_144286_) ? 1 : 0));
        if (harvestLevel <= ServerConfig.baseHarvestLevel) {
            return true;
        }
        for (TagKey<Block> tagKey : this.getType().mineableBlocks()) {
            if (!blockState.m_204336_(tagKey)) continue;
            return harvestLevel <= this.getDragonHarvestLevel(this.getType().slotForBonus);
        }
        return false;
    }

    public ItemStack getFakeTool(BlockState blockState) {
        if (this.getType() == null) {
            return ItemStack.f_41583_;
        }
        int harvestLevel = 0;
        for (TagKey<Block> tagKey : this.getType().mineableBlocks()) {
            if (!blockState.m_204336_(tagKey)) continue;
            harvestLevel = this.getDragonHarvestLevel(blockState);
            break;
        }
        if (harvestLevel < 0) {
            return ItemStack.f_41583_;
        }
        return this.getToolOfType(this.getDragonHarvestTier(blockState), blockState);
    }

    public ItemStack getInnateFakeTool() {
        if (this.getType() == null) {
            return ItemStack.f_41583_;
        }
        int harvestLevel = this.getDragonHarvestLevel(this.getType().slotForBonus);
        if (harvestLevel < 0) {
            return ItemStack.f_41583_;
        }
        return this.getToolOfType(DragonUtils.levelToVanillaTier(harvestLevel), this.getType().slotForBonus);
    }

    public ItemStack getToolOfType(Tier tier, BlockState blockState) {
        return this.getToolOfType(tier, this.getRelevantToolSlot(blockState));
    }

    public ItemStack getToolOfType(Tier tier, int toolSlot) {
        Item item;
        if (!(tier instanceof Tiers)) {
            return ItemStack.f_41583_;
        }
        Tiers tiers = (Tiers)tier;
        Object tierPath = tiers.name().toLowerCase(Locale.ENGLISH) + "_";
        tierPath = ((String)tierPath).replace("wood", "wooden");
        switch (toolSlot) {
            case 1: {
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", (String)tierPath + "pickaxe"));
                break;
            }
            case 2: {
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", (String)tierPath + "axe"));
                break;
            }
            case 3: {
                Item item2 = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", (String)tierPath + "shovel"));
                break;
            }
            default: {
                Item item2 = item = ItemStack.f_41583_.m_41720_();
            }
        }
        if (item != null) {
            return item.m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public int getDragonHarvestLevel(BlockState blockState) {
        return this.getDragonHarvestLevel(this.getRelevantToolSlot(blockState));
    }

    public int getDragonHarvestLevel(int slot) {
        if (this.getType() == null) {
            return -1;
        }
        int harvestLevel = ServerConfig.baseHarvestLevel;
        int bonusLevel = 0;
        if (this.getLevel() == DragonLevel.NEWBORN && ServerConfig.bonusUnlockedAt == DragonLevel.NEWBORN) {
            bonusLevel = ServerConfig.bonusHarvestLevel;
        } else if (this.getLevel() == DragonLevel.YOUNG && ServerConfig.bonusUnlockedAt != DragonLevel.ADULT) {
            bonusLevel = ServerConfig.bonusHarvestLevel;
        } else if (this.getLevel() == DragonLevel.ADULT) {
            bonusLevel = ServerConfig.bonusHarvestLevel;
        }
        if (slot == this.getType().slotForBonus) {
            return harvestLevel + bonusLevel;
        }
        return harvestLevel;
    }

    @Nullable
    public Tier getDragonHarvestTier(BlockState blockState) {
        return this.getDragonHarvestTier(this.getRelevantToolSlot(blockState));
    }

    @Nullable
    public Tier getDragonHarvestTier(int slot) {
        int harvestLevel = this.getDragonHarvestLevel(slot);
        if (harvestLevel < 0) {
            return null;
        }
        return switch (harvestLevel) {
            case 0 -> Tiers.WOOD;
            case 1 -> Tiers.STONE;
            case 2 -> Tiers.IRON;
            case 3 -> Tiers.DIAMOND;
            default -> Tiers.NETHERITE;
        };
    }

    public int getRelevantToolSlot(BlockState blockState) {
        if (blockState.m_204336_(BlockTags.f_144282_)) {
            return 1;
        }
        if (blockState.m_204336_(BlockTags.f_144280_)) {
            return 2;
        }
        if (blockState.m_204336_(BlockTags.f_144283_)) {
            return 3;
        }
        return 0;
    }

    public void setPassengerId(int passengerId) {
        this.passengerId = passengerId;
    }

    public void setWingsSpread(boolean areWingsSpread) {
        this.areWingsSpread = areWingsSpread;
    }

    public void setHasFlight(boolean hasFlight) {
        if (hasFlight != this.hasFlight) {
            this.hasFlight = hasFlight;
        }
    }

    public void setIsHiding(boolean isHiding) {
        this.isHiding = isHiding;
    }

    public MagicCap getMagicData() {
        return this.magicData;
    }

    public DragonMovementData getMovementData() {
        return this.movementData;
    }

    public double getSize() {
        return this.size;
    }

    public boolean isDragon() {
        return this.dragonType != null;
    }

    public int getPassengerId() {
        return this.passengerId;
    }

    public EmoteCap getEmoteData() {
        return this.emoteData;
    }

    public SkinCap getSkinData() {
        return this.skinData;
    }

    public boolean hasFlight() {
        return this.hasFlight;
    }

    public boolean isWingsSpread() {
        return this.hasFlight && this.areWingsSpread;
    }

    public boolean isHiding() {
        return this.isHiding;
    }

    public ClawInventory getClawToolData() {
        return this.clawToolData;
    }

    public VillageRelationShips getVillageRelationShips() {
        return this.villageRelationShips;
    }
}

