/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability;

import by.dragonsurvivalteam.dragonsurvival.client.util.FakeClientPlayer;
import by.dragonsurvivalteam.dragonsurvival.common.capability.Capabilities;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import com.ibm.icu.impl.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DragonStateProvider
implements ICapabilitySerializable<CompoundTag> {
    public static final Map<String, LazyOptional<DragonStateHandler>> SERVER_CACHE = new HashMap<String, LazyOptional<DragonStateHandler>>();
    public static final Map<String, LazyOptional<DragonStateHandler>> CLIENT_CACHE = new HashMap<String, LazyOptional<DragonStateHandler>>();
    private final DragonStateHandler handlerObject = new DragonStateHandler();
    private final LazyOptional<DragonStateHandler> instance = LazyOptional.of(() -> this.handlerObject);

    private static Pair<Boolean, LazyOptional<DragonStateHandler>> getFakePlayer(Entity entity) {
        if (entity instanceof FakeClientPlayer) {
            FakeClientPlayer fakeClientPlayer = (FakeClientPlayer)entity;
            if (fakeClientPlayer.handler != null) {
                return Pair.of((Object)true, (Object)LazyOptional.of(() -> fakeClientPlayer.handler));
            }
        }
        return Pair.of((Object)false, (Object)LazyOptional.empty());
    }

    @Nullable
    public static DragonStateHandler getHandler(Entity entity) {
        if (!(entity instanceof Player)) {
            return null;
        }
        LazyOptional<DragonStateHandler> capability = DragonStateProvider.getCap(entity);
        if (capability.isPresent()) {
            Optional optional = capability.resolve();
            return optional.orElse(null);
        }
        return null;
    }

    @NotNull
    public static DragonStateHandler getUnsafeHandler(Player player) throws IllegalStateException {
        return (DragonStateHandler)DragonStateProvider.getCap((Entity)player).orElseThrow(() -> new IllegalStateException("Dragon State was not present"));
    }

    public static LazyOptional<DragonStateHandler> getCap(Entity entity) {
        if (entity == null) {
            return LazyOptional.empty();
        }
        if (entity.m_9236_().m_5776_()) {
            Pair<Boolean, LazyOptional<DragonStateHandler>> fakeState = DragonStateProvider.getFakePlayer(entity);
            if (((Boolean)fakeState.first).booleanValue()) {
                return (LazyOptional)fakeState.second;
            }
        }
        if (!(entity instanceof Player) || entity instanceof FakePlayer) {
            return LazyOptional.empty();
        }
        Map<String, LazyOptional<DragonStateHandler>> sidedCache = entity.m_9236_().m_5776_() ? CLIENT_CACHE : SERVER_CACHE;
        LazyOptional<DragonStateHandler> cachedCapability = sidedCache.get(entity.m_20149_());
        if (cachedCapability != null) {
            return cachedCapability;
        }
        LazyOptional capability = entity.getCapability(Capabilities.DRAGON_CAPABILITY);
        if (capability.isPresent()) {
            sidedCache.put(entity.m_20149_(), (LazyOptional<DragonStateHandler>)capability);
            capability.addListener(ignored -> sidedCache.remove(entity.m_20149_()));
        }
        return capability;
    }

    public static LazyOptional<? extends EntityStateHandler> getEntityCap(Entity entity) {
        if (entity instanceof Player) {
            return DragonStateProvider.getCap(entity);
        }
        return entity.getCapability(Capabilities.ENTITY_CAPABILITY);
    }

    public static void clearCache(Player player) {
        if (player.m_9236_().m_5776_()) {
            if (player == ClientProxy.getLocalPlayer()) {
                CLIENT_CACHE.clear();
            } else {
                CLIENT_CACHE.remove(player.m_20149_());
            }
        } else {
            SERVER_CACHE.remove(player.m_20149_());
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction side) {
        return capability == Capabilities.DRAGON_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return ((DragonStateHandler)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty!"))).writeNBT();
    }

    public void deserializeNBT(CompoundTag nbt) {
        ((DragonStateHandler)this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional must not be empty!"))).readNBT(nbt);
    }
}

