/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities;

import by.dragonsurvivalteam.dragonsurvival.client.emotes.Emote;
import by.dragonsurvivalteam.dragonsurvival.client.emotes.EmoteRegistry;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.SubCap;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;

public class EmoteCap
extends SubCap {
    public static final int MAX_EMOTES = 4;
    public boolean emoteMenuOpen = false;
    public Emote[] currentEmotes = new Emote[4];
    public Integer[] emoteTicks = new Integer[4];
    public ConcurrentHashMap<String, Integer> emoteKeybinds = new ConcurrentHashMap();

    public EmoteCap(DragonStateHandler handler) {
        super(handler);
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < 4; ++i) {
            if (this.currentEmotes[i] != null) {
                tag.m_128359_("emote_" + i, this.currentEmotes[i].animation);
            }
            if (this.emoteTicks[i] == null) continue;
            tag.m_128405_("emote_tick_" + i, this.emoteTicks[i].intValue());
        }
        tag.m_128379_("emoteOpen", this.emoteMenuOpen);
        for (Emote emote : EmoteRegistry.EMOTES) {
            tag.m_128405_("emote_keybind_" + emote.id, this.emoteKeybinds.getOrDefault(emote.id, -1).intValue());
        }
        return tag;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        for (int i = 0; i < 4; ++i) {
            String emoteId = tag.m_128441_("emote_" + i) ? tag.m_128461_("emote_" + i) : null;
            int emoteTick = tag.m_128441_("emote_tick_" + i) ? tag.m_128451_("emote_tick_" + i) : 0;
            Emote emote = null;
            if (emoteId != null) {
                emote = EmoteRegistry.EMOTES.stream().filter(s -> Objects.equals(s.animation, emoteId)).findFirst().orElseGet(() -> {
                    Emote em = new Emote();
                    em.animation = emoteId;
                    return em;
                });
            }
            this.currentEmotes[i] = emote;
            this.emoteTicks[i] = emoteTick;
        }
        this.emoteMenuOpen = tag.m_128471_("emoteOpen");
        for (Emote emote : EmoteRegistry.EMOTES) {
            int num = tag.m_128451_("emote_keybind_" + emote.id);
            this.emoteKeybinds.put(emote.id, num);
        }
    }
}

