/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.SubCap;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.common.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.innate.InnateDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.passive.PassiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class MagicCap
extends SubCap {
    public static final Integer activeAbilitySlots = 4;
    public static final Integer passiveAbilitySlots = 4;
    public static final Integer innateAbilitySlots = 4;
    public final HashMap<Integer, String> passiveDragonAbilities = new HashMap();
    public final HashMap<Integer, String> activeDragonAbilities = new HashMap();
    public final HashMap<Integer, String> innateDragonAbilities = new HashMap();
    public final HashMap<String, DragonAbility> abilities = new HashMap();
    private int selectedAbilitySlot = 0;
    public boolean isCasting = false;
    private int currentMana = 0;
    public boolean onMagicSource = false;
    public int magicSourceTimer = 0;
    private boolean renderAbilities = true;

    public MagicCap(DragonStateHandler handler) {
        super(handler);
        this.initAbilities(handler.getType());
    }

    public void initAbilities(AbstractDragonType type) {
        this.activeDragonAbilities.clear();
        this.passiveDragonAbilities.clear();
        this.innateDragonAbilities.clear();
        if (!ServerConfig.saveAllAbilities.booleanValue()) {
            this.abilities.clear();
        }
        if (type != null) {
            for (DragonAbility dragonAbility : DragonAbilities.ABILITIES.getOrDefault(type.getSubtypeName(), new ArrayList())) {
                if (!this.abilities.containsKey(dragonAbility.getName())) {
                    try {
                        DragonAbility ability = (DragonAbility)dragonAbility.getClass().newInstance();
                        this.abilities.put(ability.getName(), ability);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                }
                if (dragonAbility instanceof ActiveDragonAbility && this.activeDragonAbilities.size() < activeAbilitySlots) {
                    this.activeDragonAbilities.put(this.activeDragonAbilities.size(), dragonAbility.getName());
                }
                if (dragonAbility instanceof PassiveDragonAbility && this.passiveDragonAbilities.size() < passiveAbilitySlots) {
                    this.passiveDragonAbilities.put(this.passiveDragonAbilities.size(), dragonAbility.getName());
                }
                if (!(dragonAbility instanceof InnateDragonAbility)) continue;
                this.innateDragonAbilities.put(this.innateDragonAbilities.size(), dragonAbility.getName());
            }
        }
    }

    public int getCurrentMana() {
        return this.currentMana;
    }

    public void setCurrentMana(int currentMana) {
        this.currentMana = currentMana;
    }

    public void setSelectedAbilitySlot(int newSlot) {
        this.selectedAbilitySlot = newSlot;
    }

    public int getSelectedAbilitySlot() {
        return this.selectedAbilitySlot;
    }

    public InnateDragonAbility getInnateAbilityFromSlot(int slot) {
        String key;
        if (this.innateDragonAbilities.containsKey(slot) && this.abilities.containsKey(key = this.innateDragonAbilities.get(slot))) {
            return (InnateDragonAbility)this.abilities.get(key);
        }
        return null;
    }

    public PassiveDragonAbility getPassiveAbilityFromSlot(int slot) {
        String key;
        if (this.passiveDragonAbilities.containsKey(slot) && this.abilities.containsKey(key = this.passiveDragonAbilities.get(slot))) {
            return (PassiveDragonAbility)this.abilities.get(key);
        }
        return null;
    }

    public ActiveDragonAbility getCurrentlyCasting() {
        return this.isCasting ? this.getAbilityFromSlot(this.getSelectedAbilitySlot()) : null;
    }

    public void setCurrentlyCasting() {
        this.isCasting = true;
    }

    public void stopCasting() {
        this.isCasting = false;
        this.getCurrentlyCasting().onKeyReleased(this.getCurrentlyCasting().player);
    }

    public List<ActiveDragonAbility> getActiveAbilities() {
        if (this.abilities.isEmpty()) {
            this.initAbilities(this.handler.getType());
        }
        return this.abilities.values().stream().filter(ActiveDragonAbility.class::isInstance).filter(s -> DragonUtils.isDragonType(this.handler, s.getDragonType())).map(ActiveDragonAbility.class::cast).toList();
    }

    public List<PassiveDragonAbility> getPassiveAbilities() {
        if (this.abilities.isEmpty()) {
            this.initAbilities(this.handler.getType());
        }
        return this.abilities.values().stream().filter(PassiveDragonAbility.class::isInstance).filter(s -> DragonUtils.isDragonType(this.handler, s.getDragonType())).map(PassiveDragonAbility.class::cast).toList();
    }

    public ActiveDragonAbility getAbilityFromSlot(int slot) {
        String key;
        if (this.abilities.isEmpty() || this.activeDragonAbilities.isEmpty()) {
            this.initAbilities(this.handler.getType());
        }
        if (this.activeDragonAbilities.containsKey(slot) && this.abilities.containsKey(key = this.activeDragonAbilities.get(slot))) {
            return (ActiveDragonAbility)this.abilities.get(key);
        }
        return null;
    }

    public CompoundTag saveAbilities() {
        int i;
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, DragonAbility> entry : this.abilities.entrySet()) {
            tag.m_128365_(entry.getKey(), (Tag)entry.getValue().saveNBT());
        }
        for (i = 0; i < activeAbilitySlots; ++i) {
            if (!this.activeDragonAbilities.containsKey(i)) continue;
            tag.m_128359_("active_" + i, this.activeDragonAbilities.get(i));
        }
        for (i = 0; i < passiveAbilitySlots; ++i) {
            if (!this.passiveDragonAbilities.containsKey(i)) continue;
            tag.m_128359_("passive_" + i, this.passiveDragonAbilities.get(i));
        }
        for (i = 0; i < innateAbilitySlots; ++i) {
            if (!this.innateDragonAbilities.containsKey(i)) continue;
            tag.m_128359_("innate_" + i, this.innateDragonAbilities.get(i));
        }
        return tag;
    }

    public void loadAbilities(CompoundTag tag) {
        int i;
        for (Map.Entry<String, ArrayList<DragonAbility>> entry : DragonAbilities.ABILITIES.entrySet()) {
            if (!ServerConfig.saveAllAbilities.booleanValue() && !Objects.equals(entry.getKey(), this.handler.getSubtypeName())) continue;
            for (DragonAbility ability : entry.getValue()) {
                if (!tag.m_128441_(ability.getName())) continue;
                try {
                    DragonAbility ab = (DragonAbility)ability.getClass().newInstance();
                    ab.loadNBT(tag.m_128469_(ability.getName()));
                    this.abilities.put(ab.getName(), ab);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        for (i = 0; i < activeAbilitySlots; ++i) {
            if (!tag.m_128441_("active_" + i)) continue;
            this.activeDragonAbilities.put(i, tag.m_128461_("active_" + i));
        }
        for (i = 0; i < passiveAbilitySlots; ++i) {
            if (!tag.m_128441_("passive_" + i)) continue;
            this.passiveDragonAbilities.put(i, tag.m_128461_("passive_" + i));
        }
        for (i = 0; i < innateAbilitySlots; ++i) {
            if (!tag.m_128441_("innate_" + i)) continue;
            this.innateDragonAbilities.put(i, tag.m_128461_("innate_" + i));
        }
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("renderSkills", this.renderAbilities);
        tag.m_128405_("selectedAbilitySlot", this.selectedAbilitySlot);
        tag.m_128379_("onMagicSource", this.onMagicSource);
        tag.m_128405_("magicSourceTimer", this.magicSourceTimer);
        tag.m_128405_("mana", this.getCurrentMana());
        tag.m_128365_("abilityData", (Tag)this.saveAbilities());
        return tag;
    }

    @Override
    public void readNBT(CompoundTag tag) {
        this.onMagicSource = tag.m_128471_("onMagicSource");
        this.magicSourceTimer = tag.m_128451_("magicSourceTimer");
        this.renderAbilities = tag.m_128471_("renderSkills");
        this.setSelectedAbilitySlot(tag.m_128451_("selectedAbilitySlot"));
        this.setCurrentMana(tag.m_128451_("mana"));
        if (tag.m_128441_("abilityData")) {
            this.loadAbilities(tag.m_128469_("abilityData"));
        }
    }

    public void setRenderAbilities(boolean renderAbilities) {
        this.renderAbilities = renderAbilities;
    }

    public boolean shouldRenderAbilities() {
        return this.renderAbilities;
    }
}

