/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.dragon_types.types;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonTraitHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.CaveDragon.passive.ContrastShowerAbility;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonTypeData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;

public class CaveDragonType
extends AbstractDragonType {
    public int timeInRain;
    public int lavaAirSupply;

    public CaveDragonType() {
        this.slotForBonus = 1;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("timeInRain", this.timeInRain);
        tag.m_128405_("lavaAirSupply", this.lavaAirSupply);
        return tag;
    }

    @Override
    public void readNBT(CompoundTag base) {
        this.timeInRain = base.m_128451_("timeInRain");
        this.lavaAirSupply = base.m_128451_("lavaAirSupply");
    }

    @Override
    public void onPlayerUpdate(Player player, DragonStateHandler dragonStateHandler) {
        Level world = player.m_9236_();
        BlockState feetBlock = player.m_146900_();
        BlockState blockUnder = world.m_8055_(player.m_20183_().m_7495_());
        Block block = blockUnder.m_60734_();
        boolean isInCauldron = DragonTraitHandler.isInCauldron(feetBlock, blockUnder);
        boolean isInSeaBlock = DragonConfigHandler.SEA_DRAGON_HYDRATION_BLOCKS != null && (DragonConfigHandler.SEA_DRAGON_HYDRATION_BLOCKS.contains(block) || DragonConfigHandler.SEA_DRAGON_HYDRATION_BLOCKS.contains(feetBlock.m_60734_()) || isInCauldron);
        ContrastShowerAbility contrastShower = DragonAbilities.getSelfAbility((LivingEntity)player, ContrastShowerAbility.class);
        int maxRainTime = 0;
        if (contrastShower != null) {
            maxRainTime += Functions.secondsToTicks(contrastShower.getDuration());
        }
        double oldRainTime = this.timeInRain;
        int oldLavaTicks = this.lavaAirSupply;
        if (ServerConfig.penalties.booleanValue() && !player.m_21023_(DragonEffects.FIRE) && !player.m_7500_() && !player.m_5833_()) {
            if (!world.m_5776_()) {
                if (player.m_20072_() && ServerConfig.caveWaterDamage != 0.0 || player.m_20070_() && !player.m_20069_() && ServerConfig.caveRainDamage != 0.0 || isInSeaBlock && ServerConfig.caveRainDamage != 0.0) {
                    if (player.m_20072_() && player.f_19797_ % 10 == 0 && ServerConfig.caveWaterDamage != 0.0) {
                        player.m_6469_(DSDamageTypes.damageSource(player.m_9236_(), DSDamageTypes.WATER_BURN), ServerConfig.caveWaterDamage.floatValue());
                    } else if ((player.m_20070_() && !player.m_20072_() || isInSeaBlock) && ServerConfig.caveRainDamage != 0.0) {
                        ++this.timeInRain;
                    }
                    if (this.timeInRain >= maxRainTime && player.f_19797_ % 40 == 0) {
                        player.m_6469_(DSDamageTypes.damageSource(player.m_9236_(), DSDamageTypes.RAIN_BURN), ServerConfig.caveRainDamage.floatValue());
                    }
                    if (player.f_19797_ % 40 == 0) {
                        player.m_5496_(SoundEvents.f_12031_, 1.0f, (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.2f + 1.0f);
                    }
                } else if (this.timeInRain > 0) {
                    this.timeInRain = maxRainTime > 0 ? Math.max(this.timeInRain - (int)Math.ceil((float)maxRainTime * 0.02f), 0) : --this.timeInRain;
                }
            }
            if (world.m_5776_() && player.f_19797_ % 10 == 0 && this.timeInRain > 0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123759_, player.m_20185_() + world.f_46441_.m_188500_() * (double)(world.f_46441_.m_188499_() ? 1 : -1), player.m_20186_() + 0.5, player.m_20189_() + world.f_46441_.m_188500_() * (double)(world.f_46441_.m_188499_() ? 1 : -1), 0.0, 0.0, 0.0);
            }
        }
        if (player.m_6060_() && ServerConfig.bonuses.booleanValue() && ServerConfig.caveFireImmunity.booleanValue()) {
            player.m_20095_();
        }
        if (!player.m_9236_().m_5776_()) {
            if (player.isEyeInFluidType((FluidType)ForgeMod.LAVA_TYPE.get()) && ServerConfig.bonuses.booleanValue() && ServerConfig.caveLavaSwimming.booleanValue() && ServerConfig.caveLavaSwimmingTicks != 0) {
                if (!player.m_6040_() && !player.m_150110_().f_35934_) {
                    --this.lavaAirSupply;
                    if (this.lavaAirSupply == -20) {
                        this.lavaAirSupply = 0;
                        if (!player.m_9236_().m_5776_()) {
                            player.m_6469_(player.m_269291_().m_269063_(), 2.0f);
                        }
                    }
                }
                if (!player.m_9236_().m_5776_() && player.m_20159_() && player.m_20202_() != null && !player.m_20202_().canBeRiddenUnderFluidType((FluidType)ForgeMod.WATER_TYPE.get(), (Entity)player)) {
                    player.m_8127_();
                }
            } else if (this.lavaAirSupply < ServerConfig.caveLavaSwimmingTicks && !player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                this.lavaAirSupply = Math.min(this.lavaAirSupply + (int)Math.ceil((float)ServerConfig.caveLavaSwimmingTicks.intValue() * 0.0133333f), ServerConfig.caveLavaSwimmingTicks);
            }
        }
        if (!(world.m_5776_() || oldLavaTicks == this.lavaAirSupply && (double)this.timeInRain == oldRainTime)) {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncDragonTypeData(player.m_19879_(), dragonStateHandler.getType()));
        }
    }

    @Override
    public boolean isInManaCondition(Player player, DragonStateHandler cap) {
        BlockState blockBelow = player.m_9236_().m_8055_(player.m_20183_().m_7495_());
        if (player.m_20077_() || player.m_6060_() || player.m_21023_(DragonEffects.BURN) || player.m_21023_(DragonEffects.FIRE)) {
            return true;
        }
        if (DragonConfigHandler.DRAGON_MANA_BLOCKS != null && DragonConfigHandler.DRAGON_MANA_BLOCKS.containsKey(DragonTypes.CAVE.getTypeName()) && DragonConfigHandler.DRAGON_MANA_BLOCKS.get(DragonTypes.CAVE.getTypeName()).contains(blockBelow.m_60734_()) && blockBelow.m_60734_() instanceof AbstractFurnaceBlock && blockBelow.m_61138_((Property)AbstractFurnaceBlock.f_48684_)) {
            return (Boolean)blockBelow.m_61143_((Property)AbstractFurnaceBlock.f_48684_);
        }
        return false;
    }

    @Override
    public void onPlayerDeath() {
        this.timeInRain = 0;
    }

    @Override
    public List<Pair<ItemStack, FoodData>> validFoods(Player player, DragonStateHandler handler) {
        return null;
    }

    @Override
    public List<TagKey<Block>> mineableBlocks() {
        return List.of(BlockTags.f_144282_);
    }

    @Override
    public String getTypeName() {
        return "cave";
    }
}

