/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.dragon_types.types;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.ForestDragon.passive.LightInDarknessAbility;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonTypeData;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraftforge.network.PacketDistributor;

public class ForestDragonType
extends AbstractDragonType {
    public int timeInDarkness;

    public ForestDragonType() {
        this.slotForBonus = 2;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("timeInDarkness", this.timeInDarkness);
        return tag;
    }

    @Override
    public void readNBT(CompoundTag base) {
        this.timeInDarkness = base.m_128451_("timeInDarkness");
    }

    @Override
    public void onPlayerUpdate(Player player, DragonStateHandler dragonStateHandler) {
        Level world = player.m_9236_();
        BlockState feetBlock = player.m_146900_();
        BlockState blockUnder = world.m_8055_(player.m_20183_().m_7495_());
        Block block = blockUnder.m_60734_();
        Biome biome = (Biome)world.m_204166_(player.m_20183_()).m_203334_();
        int maxStressTicks = ServerConfig.forestStressTicks;
        LightInDarknessAbility lightInDarkness = DragonAbilities.getSelfAbility((LivingEntity)player, LightInDarknessAbility.class);
        if (lightInDarkness != null) {
            maxStressTicks += Functions.secondsToTicks(lightInDarkness.getDuration());
        }
        double oldDarknessTime = this.timeInDarkness;
        if (ServerConfig.penalties.booleanValue() && !player.m_21023_(DragonEffects.MAGIC) && ServerConfig.forestStressTicks > 0 && !player.m_7500_() && !player.m_5833_()) {
            if (!world.m_5776_()) {
                LevelLightEngine lightManager = world.m_7726_().m_7827_();
                if (lightManager.m_75814_(LightLayer.BLOCK).m_7768_(player.m_20183_()) < 3 && lightManager.m_75814_(LightLayer.SKY).m_7768_(player.m_20183_()) < 3 && lightManager.m_75814_(LightLayer.SKY).m_7768_(player.m_20183_().m_7494_()) < 3) {
                    if (this.timeInDarkness < maxStressTicks) {
                        ++this.timeInDarkness;
                    }
                } else {
                    this.timeInDarkness = Math.max(this.timeInDarkness - (int)Math.ceil((float)maxStressTicks * 0.02f), 0);
                }
                this.timeInDarkness = Math.min(this.timeInDarkness, maxStressTicks);
                if (this.timeInDarkness >= maxStressTicks && player.f_19797_ % 21 == 0) {
                    player.m_7292_(new MobEffectInstance(DragonEffects.STRESS, Functions.secondsToTicks(ServerConfig.forestStressEffectDuration)));
                }
                if ((double)this.timeInDarkness != oldDarknessTime) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncDragonTypeData(player.m_19879_(), dragonStateHandler.getType()));
                }
            }
            if (world.m_5776_() && !player.m_7500_() && !player.m_5833_() && !player.m_21023_(DragonEffects.MAGIC) && this.timeInDarkness == ServerConfig.forestStressTicks) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, player.m_20185_() + world.f_46441_.m_188500_() * (double)(world.f_46441_.m_188499_() ? 1 : -1), player.m_20186_() + 0.5, player.m_20189_() + world.f_46441_.m_188500_() * (double)(world.f_46441_.m_188499_() ? 1 : -1), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isInManaCondition(Player player, DragonStateHandler cap) {
        if (player.m_9236_().m_45527_(player.m_20183_())) {
            int light = player.m_9236_().m_45517_(LightLayer.SKY, player.m_20183_()) - player.m_9236_().m_7445_();
            float f = player.m_9236_().m_46490_(1.0f);
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            light = Math.round((float)light * Mth.m_14089_((float)f));
            if ((light = Mth.m_14045_((int)light, (int)0, (int)15)) >= 10) {
                return true;
            }
        }
        return player.m_21023_(DragonEffects.DRAIN) || player.m_21023_(DragonEffects.MAGIC);
    }

    @Override
    public void onPlayerDeath() {
        this.timeInDarkness = 0;
    }

    @Override
    public List<Pair<ItemStack, FoodData>> validFoods(Player player, DragonStateHandler handler) {
        return null;
    }

    @Override
    public String getTypeName() {
        return "forest";
    }

    @Override
    public List<TagKey<Block>> mineableBlocks() {
        return List.of(BlockTags.f_144280_);
    }
}

