/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.dragon_types.types;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonTraitHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.passive.WaterAbility;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonTypeData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class SeaDragonType
extends AbstractDragonType {
    public double timeWithoutWater;

    public SeaDragonType() {
        this.slotForBonus = 3;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("timeWithoutWater", this.timeWithoutWater);
        return tag;
    }

    @Override
    public void readNBT(CompoundTag base) {
        this.timeWithoutWater = base.m_128459_("timeWithoutWater");
    }

    @Override
    public String getTypeName() {
        return "sea";
    }

    @Override
    public void onPlayerUpdate(Player player, DragonStateHandler dragonStateHandler) {
        Level world = player.m_9236_();
        BlockState feetBlock = player.m_146900_();
        BlockState blockUnder = world.m_8055_(player.m_20183_().m_7495_());
        Block block = blockUnder.m_60734_();
        Biome biome = (Biome)world.m_204166_(player.m_20183_()).m_203334_();
        boolean isInCauldron = DragonTraitHandler.isInCauldron(feetBlock, blockUnder);
        boolean isInSeaBlock = DragonConfigHandler.SEA_DRAGON_HYDRATION_BLOCKS != null && (DragonConfigHandler.SEA_DRAGON_HYDRATION_BLOCKS.contains(block) || DragonConfigHandler.SEA_DRAGON_HYDRATION_BLOCKS.contains(feetBlock.m_60734_()) || isInCauldron);
        int maxTicksOutofWater = ServerConfig.seaTicksWithoutWater;
        WaterAbility waterAbility = DragonAbilities.getSelfAbility((LivingEntity)player, WaterAbility.class);
        if (waterAbility != null) {
            maxTicksOutofWater += Functions.secondsToTicks(waterAbility.getDuration());
        }
        double oldWaterTime = this.timeWithoutWater;
        if (!world.m_5776_() && (player.m_21023_(DragonEffects.PEACE) || player.m_20069_() && player.m_20146_() < player.m_6062_())) {
            player.m_20301_(player.m_6062_());
        }
        if (ServerConfig.penalties.booleanValue() && maxTicksOutofWater > 0 && !player.m_7500_() && !player.m_5833_()) {
            if (!world.m_5776_()) {
                if (player.m_21023_(DragonEffects.PEACE)) {
                    this.timeWithoutWater = 0.0;
                } else {
                    if (!player.m_20071_() && !isInSeaBlock) {
                        boolean hotBiome = biome.m_264600_(player.m_20183_()) == Biome.Precipitation.NONE && (double)biome.m_47554_() > 1.0;
                        double timeIncrement = (world.m_46462_() ? 0.5 : 1.0) * (double)(hotBiome ? biome.m_47554_() : 1.0f);
                        this.timeWithoutWater += ServerConfig.seaTicksBasedOnTemperature != false ? timeIncrement : 1.0;
                    }
                    if (player.m_20071_() || isInSeaBlock) {
                        this.timeWithoutWater = Math.max(this.timeWithoutWater - (double)((int)Math.ceil((float)maxTicksOutofWater * 0.005f)), 0.0);
                    }
                    this.timeWithoutWater = Math.min(this.timeWithoutWater, (double)(maxTicksOutofWater * 2));
                    if (!player.m_9236_().m_5776_()) {
                        float hydrationDamage = ServerConfig.seaDehydrationDamage.floatValue();
                        if (this.timeWithoutWater > (double)maxTicksOutofWater && this.timeWithoutWater < (double)(maxTicksOutofWater * 2)) {
                            if (player.f_19797_ % 40 == 0) {
                                player.m_6469_(DSDamageTypes.damageSource(player.m_9236_(), DSDamageTypes.DEHYDRATION), hydrationDamage);
                            }
                        } else if (this.timeWithoutWater >= (double)(maxTicksOutofWater * 2) && player.f_19797_ % 20 == 0) {
                            player.m_6469_(DSDamageTypes.damageSource(player.m_9236_(), DSDamageTypes.DEHYDRATION), hydrationDamage);
                        }
                    }
                }
                if (oldWaterTime != this.timeWithoutWater) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncDragonTypeData(player.m_19879_(), dragonStateHandler.getType()));
                }
            }
            if (world.m_5776_() && !player.m_7500_() && !player.m_5833_() && !player.m_21023_(DragonEffects.PEACE) && this.timeWithoutWater >= (double)maxTicksOutofWater) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123790_, player.m_20185_() + world.f_46441_.m_188500_() * (double)(world.f_46441_.m_188499_() ? 1 : -1), player.m_20186_() + 0.5, player.m_20189_() + world.f_46441_.m_188500_() * (double)(world.f_46441_.m_188499_() ? 1 : -1), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isInManaCondition(Player player, DragonStateHandler cap) {
        BlockState blockBelow = player.m_9236_().m_8055_(player.m_20183_().m_7495_());
        BlockState blockAtFeet = player.m_146900_();
        if (player.m_20071_() || player.m_21023_(DragonEffects.CHARGED) || player.m_21023_(DragonEffects.PEACE)) {
            return true;
        }
        if (DragonConfigHandler.DRAGON_MANA_BLOCKS != null && DragonConfigHandler.DRAGON_MANA_BLOCKS.containsKey(DragonTypes.SEA.getTypeName())) {
            boolean containsBlockAtFeet = DragonConfigHandler.DRAGON_MANA_BLOCKS.get(DragonTypes.SEA.getTypeName()).contains(blockAtFeet.m_60734_());
            boolean containsBlockBelow = DragonConfigHandler.DRAGON_MANA_BLOCKS.get(DragonTypes.SEA.getTypeName()).contains(blockBelow.m_60734_());
            if ((containsBlockAtFeet || containsBlockBelow) && DragonTraitHandler.isInCauldron(blockAtFeet, blockBelow)) {
                int level;
                if (blockBelow.m_61138_((Property)LayeredCauldronBlock.f_153514_) && (level = ((Integer)blockBelow.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) > 0) {
                    return true;
                }
                if (blockAtFeet.m_61138_((Property)LayeredCauldronBlock.f_153514_)) {
                    level = (Integer)blockAtFeet.m_61143_((Property)LayeredCauldronBlock.f_153514_);
                    return level > 0;
                }
            }
        }
        return false;
    }

    @Override
    public void onPlayerDeath() {
        this.timeWithoutWater = 0.0;
    }

    @Override
    public List<Pair<ItemStack, FoodData>> validFoods(Player player, DragonStateHandler handler) {
        return null;
    }

    @Override
    public List<TagKey<Block>> mineableBlocks() {
        return List.of(BlockTags.f_144283_);
    }
}

