/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity;

import by.dragonsurvivalteam.dragonsurvival.client.emotes.Emote;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientEvents;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.client.render.util.AnimationTimer;
import by.dragonsurvivalteam.dragonsurvival.client.render.util.CommonTraits;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ClientConfig;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.common.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.magic.common.ISecondAnimation;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.AnimationUtils;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DragonEntity
extends LivingEntity
implements GeoEntity,
CommonTraits {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final ArrayList<Double> bodyYawHistory = new ArrayList();
    public double currentBodyYawChange = 0.0;
    public final ArrayList<Double> headYawHistory = new ArrayList();
    public double currentHeadYawChange = 0.0;
    public final ArrayList<Double> headPitchHistory = new ArrayList();
    public double currentHeadPitchChange = 0.0;
    public final ArrayList<Double> verticalVelocityHistory = new ArrayList();
    public double currentTailMotionUp = 0.0;
    public volatile Integer playerId;
    public boolean neckLocked = false;
    public boolean tailLocked = false;
    public float prevZRot = 0.0f;
    public float prevXRot = 0.0f;
    public boolean clearVerticalVelocity = false;
    ActiveDragonAbility lastCast = null;
    boolean started;
    boolean ended;
    AnimationTimer animationTimer = new AnimationTimer();
    private final double defaultPlayerWalkSpeed = 0.1;
    private final double defaultPlayerSneakSpeed = 0.03;
    private final double defaultPlayerFastSwimSpeed = 0.13;
    private final double defaultPlayerSwimSpeed = 0.051;
    private final double defaultPlayerSprintSpeed = 0.165;
    private static final RawAnimation BITE = RawAnimation.begin().thenLoop("bite");
    private static final RawAnimation USE_ITEM = RawAnimation.begin().thenLoop("use_item");
    private static final RawAnimation USE_ITEM_RIGHT = RawAnimation.begin().thenLoop("use_item_right");
    private static final RawAnimation USE_ITEM_LEFT = RawAnimation.begin().thenLoop("use_item_left");
    private static final RawAnimation EAT_ITEM_RIGHT = RawAnimation.begin().thenLoop("eat_item_right");
    private static final RawAnimation EAT_ITEM_LEFT = RawAnimation.begin().thenLoop("eat_item_left");
    private static final RawAnimation SIT_ON_MAGIC_SOURCE = RawAnimation.begin().thenLoop("sit_on_magic_source");
    private static final RawAnimation SLEEP = RawAnimation.begin().thenLoop("sleep");
    private static final RawAnimation SIT = RawAnimation.begin().thenLoop("sit");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("fly");
    private static final RawAnimation FLY_SOARING = RawAnimation.begin().thenLoop("fly_soaring");
    private static final RawAnimation FLY_DIVE = RawAnimation.begin().thenLoop("fly_dive");
    private static final RawAnimation FLY_DIVE_ALT = RawAnimation.begin().thenLoop("fly_dive_alt");
    private static final RawAnimation FLY_SPIN = RawAnimation.begin().thenLoop("fly_spin");
    private static final RawAnimation FLY_LAND = RawAnimation.begin().thenLoop("fly_land");
    private static final RawAnimation SWIM = RawAnimation.begin().thenLoop("swim");
    private static final RawAnimation SWIM_FAST = RawAnimation.begin().thenLoop("swim_fast");
    private static final RawAnimation FALL_LOOP = RawAnimation.begin().thenLoop("fall_loop");
    private static final RawAnimation SNEAK = RawAnimation.begin().thenLoop("sneak");
    private static final RawAnimation SNEAK_WALK = RawAnimation.begin().thenLoop("sneak_walk");
    private static final RawAnimation DIG_SNEAK = RawAnimation.begin().thenLoop("dig_sneak");
    private static final RawAnimation RUN = RawAnimation.begin().thenLoop("run");
    private static final RawAnimation WALK = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation DIG = RawAnimation.begin().thenLoop("dig");
    private static final RawAnimation JUMP = RawAnimation.begin().then("jump", Animation.LoopType.PLAY_ONCE).thenLoop("fall_loop");
    private static final RawAnimation FLY_LAND_END = RawAnimation.begin().then("fly_land_end", Animation.LoopType.PLAY_ONCE).thenLoop("idle");
    private static final RawAnimation TAIL_TURN = RawAnimation.begin().thenLoop("tail_turn");
    private static final RawAnimation HEAD_TURN = RawAnimation.begin().thenLoop("head_turn");

    public DragonEntity(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar registrar) {
        for (int slot = 0; slot < 4; ++slot) {
            int finalSlot = slot;
            registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "2_" + slot, 0, state -> this.emotePredicate((AnimationState<DragonEntity>)state, finalSlot))});
        }
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "3", 2, this::predicate)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "4", this::bitePredicate)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "5", this::tailPredicate)});
        registrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "1", this::headPredicate)});
    }

    private PlayState tailPredicate(AnimationState<DragonEntity> state) {
        if (!this.tailLocked || !ClientConfig.enableTailPhysics.booleanValue()) {
            return state.setAndContinue(TAIL_TURN);
        }
        return PlayState.STOP;
    }

    private PlayState headPredicate(AnimationState<DragonEntity> state) {
        if (!this.neckLocked) {
            return state.setAndContinue(HEAD_TURN);
        }
        return PlayState.STOP;
    }

    private PlayState bitePredicate(AnimationState<DragonEntity> state) {
        Player player = this.getPlayer();
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        ActiveDragonAbility currentCast = handler.getMagicData().getCurrentlyCasting();
        RawAnimation builder = null;
        if (currentCast instanceof ISecondAnimation || this.lastCast instanceof ISecondAnimation) {
            builder = this.renderAbility(state, currentCast);
        }
        if (!(ClientDragonRender.renderItemsInMouth.booleanValue() || !this.doesAnimationExist("use_item") || !player.m_6117_() && (!handler.getMovementData().bite && !handler.getMovementData().dig || player.m_21205_().m_41619_() && player.m_21206_().m_41619_()))) {
            handler.getMovementData().bite = false;
            return state.setAndContinue(AnimationUtils.createAnimation(builder, USE_ITEM));
        }
        if (!ClientDragonRender.renderItemsInMouth.booleanValue() && this.doesAnimationExist("eat_item_right") && player.m_6117_() && DragonFoodHandler.isEdible(player.m_21205_(), handler.getType()) || this.animationTimer.getDuration("eat_item_right") > 0.0) {
            if (this.animationTimer.getDuration("eat_item_right") <= 0.0) {
                handler.getMovementData().bite = false;
                this.animationTimer.putAnimation("eat_item_right", 6.4);
            }
            return state.setAndContinue(AnimationUtils.createAnimation(builder, EAT_ITEM_RIGHT));
        }
        if (!ClientDragonRender.renderItemsInMouth.booleanValue() && this.doesAnimationExist("eat_item_left") && player.m_6117_() && DragonFoodHandler.isEdible(player.m_21205_(), handler.getType()) || this.animationTimer.getDuration("eat_item_right") > 0.0) {
            if (this.animationTimer.getDuration("eat_item_left") <= 0.0) {
                handler.getMovementData().bite = false;
                this.animationTimer.putAnimation("eat_item_left", 6.4);
            }
            return state.setAndContinue(AnimationUtils.createAnimation(builder, EAT_ITEM_LEFT));
        }
        if (!ClientDragonRender.renderItemsInMouth.booleanValue() && this.doesAnimationExist("use_item_right") && !player.m_21205_().m_41619_() && handler.getMovementData().bite && player.m_5737_() == HumanoidArm.RIGHT || this.animationTimer.getDuration("use_item_right") > 0.0) {
            if (this.animationTimer.getDuration("use_item_right") <= 0.0) {
                handler.getMovementData().bite = false;
                this.animationTimer.putAnimation("use_item_right", 6.4);
            }
            return state.setAndContinue(AnimationUtils.createAnimation(builder, USE_ITEM_RIGHT));
        }
        if (!ClientDragonRender.renderItemsInMouth.booleanValue() && this.doesAnimationExist("use_item_left") && !player.m_21206_().m_41619_() && handler.getMovementData().bite && player.m_5737_() == HumanoidArm.LEFT || this.animationTimer.getDuration("use_item_left") > 0.0) {
            if (this.animationTimer.getDuration("use_item_left") <= 0.0) {
                handler.getMovementData().bite = false;
                this.animationTimer.putAnimation("use_item_left", 6.4);
            }
            return state.setAndContinue(AnimationUtils.createAnimation(builder, USE_ITEM_LEFT));
        }
        if (handler.getMovementData().bite && !handler.getMovementData().dig || this.animationTimer.getDuration("bite") > 0.0) {
            if (this.animationTimer.getDuration("bite") <= 0.0) {
                handler.getMovementData().bite = false;
                this.animationTimer.putAnimation("bite", 8.8);
            }
            return state.setAndContinue(AnimationUtils.createAnimation(builder, BITE));
        }
        return PlayState.STOP;
    }

    private boolean doesAnimationExist(String animation) {
        return ((BakedAnimations)GeckoLibCache.getBakedAnimations().get(ClientDragonRender.dragonModel.getAnimationResource(ClientDragonRender.dragonArmor))).getAnimation(animation) != null;
    }

    private PlayState emotePredicate(AnimationState<DragonEntity> state, int slot) {
        DragonStateHandler handler = DragonUtils.getHandler((Entity)this.getPlayer());
        if (handler.getEmoteData().currentEmotes[slot] != null) {
            Emote emote = handler.getEmoteData().currentEmotes[slot];
            this.neckLocked = emote.locksHead;
            this.tailLocked = emote.locksTail;
            state.getController().setAnimationSpeed(emote.speed);
            if (emote.animation != null && !emote.animation.isEmpty()) {
                if (!emote.loops) {
                    return state.setAndContinue(RawAnimation.begin().thenPlay(emote.animation));
                }
                return state.setAndContinue(RawAnimation.begin().thenLoop(emote.animation));
            }
        }
        return PlayState.STOP;
    }

    @Nullable
    public Player getPlayer() {
        return (Player)this.m_9236_().m_6815_(this.playerId.intValue());
    }

    private void lockTailAndNeck() {
        this.neckLocked = true;
        this.tailLocked = true;
    }

    private void clearVerticalVelocity() {
        this.clearVerticalVelocity = true;
    }

    private PlayState predicate(AnimationState<DragonEntity> state) {
        boolean hasMoveInput;
        Player player = this.getPlayer();
        AnimationController animationController = state.getController();
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (handler.refreshBody) {
            animationController.forceAnimationReset();
            handler.refreshBody = false;
        }
        boolean useDynamicScaling = false;
        double animationSpeed = 1.0;
        double speedFactor = ClientConfig.movementAnimationSpeedFactor;
        double baseSpeed = 0.1;
        double smallSizeFactor = ClientConfig.smallSizeAnimationSpeedFactor;
        double bigSizeFactor = ClientConfig.largeSizeAnimationSpeedFactor;
        double baseSize = ServerConfig.DEFAULT_MAX_GROWTH_SIZE;
        double distanceFromGround = ServerFlightHandler.distanceFromGround(player);
        double height = DragonSizeHandler.calculateDragonHeight(handler.getSize(), ServerConfig.hitboxGrowsPastHuman);
        if (player == null || Stream.of(handler.getEmoteData().currentEmotes).anyMatch(emote -> emote != null && !emote.blend && emote.animation != null && !emote.animation.isBlank())) {
            state.getController().stop();
            return PlayState.STOP;
        }
        this.neckLocked = false;
        this.tailLocked = false;
        Vec3 deltaMovement = player.m_20184_();
        ActiveDragonAbility currentCast = handler.getMagicData().getCurrentlyCasting();
        RawAnimation builder = null;
        if (!(currentCast instanceof ISecondAnimation) && !(this.lastCast instanceof ISecondAnimation)) {
            builder = this.renderAbility(state, currentCast);
        }
        double INPUT_EPSILON = 1.0E-7;
        Vec2 rawInput = handler.getMovementData().desiredMoveVec;
        boolean bl = hasMoveInput = (double)rawInput.m_165912_() > 9.999999999999998E-15;
        if (handler.getMagicData().onMagicSource) {
            return state.setAndContinue(AnimationUtils.createAnimation(builder, SIT_ON_MAGIC_SOURCE));
        }
        if (player.m_5803_() || handler.treasureResting) {
            return state.setAndContinue(AnimationUtils.createAnimation(builder, SLEEP));
        }
        if (player.m_20159_()) {
            return state.setAndContinue(AnimationUtils.createAnimation(builder, SIT));
        }
        if (player.m_150110_().f_35935_ || ServerFlightHandler.isFlying((LivingEntity)player)) {
            if (ServerFlightHandler.isGliding(player)) {
                if (ServerFlightHandler.isSpin(player)) {
                    animationSpeed = 2.0;
                    this.lockTailAndNeck();
                    state.setAnimation(AnimationUtils.createAnimation(builder, FLY_SPIN));
                    animationController.transitionLength(5);
                } else if (deltaMovement.f_82480_ < -1.0) {
                    this.lockTailAndNeck();
                    state.setAnimation(AnimationUtils.createAnimation(builder, FLY_DIVE_ALT));
                    animationController.transitionLength(4);
                } else if (deltaMovement.f_82480_ < -0.25) {
                    this.lockTailAndNeck();
                    state.setAnimation(AnimationUtils.createAnimation(builder, FLY_DIVE));
                    animationController.transitionLength(4);
                } else if (deltaMovement.f_82480_ > 0.5) {
                    animationSpeed = 1.5;
                    state.setAnimation(AnimationUtils.createAnimation(builder, FLY));
                    animationController.transitionLength(2);
                } else {
                    state.setAnimation(AnimationUtils.createAnimation(builder, FLY_SOARING));
                    animationController.transitionLength(4);
                }
            } else if (player.m_6047_() && deltaMovement.f_82480_ < 0.0 && distanceFromGround < 10.0 && deltaMovement.m_82553_() < 4.0) {
                state.setAnimation(AnimationUtils.createAnimation(builder, FLY_LAND));
                animationController.transitionLength(2);
            } else if (ServerFlightHandler.isSpin(player)) {
                this.lockTailAndNeck();
                state.setAnimation(AnimationUtils.createAnimation(builder, FLY_SPIN));
                animationController.transitionLength(2);
            } else {
                if (deltaMovement.f_82480_ > 0.0) {
                    animationSpeed = 2.0;
                }
                state.setAnimation(AnimationUtils.createAnimation(builder, FLY));
                animationController.transitionLength(2);
            }
        } else if (player.m_20089_() == Pose.SWIMMING) {
            if (ServerFlightHandler.isSpin(player)) {
                this.lockTailAndNeck();
                state.setAnimation(AnimationUtils.createAnimation(builder, FLY_SPIN));
                animationController.transitionLength(2);
            } else {
                useDynamicScaling = true;
                baseSpeed = 0.13;
                state.setAnimation(AnimationUtils.createAnimation(builder, SWIM_FAST));
                animationController.transitionLength(2);
            }
        } else if ((player.m_20077_() || player.m_20072_()) && !player.m_20096_()) {
            if (ServerFlightHandler.isSpin(player)) {
                animationSpeed = 2.0;
                this.lockTailAndNeck();
                state.setAnimation(AnimationUtils.createAnimation(builder, FLY_SPIN));
                animationController.transitionLength(2);
            } else {
                if (!(AnimationUtils.isAnimationPlaying(animationController, SWIM) || AnimationUtils.isAnimationPlaying(animationController, SWIM_FAST) || AnimationUtils.isAnimationPlaying(animationController, FLY_SPIN))) {
                    this.clearVerticalVelocity();
                }
                this.lockTailAndNeck();
                useDynamicScaling = true;
                baseSpeed = 0.051;
                state.setAnimation(AnimationUtils.createAnimation(builder, SWIM));
                animationController.transitionLength(2);
            }
        } else if (AnimationUtils.isAnimationPlaying(animationController, FLY_LAND)) {
            state.setAnimation(AnimationUtils.createAnimation(builder, FLY_LAND_END));
            animationController.transitionLength(2);
        } else if (!AnimationUtils.isAnimationPlaying(animationController, FLY_LAND_END)) {
            if (!player.m_20096_() && ClientEvents.dragonsJumpingTicks.getOrDefault(this.playerId, 0) > 0) {
                state.setAnimation(AnimationUtils.createAnimation(builder, JUMP));
                animationController.transitionLength(1);
            } else if (!player.m_20096_()) {
                state.setAnimation(AnimationUtils.createAnimation(builder, FALL_LOOP));
                animationController.transitionLength(6);
            } else if (player.m_6144_() || !DragonSizeHandler.canPoseFit((LivingEntity)player, Pose.STANDING) && DragonSizeHandler.canPoseFit((LivingEntity)player, Pose.CROUCHING)) {
                if (hasMoveInput) {
                    useDynamicScaling = true;
                    baseSpeed = 0.03;
                    state.setAnimation(AnimationUtils.createAnimation(builder, SNEAK_WALK));
                    animationController.transitionLength(5);
                } else if (handler.getMovementData().dig) {
                    state.setAnimation(AnimationUtils.createAnimation(builder, DIG_SNEAK));
                    animationController.transitionLength(5);
                } else {
                    state.setAnimation(AnimationUtils.createAnimation(builder, SNEAK));
                    animationController.transitionLength(5);
                }
            } else if (player.m_20142_()) {
                useDynamicScaling = true;
                baseSpeed = 0.165;
                state.setAnimation(AnimationUtils.createAnimation(builder, RUN));
                animationController.transitionLength(2);
            } else if (hasMoveInput) {
                useDynamicScaling = true;
                state.setAnimation(AnimationUtils.createAnimation(builder, WALK));
                animationController.transitionLength(2);
            } else if (handler.getMovementData().dig) {
                state.setAnimation(AnimationUtils.createAnimation(builder, DIG));
                animationController.transitionLength(2);
            } else {
                state.setAnimation(AnimationUtils.createAnimation(builder, IDLE));
                animationController.transitionLength(2);
            }
        }
        double finalAnimationSpeed = animationSpeed;
        if (useDynamicScaling) {
            double horizontalDistance = deltaMovement.m_165924_();
            double speedComponent = Math.min(ClientConfig.maxAnimationSpeedFactor, (horizontalDistance - baseSpeed) / baseSpeed * speedFactor);
            double sizeDistance = handler.getSize() - baseSize;
            double sizeFactor = sizeDistance >= 0.0 ? bigSizeFactor : smallSizeFactor;
            double sizeComponent = baseSize / (baseSize + sizeDistance * sizeFactor);
            finalAnimationSpeed = Math.min(ClientConfig.maxAnimationSpeed, Math.max(ClientConfig.minAnimationSpeed, (animationSpeed + speedComponent) * sizeComponent));
        }
        AnimationUtils.setAnimationSpeed(finalAnimationSpeed, state.getAnimationTick(), animationController);
        return PlayState.CONTINUE;
    }

    private RawAnimation renderAbility(AnimationState<DragonEntity> state, ActiveDragonAbility currentCast) {
        RawAnimation rawAnimation = null;
        if (currentCast != null && this.lastCast == null) {
            if (currentCast.getStartingAnimation() != null) {
                AbilityAnimation animation = currentCast.getStartingAnimation();
                this.neckLocked = animation.locksNeck;
                this.tailLocked = animation.locksTail;
                if (!this.started) {
                    this.animationTimer.putAnimation(animation.animationKey, animation.duration);
                    this.started = true;
                }
                rawAnimation = RawAnimation.begin().thenLoop(animation.animationKey);
                if (this.animationTimer.getDuration(animation.animationKey) <= 0.0) {
                    this.lastCast = currentCast;
                    this.started = false;
                }
            } else if (currentCast.getLoopingAnimation() != null) {
                AbilityAnimation animation = currentCast.getLoopingAnimation();
                this.neckLocked = animation.locksNeck;
                this.tailLocked = animation.locksTail;
                this.lastCast = currentCast;
                rawAnimation = RawAnimation.begin().thenLoop(animation.animationKey);
            }
        } else if (currentCast != null) {
            this.lastCast = currentCast;
            if (currentCast.getLoopingAnimation() != null) {
                AbilityAnimation animation = currentCast.getLoopingAnimation();
                this.neckLocked = animation.locksNeck;
                this.tailLocked = animation.locksTail;
                rawAnimation = RawAnimation.begin().thenLoop(animation.animationKey);
            }
        } else if (this.lastCast != null) {
            if (this.lastCast.getStoppingAnimation() != null) {
                AbilityAnimation stopAnimation = this.lastCast.getStoppingAnimation();
                this.neckLocked = stopAnimation.locksNeck;
                this.tailLocked = stopAnimation.locksTail;
                if (!this.ended) {
                    this.animationTimer.putAnimation(stopAnimation.animationKey, stopAnimation.duration);
                    this.ended = true;
                }
                rawAnimation = RawAnimation.begin().thenPlay(stopAnimation.animationKey);
                if (this.animationTimer.getDuration(stopAnimation.animationKey) <= 0.0) {
                    this.lastCast = null;
                    this.ended = false;
                }
            } else {
                this.lastCast = null;
            }
        }
        return rawAnimation;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean shouldPlayAnimsWhileGamePaused() {
        return true;
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return this.playerId != null ? this.getPlayer().m_6168_() : List.of();
    }

    @NotNull
    public ItemStack m_6844_(@NotNull EquipmentSlot slotIn) {
        return this.playerId != null ? this.getPlayer().m_6844_(slotIn) : ItemStack.f_41583_;
    }

    public void m_8061_(@NotNull EquipmentSlot slotIn, @NotNull ItemStack stack) {
        if (this.playerId != null) {
            this.getPlayer().m_8061_(slotIn, stack);
        }
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return this.playerId != null ? this.getPlayer().m_5737_() : HumanoidArm.LEFT;
    }

    public boolean m_142389_() {
        return true;
    }
}

