/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.creatures;

import by.dragonsurvivalteam.dragonsurvival.client.render.util.AnimationTimer;
import by.dragonsurvivalteam.dragonsurvival.client.render.util.CommonTraits;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.DragonHunter;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.Hunter;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.PrinceHorseEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.PrincesHorseEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.FollowMobGoal;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.HunterEntityCheckProcedure;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KnightEntity
extends PathfinderMob
implements GeoEntity,
DragonHunter,
CommonTraits {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final AnimationTimer animationTimer = new AnimationTimer();
    private static final RawAnimation ATTACK = RawAnimation.begin().thenPlay("attack");
    private static final RawAnimation ATTACK_2 = RawAnimation.begin().thenPlay("attack2");
    private static final RawAnimation RUN = RawAnimation.begin().thenPlay("run");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation IDLE_2 = RawAnimation.begin().thenPlay("idle_2");

    public KnightEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "everything", 3, state -> {
            AnimationProcessor.QueuedAnimation currentAnimation;
            AnimationController animationController = state.getController();
            double movement = this.getMovementSpeed((LivingEntity)this);
            if (this.f_20913_ > 0 && (currentAnimation = animationController.getCurrentAnimation()) != null) {
                switch (currentAnimation.animation().name()) {
                    case "attack": {
                        if (!(this.animationTimer.getDuration("attack2") <= 0.0)) break;
                        if (this.f_19796_.m_188499_()) {
                            this.animationTimer.putAnimation("attack", 17.0);
                            return state.setAndContinue(ATTACK);
                        }
                        this.animationTimer.putAnimation("attack2", 17.0);
                        return state.setAndContinue(ATTACK_2);
                    }
                    case "attack2": {
                        if (!(this.animationTimer.getDuration("attack") <= 0.0)) break;
                        if (this.f_19796_.m_188499_()) {
                            this.animationTimer.putAnimation("attack", 17.0);
                            return state.setAndContinue(ATTACK);
                        }
                        this.animationTimer.putAnimation("attack2", 17.0);
                        return state.setAndContinue(ATTACK_2);
                    }
                    default: {
                        if (this.f_19796_.m_188499_()) {
                            this.animationTimer.putAnimation("attack", 17.0);
                            return state.setAndContinue(ATTACK);
                        }
                        this.animationTimer.putAnimation("attack2", 17.0);
                        return state.setAndContinue(ATTACK_2);
                    }
                }
            }
            if (movement > 0.5) {
                return state.setAndContinue(WALK);
            }
            if (movement > 0.05) {
                return state.setAndContinue(RUN);
            }
            currentAnimation = animationController.getCurrentAnimation();
            if (currentAnimation == null) {
                this.animationTimer.putAnimation("idle", 88.0);
                return state.setAndContinue(IDLE);
            }
            switch (currentAnimation.animation().name()) {
                case "idle": {
                    if (!(this.animationTimer.getDuration("idle") <= 0.0) || this.f_19796_.m_188503_(2000) != 0) break;
                    this.animationTimer.putAnimation("idle_2", 145.0);
                    return state.setAndContinue(IDLE_2);
                }
                case "walk": 
                case "run": {
                    this.animationTimer.putAnimation("idle", 88.0);
                    return state.setAndContinue(IDLE);
                }
                case "idle_2": {
                    if (!(this.animationTimer.getDuration("idle_2") <= 0.0)) break;
                    this.animationTimer.putAnimation("idle", 88.0);
                    return state.setAndContinue(IDLE);
                }
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Hunter.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 1, true, false, living -> living.m_21023_(MobEffects.f_19594_) || living.m_21023_(DragonEffects.ROYAL_CHASE)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal<Monster>((Mob)this, Monster.class, false, false){

            public boolean m_8036_() {
                return super.m_8036_() && HunterEntityCheckProcedure.execute((Entity)KnightEntity.this);
            }

            public boolean m_8045_() {
                return super.m_8045_() && HunterEntityCheckProcedure.execute((Entity)KnightEntity.this);
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal(this, 2.0, false){

            protected double m_6639_(@NotNull LivingEntity entity) {
                return 4.0 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21346_.m_25352_(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(7, new FollowMobGoal(PrinceHorseEntity.class, (Mob)this, 15));
        this.f_21345_.m_25352_(8, new FollowMobGoal(PrincesHorseEntity.class, (Mob)this, 15));
        this.f_21345_.m_25352_(9, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.1));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public int m_213860_() {
        return 5 + this.m_217043_().m_188503_(5);
    }

    public void m_8119_() {
        this.m_21203_();
        super.m_8119_();
    }

    public boolean m_6785_(double distance) {
        return !this.m_8077_() && this.f_19797_ >= Functions.minutesToTicks(ServerConfig.hunterDespawnDelay);
    }

    public boolean m_21254_() {
        if (this.m_21206_().m_41720_() == Items.f_42740_) {
            return this.f_19796_.m_188499_();
        }
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverWorld, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag nbt) {
        this.m_213945_(this.f_19796_, difficultyInstance);
        return super.m_6518_(serverWorld, difficultyInstance, spawnReason, entityData, nbt);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42383_));
        if (this.f_19796_.m_188500_() < ServerConfig.knightShieldChance) {
            this.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42740_));
        }
    }
}

