/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.creatures;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.Hunter;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.KnightEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.CrossbowAttackGoal;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.FollowMobGoal;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.HunterEntityCheckProcedure;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.Bolas;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Shooter
extends Hunter
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(Shooter.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int bolasCooldown = this.getBolasCooldown();

    public Shooter(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected int getBolasCooldown() {
        return Functions.secondsToTicks(ServerConfig.hunterBolasFrequency + (this.f_19796_.m_188500_() - 0.5) * ServerConfig.hunterBolasFrequency / 5.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<Shooter>(this, 1.0, 8.0f));
        this.f_21345_.m_25352_(7, new FollowMobGoal(KnightEntity.class, (Mob)this, 15));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Shooter.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 1, true, false, living -> living.m_21023_(MobEffects.f_19594_) || living.m_21023_(DragonEffects.ROYAL_CHASE)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false){

            public boolean m_8036_() {
                Shooter entity = Shooter.this;
                return super.m_8036_() && HunterEntityCheckProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                Shooter entity = Shooter.this;
                return super.m_8045_() && HunterEntityCheckProcedure.execute((Entity)entity);
            }
        });
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!ServerConfig.hunterHasBolas.booleanValue()) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target instanceof Player) {
            if (this.bolasCooldown == 0) {
                if (target.m_21023_(DragonEffects.TRAPPED)) {
                    return;
                }
                this.performBolasThrow(target);
                this.bolasCooldown = this.getBolasCooldown();
            } else {
                --this.bolasCooldown;
            }
        }
    }

    public void performBolasThrow(LivingEntity target) {
        Bolas bolas = new Bolas((LivingEntity)this, this.m_9236_());
        Vec3 targetPos = target.m_20182_();
        if (target instanceof Player) {
            Player player = (Player)target;
            DragonStateHandler handler = DragonStateProvider.getHandler((Entity)player);
            targetPos = handler == null || !handler.isDragon() ? targetPos.m_82520_(0.0, (double)player.m_20192_(), 0.0) : targetPos.m_82520_(0.0, DragonSizeHandler.calculateDragonEyeHeight(handler.getSize(), ServerConfig.hitboxGrowsPastHuman), 0.0);
        }
        Vec3 rawShootDirection = targetPos.m_82546_(bolas.m_146892_());
        float distance = (float)rawShootDirection.m_82553_();
        targetPos = targetPos.m_82520_(0.0, (double)(distance / 10.0f), 0.0);
        targetPos = targetPos.m_82549_(target.m_20184_().m_82490_((double)(distance / 5.0f)));
        Vec3 shootDirection = targetPos.m_82546_(bolas.m_146892_()).m_82541_();
        bolas.m_6686_(shootDirection.f_82479_, shootDirection.f_82480_, shootDirection.f_82481_, 1.6f, 0.98f);
        this.m_5496_(SoundEvents.f_12553_, 1.0f, 0.4f);
        this.m_9236_().m_7967_((Entity)bolas);
    }

    @Override
    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isChargingCrossbow()) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
        }
        if (this.m_21093_(item -> item.m_41720_() instanceof CrossbowItem)) {
            return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
        }
        return this.m_5912_() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean p_213671_1_) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)p_213671_1_);
    }

    public void m_5811_(LivingEntity p_230284_1_, ItemStack p_230284_2_, Projectile p_230284_3_, float p_230284_4_) {
        this.m_32322_((LivingEntity)this, p_230284_1_, p_230284_3_, p_230284_4_, 1.6f);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
        ItemStack crossbow = this.m_21120_(InteractionHand.MAIN_HAND);
        this.addArrow(crossbow);
    }

    private void addArrow(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41784_();
        ListTag listNBT = compoundNBT.m_128437_("ChargedProjectiles", 10);
        CompoundTag nbt = new CompoundTag();
        new ItemStack((ItemLike)Items.f_42412_).m_41739_(nbt);
        listNBT.add((Object)nbt);
        compoundNBT.m_128365_("ChargedProjectiles", (Tag)listNBT);
    }

    public void m_6504_(LivingEntity p_82196_1_, float p_82196_2_) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        compoundNBT.m_128405_("Bolas cooldown", this.bolasCooldown);
    }

    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        this.bolasCooldown = compoundNBT.m_128451_("Bolas cooldown");
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance p_180481_1_) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42717_);
        this.addArrow(stack);
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
    }

    public boolean m_6785_(double distance) {
        return !this.m_8077_() && this.f_19797_ >= Functions.minutesToTicks(ServerConfig.hunterDespawnDelay);
    }
}

