/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles;

import by.dragonsurvivalteam.dragonsurvival.client.particles.SeaDragon.LargeLightningParticleData;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.DragonBallEntity;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.active.BallLightningAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.active.StormBreathAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import by.dragonsurvivalteam.dragonsurvival.util.TargetingFunctions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Fireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BallLightningEntity
extends DragonBallEntity {
    protected boolean isLingering = false;
    protected int lingerTicks = 100;
    protected LargeLightningParticleData trail = new LargeLightningParticleData(37.0f, false);
    private static final RawAnimation EXPLOSION = RawAnimation.begin().thenLoop("explosion");
    private static final RawAnimation IDLE = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation FLY = RawAnimation.begin().thenLoop("fly");

    public BallLightningEntity(Level p_i50168_9_, LivingEntity p_i50168_2_, double p_i50168_3_, double p_i50168_5_, double p_i50168_7_) {
        super((EntityType<? extends Fireball>)((EntityType)DSEntities.BALL_LIGHTNING.get()), p_i50168_2_, p_i50168_3_, p_i50168_5_, p_i50168_7_, p_i50168_9_);
    }

    public BallLightningEntity(EntityType<? extends Fireball> p_i50166_1_, Level p_i50166_2_) {
        super(p_i50166_1_, p_i50166_2_);
    }

    protected ParticleOptions m_5967_() {
        return this.trail;
    }

    protected boolean m_5931_() {
        return false;
    }

    @Override
    public float getExplosivePower() {
        return (float)this.getSkillLevel() / 1.25f;
    }

    @Override
    protected DamageSource getDamageSource(Fireball pFireball, @Nullable Entity pIndirectEntity) {
        return DSDamageTypes.damageSource(pFireball.m_9236_(), DSDamageTypes.DRAGON_BALL_LIGHTNING);
    }

    protected void onHitCommon() {
        if ((this.m_19749_() == null || !this.m_19749_().m_213877_()) && this.m_9236_().m_46805_(this.m_20183_())) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.HOSTILE, 3.0f, 0.5f);
            }
            this.isLingering = true;
        }
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        this.onHitCommon();
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        this.onHitCommon();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_46467_() % 5L == 0L) {
            this.attackMobs();
        }
        if (this.isLingering) {
            --this.lingerTicks;
            if (this.lingerTicks <= 0) {
                this.m_146870_();
            }
        }
    }

    @NotNull
    public Vec3 m_20184_() {
        if (this.isLingering) {
            return Vec3.f_82478_;
        }
        return super.m_20184_();
    }

    public void attackMobs() {
        DamageSource source;
        int range = 4;
        Entity owner = this.m_19749_();
        if (owner instanceof Player) {
            range = DragonAbilities.getSelfAbility((LivingEntity)((Player)owner), BallLightningAbility.class).getRange();
            source = owner.m_269291_().m_269075_((Player)owner);
        } else {
            source = this.m_269291_().m_269548_();
        }
        List entities = this.m_9236_().m_45933_(owner, new AABB(this.m_20182_().f_82479_ - (double)range, this.m_20182_().f_82480_ - (double)range, this.m_20182_().f_82481_ - (double)range, this.m_20182_().f_82479_ + (double)range, this.m_20182_().f_82480_ + (double)range, this.m_20182_().f_82481_ + (double)range));
        entities.removeIf(e -> e instanceof BallLightningEntity);
        entities.removeIf(e -> !(e instanceof LivingEntity));
        for (Entity ent : entities) {
            if (!this.m_9236_().m_5776_()) {
                LivingEntity livingEntity;
                TargetingFunctions.attackTargets(owner, ent1 -> ent1.m_6469_(source, BallLightningAbility.getDamage(this.getSkillLevel())), ent);
                if (ent instanceof LivingEntity) {
                    livingEntity = (LivingEntity)ent;
                    if (livingEntity.m_217043_().m_188503_(100) < 40 && !livingEntity.m_9236_().m_5776_() && !StormBreathAbility.chargedBlacklist.contains(ResourceHelper.getKey((Entity)livingEntity).toString())) {
                        livingEntity.m_7292_(new MobEffectInstance(DragonEffects.CHARGED, Functions.secondsToTicks(10), 0, false, true));
                    }
                    this.m_9236_().m_245747_(this.m_20183_(), SoundEvents.f_12089_, SoundSource.WEATHER, 2.0f, 0.5f, true);
                }
                if (owner instanceof LivingEntity) {
                    livingEntity = (LivingEntity)owner;
                    this.m_19970_(livingEntity, ent);
                }
            }
            if (!this.m_9236_().m_5776_()) continue;
            int steps = 10;
            float stepSize = 1.0f / (float)steps;
            Vec3 distV = new Vec3(this.m_20185_() - ent.m_20185_(), this.m_20186_() - ent.m_20186_(), this.m_20189_() - ent.m_20189_());
            for (int i = 0; i < steps; ++i) {
                Vec3 step = ent.m_20182_().m_82549_(distV.m_82490_((double)(stepSize * (float)i)));
                this.m_9236_().m_7106_((ParticleOptions)new LargeLightningParticleData(16.0f, false), step.m_7096_(), step.m_7098_(), step.m_7094_(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46470_() && this.m_9236_().f_46441_.m_188503_(100) < 30 && this.m_9236_().m_45527_(this.m_20183_())) {
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
            lightningboltentity.m_20219_(new Vec3(this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_));
            this.m_9236_().m_7967_((Entity)lightningboltentity);
        }
    }

    @Override
    public PlayState predicate(AnimationState<DragonBallEntity> state) {
        if (!this.isLingering) {
            state.getController().setAnimation(FLY);
            return PlayState.CONTINUE;
        }
        if (this.lingerTicks < 16) {
            state.getController().setAnimation(EXPLOSION);
        } else {
            state.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }
}

