/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncFlyingStatus;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class Bolas
extends ThrowableItemProjectile {
    public static final UUID SLOW_MOVEMENT = UUID.fromString("eab67409-4834-43d8-bdf6-736dc96375f2");
    public static final UUID DISABLE_JUMP = UUID.fromString("d7c976cd-edba-46aa-9002-294d429d7741");

    public Bolas(Level world) {
        super((EntityType)DSEntities.BOLAS_ENTITY.get(), world);
    }

    public Bolas(double p_i50156_2_, double p_i50156_4_, double p_i50156_6_, Level world) {
        super((EntityType)DSEntities.BOLAS_ENTITY.get(), p_i50156_2_, p_i50156_4_, p_i50156_6_, world);
    }

    public Bolas(LivingEntity shooter, Level world) {
        super((EntityType)DSEntities.BOLAS_ENTITY.get(), shooter, world);
    }

    protected Item m_7881_() {
        return DSItems.huntingNet;
    }

    protected void m_6532_(HitResult p_70227_1_) {
        super.m_6532_(p_70227_1_);
        if (!this.m_9236_().m_5776_()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (!entity.m_9236_().m_5776_() && entity instanceof LivingEntity) {
            Player player;
            DragonStateHandler handler;
            LivingEntity living = (LivingEntity)entity;
            AttributeInstance movementSpeed = living.m_21051_(Attributes.f_22279_);
            AttributeModifier bolasTrap = new AttributeModifier(SLOW_MOVEMENT, "Slow Movement", -movementSpeed.m_22135_() / 2.0, AttributeModifier.Operation.ADDITION);
            boolean addEffect = false;
            if (!movementSpeed.m_22109_(bolasTrap)) {
                movementSpeed.m_22118_(bolasTrap);
                addEffect = true;
            }
            if (entity instanceof Player && (handler = DragonUtils.getHandler((Entity)(player = (Player)entity))).isDragon()) {
                handler.setWingsSpread(false);
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> living), (Object)new SyncFlyingStatus(living.m_19879_(), false));
            }
            if (addEffect) {
                living.m_7292_(new MobEffectInstance(DragonEffects.TRAPPED, Functions.secondsToTicks(ServerConfig.hunterTrappedDebuffDuration)));
            }
        }
    }
}

