/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.ForestDragon.passive.CliffhangerAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonModifiers;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.Objects;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DragonBonusHandler {
    @SubscribeEvent
    public static void dragonDamageImmunities(LivingAttackEvent event) {
        LivingEntity living = event.getEntity();
        DamageSource damageSource = event.getSource();
        DragonStateProvider.getCap((Entity)living).ifPresent(handler -> {
            if (handler.isDragon()) {
                if (ServerConfig.bonuses.booleanValue()) {
                    if (ServerConfig.caveFireImmunity.booleanValue() && DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.CAVE) && damageSource.m_269533_(DamageTypeTags.f_268745_)) {
                        event.setCanceled(true);
                    } else if (ServerConfig.forestBushImmunity.booleanValue() && DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.FOREST) && damageSource == living.m_269291_().m_269555_()) {
                        event.setCanceled(true);
                    } else if (ServerConfig.forestCactiImmunity.booleanValue() && damageSource == living.m_269291_().m_269325_()) {
                        event.setCanceled(true);
                    }
                }
                if (ServerConfig.caveSplashDamage != 0.0 && DragonUtils.isDragonType(handler, (AbstractDragonType)DragonTypes.CAVE) && !living.m_21023_(DragonEffects.FIRE) && damageSource.m_7640_() instanceof Snowball) {
                    living.m_6469_(living.m_269291_().m_269264_(), ServerConfig.caveSplashDamage.floatValue());
                }
            }
        });
    }

    @SubscribeEvent
    public static void removeLavaFootsteps(PlayLevelSoundEvent.AtEntity event) {
        boolean isRelevant;
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getSound() != null && (isRelevant = ((SoundEvent)event.getSound().get()).m_11660_().m_135815_().contains(".step")) && ServerConfig.bonuses.booleanValue() && ServerConfig.caveLavaSwimming.booleanValue() && DragonUtils.isDragonType((Entity)player, (AbstractDragonType)DragonTypes.CAVE) && DragonSizeHandler.getOverridePose((LivingEntity)player) == Pose.SWIMMING) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void reduceFallDistance(LivingFallEvent livingFallEvent) {
        LivingEntity living = livingFallEvent.getEntity();
        DragonStateProvider.getCap((Entity)living).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                float distance = livingFallEvent.getDistance();
                if (Objects.equals(dragonStateHandler.getType(), DragonTypes.FOREST)) {
                    if (ServerConfig.bonuses.booleanValue()) {
                        distance -= ServerConfig.forestFallReduction.floatValue();
                    }
                    CliffhangerAbility ability = DragonAbilities.getSelfAbility(living, CliffhangerAbility.class);
                    distance -= (float)ability.getHeight();
                }
                float gravity = (float)livingFallEvent.getEntity().m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                float jumpHeight = (float)DragonModifiers.getJumpBonus(dragonStateHandler) * 1.5f;
                distance -= (float)(Math.pow(jumpHeight, 2.0) / (double)(2.0f * gravity));
                AbstractDragonBody body = dragonStateHandler.getBody();
                if (body != null && body.getGravityMult() <= 1.0) {
                    distance = body.getGravityMult() == 0.0 ? 0.0f : (float)((double)distance * body.getGravityMult());
                } else if (body != null) {
                    distance = (float)((double)distance * ((body.getGravityMult() - 1.0) / 2.0 + 1.0));
                }
                livingFallEvent.setDistance(distance);
            }
        });
    }
}

