/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncSize;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="dragonsurvival")
public class DragonGrowthHandler {
    public static long newbornToYoung = TimeUnit.SECONDS.convert(3L, TimeUnit.HOURS);
    public static long youngToAdult = TimeUnit.SECONDS.convert(15L, TimeUnit.HOURS);
    public static long adultToMax = TimeUnit.SECONDS.convert(24L, TimeUnit.HOURS);
    public static long beyond = TimeUnit.SECONDS.convert(30L, TimeUnit.DAYS);

    @SubscribeEvent
    public static void onItemUse(PlayerInteractEvent.RightClickItem event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        Player player = event.getEntity();
        Level world = player.m_20193_();
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
            if (!handler.isDragon()) {
                return;
            }
            double size = handler.getSize();
            if (size >= ServerConfig.maxGrowthSize) {
                return;
            }
            boolean canContinue = false;
            List<Item> newbornList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growNewborn);
            List<Item> youngList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growYoung);
            List<Item> adultList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growAdult);
            List<Object> allowedItems = new ArrayList();
            switch (handler.getLevel()) {
                case NEWBORN: {
                    if (newbornList.contains(item)) {
                        canContinue = true;
                        break;
                    }
                    if (!youngList.contains(item) && !adultList.contains(item)) break;
                    allowedItems = newbornList;
                    break;
                }
                case YOUNG: {
                    if (youngList.contains(item)) {
                        canContinue = true;
                        break;
                    }
                    if (!newbornList.contains(item) && !adultList.contains(item)) break;
                    allowedItems = youngList;
                    break;
                }
                case ADULT: {
                    if (adultList.contains(item)) {
                        canContinue = true;
                        break;
                    }
                    if (!newbornList.contains(item) && !youngList.contains(item)) break;
                    allowedItems = adultList;
                }
            }
            if (!canContinue) {
                if (!allowedItems.isEmpty() && world.m_5776_()) {
                    List<String> displayData = allowedItems.stream().map(i -> new ItemStack((ItemLike)i).m_41611_().getString()).toList();
                    StringBuilder result = new StringBuilder();
                    for (int i2 = 0; i2 < displayData.size(); ++i2) {
                        String entry = displayData.get(i2);
                        result.append(entry).append(i2 + 1 < displayData.size() ? ", " : "");
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"ds.invalid_grow_item", (Object[])new Object[]{result}), false);
                }
                return;
            }
            int increment = DragonGrowthHandler.getIncrement(item, handler.getLevel());
            handler.setSize(size += (double)increment, player);
            if (!player.m_7500_()) {
                event.getItemStack().m_41774_(1);
            }
            if (world.m_5776_()) {
                return;
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSize(player.m_19879_(), size));
            player.m_6210_();
        });
    }

    public static int getIncrement(Item item, DragonLevel level) {
        List<Item> newbornList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growNewborn);
        List<Item> youngList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growYoung);
        List<Item> adultList = ConfigHandler.getResourceElements(Item.class, ServerConfig.growAdult);
        int increment = 0;
        if (item == DSItems.starBone) {
            return -2;
        }
        switch (level) {
            case NEWBORN: {
                if (adultList.contains(item)) {
                    increment = 3;
                    break;
                }
                if (youngList.contains(item)) {
                    increment = 2;
                    break;
                }
                if (!newbornList.contains(item)) break;
                increment = 1;
                break;
            }
            case YOUNG: {
                if (adultList.contains(item)) {
                    increment = 2;
                    break;
                }
                if (!youngList.contains(item)) break;
                increment = 1;
                break;
            }
            case ADULT: {
                if (!adultList.contains(item)) break;
                increment = 1;
            }
        }
        return increment;
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (!ServerConfig.alternateGrowing.booleanValue()) {
            return;
        }
        Player player = event.player;
        Level world = player.m_20193_();
        if (world.m_5776_() || event.phase == TickEvent.Phase.END) {
            return;
        }
        if (!DragonUtils.isDragon((Entity)player)) {
            return;
        }
        if (player.f_19797_ % 1200 != 0) {
            return;
        }
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
            if (handler.growing) {
                double d = 0.0;
                double timeIncrement = 1200.0;
                d = handler.getSize() < (double)DragonLevel.YOUNG.size ? (double)(DragonLevel.YOUNG.size - DragonLevel.NEWBORN.size) / ((double)newbornToYoung * 20.0) * timeIncrement * ServerConfig.newbornGrowthModifier : (handler.getSize() < (double)DragonLevel.ADULT.size ? (double)(DragonLevel.ADULT.size - DragonLevel.YOUNG.size) / ((double)youngToAdult * 20.0) * timeIncrement * ServerConfig.youngGrowthModifier : (handler.getSize() < 40.0 ? (double)(40 - DragonLevel.ADULT.size) / ((double)adultToMax * 20.0) * timeIncrement * ServerConfig.adultGrowthModifier : 20.0 / ((double)beyond * 20.0) * timeIncrement * ServerConfig.maxGrowthModifier));
                double size = handler.getSize() + d;
                size = Math.min(size, ServerConfig.maxGrowthSize);
                if (handler.getSize() != size) {
                    handler.setSize(size, player);
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSize(player.m_19879_(), size));
                    player.m_6210_();
                }
            }
        });
    }
}

