/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.types.SeaDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonTypeData;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class DragonPenaltyHandler {
    @SubscribeEvent
    public static void hitByPotion(ProjectileImpactEvent potionEvent) {
        if (!ServerConfig.penalties.booleanValue() || ServerConfig.caveSplashDamage == 0.0) {
            return;
        }
        Projectile projectile = potionEvent.getProjectile();
        if (projectile instanceof ThrownPotion) {
            ThrownPotion potion = (ThrownPotion)projectile;
            if (potion.m_7846_().m_41720_() != Items.f_42736_) {
                return;
            }
            if (!PotionUtils.m_43579_((ItemStack)potion.m_7846_()).m_43488_().isEmpty()) {
                return;
            }
            Vec3 pos = potionEvent.getRayTraceResult().m_82450_();
            List entities = potion.m_9236_().m_142425_((EntityTypeTest)EntityType.f_20532_, new AABB(pos.f_82479_ - 5.0, pos.f_82480_ - 1.0, pos.f_82481_ - 5.0, pos.f_82479_ + 5.0, pos.f_82480_ + 1.0, pos.f_82481_ + 5.0), entity -> entity.m_20182_().m_82554_(pos) <= 4.0);
            for (Player player : entities) {
                if (player.m_21023_(DragonEffects.FIRE)) continue;
                DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
                    if (dragonStateHandler.isDragon()) {
                        if (dragonStateHandler.getType() == null || !Objects.equals(dragonStateHandler.getType(), DragonTypes.CAVE)) {
                            return;
                        }
                        player.m_6469_(DSDamageTypes.damageSource(player.m_9236_(), DSDamageTypes.WATER_BURN), ServerConfig.caveSplashDamage.floatValue());
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void consumeHurtfulItem(LivingEntityUseItemEvent.Finish destroyItemEvent) {
        LivingEntity livingEntity;
        if (!ServerConfig.penalties.booleanValue() || !((livingEntity = destroyItemEvent.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack itemStack = destroyItemEvent.getItem();
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                ArrayList<String> hurtfulItems = new ArrayList<String>(Objects.equals(dragonStateHandler.getType(), DragonTypes.FOREST) ? ServerConfig.forestDragonHurtfulItems : (Objects.equals(dragonStateHandler.getType(), DragonTypes.CAVE) ? ServerConfig.caveDragonHurtfulItems : (Objects.equals(dragonStateHandler.getType(), DragonTypes.SEA) ? ServerConfig.seaDragonHurtfulItems : new ArrayList())));
                for (String item : hurtfulItems) {
                    if (!item.replace("item:", "").replace("tag:", "").startsWith(ResourceHelper.getKey(itemStack.m_41720_()).toString() + ":")) continue;
                    String damage = item.substring(item.lastIndexOf(":") + 1);
                    player.m_6469_(player.m_269291_().m_269264_(), Float.parseFloat(damage));
                    break;
                }
            }
        });
    }

    @SubscribeEvent
    public static void onWaterConsumed(LivingEntityUseItemEvent.Finish destroyItemEvent) {
        if (!ServerConfig.penalties.booleanValue() || ServerConfig.seaTicksWithoutWater == 0) {
            return;
        }
        ItemStack itemStack = destroyItemEvent.getItem();
        DragonStateProvider.getCap((Entity)destroyItemEvent.getEntity()).ifPresent(dragonStateHandler -> {
            AbstractDragonType patt4492$temp;
            if (dragonStateHandler.isDragon() && (patt4492$temp = dragonStateHandler.getType()) instanceof SeaDragonType) {
                SeaDragonType seaDragonType = (SeaDragonType)patt4492$temp;
                Player player = (Player)destroyItemEvent.getEntity();
                if (ServerConfig.seaAllowWaterBottles.booleanValue() && itemStack.m_41720_() instanceof PotionItem && PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43599_ && Objects.equals(dragonStateHandler.getType(), DragonTypes.SEA) && !player.m_9236_().m_5776_()) {
                    seaDragonType.timeWithoutWater = Math.max(seaDragonType.timeWithoutWater - (double)ServerConfig.seaTicksWithoutWaterRestored.intValue(), 0.0);
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncDragonTypeData(player.m_19879_(), seaDragonType));
                }
                if (DragonConfigHandler.SEA_DRAGON_HYDRATION_USE_ALTERNATIVES.contains(itemStack.m_41720_()) && !player.m_9236_().m_5776_()) {
                    seaDragonType.timeWithoutWater = Math.max(seaDragonType.timeWithoutWater - (double)ServerConfig.seaTicksWithoutWaterRestored.intValue(), 0.0);
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncDragonTypeData(player.m_19879_(), seaDragonType));
                }
            }
        });
    }
}

