/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DragonSizeHandler {
    private static final ConcurrentHashMap<String, Boolean> WAS_DRAGON = new ConcurrentHashMap(20);
    private static final ConcurrentHashMap<String, Double> LAST_SIZE = new ConcurrentHashMap(20);

    @SubscribeEvent
    public static void getDragonSize(EntityEvent.Size event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!handler.isDragon()) {
            return;
        }
        double size = handler.getSize();
        double height = DragonSizeHandler.calculateDragonHeight(size, ServerConfig.hitboxGrowsPastHuman);
        double width = DragonSizeHandler.calculateDragonWidth(size, ServerConfig.hitboxGrowsPastHuman);
        double eyeHeight = DragonSizeHandler.calculateDragonEyeHeight(size, ServerConfig.hitboxGrowsPastHuman);
        boolean squish = false;
        if (handler.getBody() != null) {
            squish = handler.getBody().isSquish();
            height *= handler.getBody().getHeightMult().doubleValue();
            eyeHeight *= handler.getBody().getEyeHeightMult().doubleValue();
        }
        if (ServerConfig.sizeChangesHitbox.booleanValue()) {
            Pose overridePose = DragonSizeHandler.overridePose(player);
            height = DragonSizeHandler.calculateModifiedHeight(height, overridePose, true, squish);
            eyeHeight = DragonSizeHandler.calculateModifiedEyeHeight(eyeHeight, overridePose, squish);
            event.setNewEyeHeight((float)eyeHeight);
            event.setNewSize(DragonSizeHandler.calculateDimensions(width, height));
        }
    }

    public static double getDragonHeight(Player player) {
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        double height = DragonSizeHandler.calculateDragonHeight(handler.getSize(), ServerConfig.hitboxGrowsPastHuman);
        boolean squish = false;
        if (handler.getBody() != null) {
            height *= handler.getBody().getHeightMult().doubleValue();
            squish = handler.getBody().isSquish();
        }
        Pose overridePose = DragonSizeHandler.overridePose(player);
        return DragonSizeHandler.calculateModifiedHeight(height, overridePose, true, squish);
    }

    public static double calculateDragonHeight(double size, boolean growsPastHuman) {
        double height = (size + 4.0) / 20.0;
        if (!growsPastHuman) {
            height = 0.9 + 0.9 * (size - 14.0) / (ServerConfig.maxGrowthSize - 14.0);
        }
        return height;
    }

    public static double calculateDragonWidth(double size, boolean growsPastHuman) {
        double width = (3.0 * size + 62.0) / 260.0;
        if (!growsPastHuman) {
            width = 0.4 + 0.2 * (size - 14.0) / (ServerConfig.maxGrowthSize - 14.0);
        }
        return width;
    }

    public static double calculateDragonEyeHeight(double size, boolean growsPastHuman) {
        double eyeHeight = (11.0 * size + 54.0) / 260.0;
        if (!growsPastHuman) {
            eyeHeight = 0.8 + 0.8 * (size - 14.0) / (ServerConfig.maxGrowthSize - 14.0);
        }
        return eyeHeight;
    }

    public static double calculateModifiedEyeHeight(double eyeHeight, Pose pose, boolean squish) {
        if (pose == Pose.CROUCHING && !squish) {
            eyeHeight *= 0.8333333333333334;
        } else if (pose == Pose.CROUCHING) {
            eyeHeight *= 0.5;
        } else if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING || pose == Pose.SPIN_ATTACK) {
            eyeHeight *= 0.5833333333333334;
        }
        return eyeHeight;
    }

    public static EntityDimensions calculateDimensions(double width, double height) {
        return new EntityDimensions((float)((double)Math.round(width * 100.0) / 100.0), (float)((double)Math.round(height * 100.0) / 100.0), false);
    }

    public static Pose overridePose(Player player) {
        if (player == null) {
            return Pose.STANDING;
        }
        Pose overridePose = DragonSizeHandler.getOverridePose((LivingEntity)player);
        if (player.getForcedPose() != overridePose) {
            player.setForcedPose(overridePose);
            if (player.m_9236_().m_5776_() && Minecraft.m_91087_().m_91288_() != player) {
                player.m_6210_();
            }
        }
        return overridePose;
    }

    public static Pose getOverridePose(LivingEntity player) {
        if (player != null) {
            boolean swimming = (player.m_20072_() || player.m_20077_() && ServerConfig.bonuses != false && ServerConfig.caveLavaSwimming != false && DragonUtils.isDragonType((Entity)player, (AbstractDragonType)DragonTypes.CAVE)) && player.m_20142_() && !player.m_20159_();
            boolean flying = ServerFlightHandler.isFlying(player);
            boolean spinning = player.m_21209_();
            boolean crouching = player.m_6144_();
            if (flying && !player.m_5803_()) {
                return Pose.FALL_FLYING;
            }
            if (swimming || (player.m_20072_() || player.m_20077_()) && !DragonSizeHandler.canPoseFit(player, Pose.STANDING) && DragonSizeHandler.canPoseFit(player, Pose.SWIMMING)) {
                return Pose.SWIMMING;
            }
            if (spinning) {
                return Pose.SPIN_ATTACK;
            }
            if (crouching || !DragonSizeHandler.canPoseFit(player, Pose.STANDING) && DragonSizeHandler.canPoseFit(player, Pose.CROUCHING)) {
                return Pose.CROUCHING;
            }
        }
        return Pose.STANDING;
    }

    public static boolean canPoseFit(LivingEntity player, Pose pose) {
        LazyOptional<DragonStateHandler> capability = DragonStateProvider.getCap((Entity)player);
        if (!capability.isPresent()) {
            return false;
        }
        double size = ((DragonStateHandler)capability.orElseThrow(() -> new IllegalStateException("Dragon State was not valid"))).getSize();
        boolean squish = DragonUtils.getDragonBody((Entity)player) != null ? DragonUtils.getDragonBody((Entity)player).isSquish() : false;
        double height = DragonSizeHandler.calculateModifiedHeight(DragonSizeHandler.calculateDragonHeight((float)size, ServerConfig.hitboxGrowsPastHuman), pose, ServerConfig.sizeChangesHitbox, squish);
        double width = DragonSizeHandler.calculateDragonWidth((float)size, ServerConfig.hitboxGrowsPastHuman);
        return player.m_9236_().m_45772_(DragonSizeHandler.calculateDimensions(width, height).m_20393_(player.m_20182_()));
    }

    public static double calculateModifiedHeight(double height, Pose pose, boolean sizeChangesHitbox, boolean squish) {
        if (pose == Pose.CROUCHING) {
            height = sizeChangesHitbox && !squish ? (height *= 0.8333333333333334) : (sizeChangesHitbox ? (height *= 0.5) : 1.5);
        } else if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING || pose == Pose.SPIN_ATTACK) {
            height = sizeChangesHitbox ? (height *= 0.5833333333333334) : 0.6;
        }
        return height;
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player == null || event.phase == TickEvent.Phase.END || !ServerConfig.sizeChangesHitbox.booleanValue()) {
            return;
        }
        String playerIdSide = player.m_19879_() + event.side.name();
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
            if (handler.isDragon()) {
                DragonSizeHandler.overridePose(player);
                if (!WAS_DRAGON.getOrDefault(playerIdSide, false).booleanValue()) {
                    player.m_6210_();
                    WAS_DRAGON.put(playerIdSide, true);
                } else if (LAST_SIZE.getOrDefault(playerIdSide, 20.0).doubleValue() != handler.getSize()) {
                    player.m_6210_();
                    LAST_SIZE.put(playerIdSide, handler.getSize());
                }
            } else if (WAS_DRAGON.getOrDefault(playerIdSide, false).booleanValue()) {
                player.setForcedPose(null);
                player.m_6210_();
                WAS_DRAGON.put(playerIdSide, false);
            }
        });
    }
}

