/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.magic.common.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.passive.TickablePassiveAbility;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DragonTraitHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = playerTickEvent.player;
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                for (DragonAbility passiveAbility : dragonStateHandler.getMagicData().abilities.values()) {
                    TickablePassiveAbility tickablePassiveAbility;
                    if (!(passiveAbility instanceof TickablePassiveAbility) || (tickablePassiveAbility = (TickablePassiveAbility)passiveAbility).getLevel() <= 0) continue;
                    tickablePassiveAbility.onTick(player);
                }
                dragonStateHandler.getType().onPlayerUpdate(player, (DragonStateHandler)dragonStateHandler);
            }
        });
    }

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        DragonStateHandler handler;
        if (event.getEntity() instanceof Player && (handler = DragonUtils.getHandler((Entity)event.getEntity())).isDragon()) {
            handler.getType().onPlayerDeath();
        }
    }

    public static boolean isInCauldron(BlockState feetBlock, BlockState blockUnder) {
        int level;
        boolean isInCauldron = false;
        if (blockUnder.m_60734_() instanceof LayeredCauldronBlock) {
            int level2;
            if (blockUnder.m_61138_((Property)LayeredCauldronBlock.f_153514_) && (level2 = ((Integer)blockUnder.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) > 0) {
                isInCauldron = true;
            }
        } else if (feetBlock.m_60734_() instanceof LayeredCauldronBlock && feetBlock.m_61138_((Property)LayeredCauldronBlock.f_153514_) && (level = ((Integer)feetBlock.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) > 0) {
            isInCauldron = true;
        }
        return isInCauldron;
    }
}

