/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.TreasureBlock;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncTreasureRestStatus;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib.core.object.Color;

@Mod.EventBusSubscriber
public class DragonTreasureHandler {
    private static int sleepTimer = 0;

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == LogicalSide.CLIENT) {
            return;
        }
        Player player = event.player;
        if (DragonUtils.isDragon((Entity)player)) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            if (handler.treasureResting) {
                if (player.m_6047_() || !(player.m_146900_().m_60734_() instanceof TreasureBlock) || handler.getMovementData().bite) {
                    handler.treasureResting = false;
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncTreasureRestStatus(player.m_19879_(), false));
                    return;
                }
                ++handler.treasureSleepTimer;
                if (ServerConfig.treasureHealthRegen.booleanValue()) {
                    int horizontalRange = 16;
                    int verticalRange = 9;
                    int treasureNearby = 0;
                    for (int x = -(horizontalRange / 2); x < horizontalRange / 2; ++x) {
                        for (int y = -(verticalRange / 2); y < verticalRange / 2; ++y) {
                            for (int z = -(horizontalRange / 2); z < horizontalRange / 2; ++z) {
                                BlockPos pos = player.m_20183_().m_7918_(x, y, z);
                                BlockState state = player.m_9236_().m_8055_(pos);
                                if (!(state.m_60734_() instanceof TreasureBlock)) continue;
                                int layers = (Integer)state.m_61143_((Property)TreasureBlock.LAYERS);
                                treasureNearby += layers;
                            }
                        }
                    }
                    treasureNearby = Mth.m_14045_((int)treasureNearby, (int)0, (int)ServerConfig.maxTreasures);
                    int totalTime = Functions.secondsToTicks(ServerConfig.treasureRegenTicks);
                    int restTimer = totalTime - Functions.secondsToTicks(ServerConfig.treasureRegenTicksReduce * treasureNearby);
                    if (handler.treasureRestTimer >= restTimer) {
                        handler.treasureRestTimer = 0;
                        if (player.m_21223_() < player.m_21233_() + 1.0f) {
                            player.m_5634_(1.0f);
                        }
                    } else {
                        ++handler.treasureRestTimer;
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void playerTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (DragonUtils.isDragon((Entity)player)) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            if (handler.treasureResting) {
                Vec3 velocity = player.m_20184_();
                float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
                if ((double)Math.abs(groundSpeed) > 0.05) {
                    handler.treasureResting = false;
                    NetworkHandler.CHANNEL.sendToServer((Object)new SyncTreasureRestStatus(player.m_19879_(), false));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void sleepScreenRender(RenderGuiOverlayEvent.Post event) {
        LocalPlayer playerEntity = Minecraft.m_91087_().f_91074_;
        if (playerEntity == null || !DragonUtils.isDragon((Entity)playerEntity) || playerEntity.m_5833_()) {
            return;
        }
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(arg_0 -> DragonTreasureHandler.lambda$sleepScreenRender$1(event, (Player)playerEntity, arg_0));
    }

    @SubscribeEvent
    public static void playerAttacked(LivingHurtEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                if (cap.treasureResting) {
                    cap.treasureResting = false;
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncTreasureRestStatus(player.m_19879_(), false));
                }
            });
        }
    }

    private static /* synthetic */ void lambda$sleepScreenRender$1(RenderGuiOverlayEvent.Post event, Player playerEntity, DragonStateHandler cap) {
        if (event.getOverlay() == VanillaGuiOverlay.AIR_LEVEL.type()) {
            Window window = Minecraft.m_91087_().m_91268_();
            float f = playerEntity.m_9236_().m_46490_(1.0f);
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            double val = Mth.m_14089_((float)f);
            if (cap.treasureResting && val < 0.25 && sleepTimer < 100) {
                ++sleepTimer;
            } else if (sleepTimer > 0) {
                --sleepTimer;
            }
            if (sleepTimer > 0) {
                Color darkening = Color.ofRGBA((float)0.05f, (float)0.05f, (float)0.05f, (float)Mth.m_14179_((float)((float)Math.min(sleepTimer, 100) / 100.0f), (float)0.0f, (float)0.5f));
                event.getGuiGraphics().m_280509_(0, 0, window.m_85445_(), window.m_85446_(), darkening.getColor());
            }
        }
    }
}

