/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.data.DSEntityTypeTags;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.container.OpenDragonAltar;
import by.dragonsurvivalteam.dragonsurvival.network.status.PlayerJumpSync;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonModifiers;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class EventHandler {
    static int cycle = 0;

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        ServerPlayer serverPlayer;
        Player player;
        if (event.phase == TickEvent.Phase.START || !((player = event.player) instanceof ServerPlayer) || (serverPlayer = (ServerPlayer)player).m_21224_()) {
            return;
        }
        DragonStateProvider.getCap((Entity)serverPlayer).ifPresent(handler -> {
            if (handler.altarCooldown > 0) {
                --handler.altarCooldown;
            }
            if (!ServerConfig.startWithDragonChoice.booleanValue() || handler.hasUsedAltar || serverPlayer.f_19797_ < Functions.secondsToTicks(5)) {
                return;
            }
            if (!handler.isDragon()) {
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new OpenDragonAltar());
                handler.hasUsedAltar = true;
            }
        });
    }

    @SubscribeEvent
    public static void removeElytraFromDragon(TickEvent.PlayerTickEvent playerTickEvent) {
        if (!ServerConfig.dragonsAllowedToUseElytra.booleanValue() && playerTickEvent.phase == TickEvent.Phase.START) {
            Player player = playerTickEvent.player;
            DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
                if (dragonStateHandler.isDragon() && player instanceof ServerPlayer && cycle >= 40) {
                    ItemStack stack = player.m_150109_().m_8020_(38);
                    Item item = stack.m_41720_();
                    if (item instanceof ElytraItem) {
                        player.m_7197_(player.m_150109_().m_8016_(38), true, false);
                    }
                    cycle = 0;
                } else {
                    ++cycle;
                }
            });
        }
    }

    @SubscribeEvent
    public static void attachAvoidDragonGoal(EntityJoinLevelEvent event) {
        Animal animal;
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Animal && !(animal = (Animal)entity2).m_6095_().m_204039_(DSEntityTypeTags.ANIMAL_AVOID_BLACKLIST)) {
            animal.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)animal, Player.class, entity -> {
                if (!ServerConfig.dragonsAreScary.booleanValue() || entity.m_21023_(DragonEffects.ANIMAL_PEACE)) {
                    return false;
                }
                return DragonUtils.isDragon((Entity)entity);
            }, 20.0f, (double)1.3f, 1.5, EntitySelector.f_20406_::test));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void expDrops(BlockEvent.BreakEvent breakEvent) {
        if (DragonUtils.isDragon((Entity)breakEvent.getPlayer()) && breakEvent.getExpToDrop() > 0) {
            int bonusLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44987_, (LivingEntity)breakEvent.getPlayer());
            int silklevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)breakEvent.getPlayer());
            breakEvent.setExpToDrop(breakEvent.getState().getExpDrop((LevelReader)breakEvent.getLevel(), RandomSource.m_216327_(), breakEvent.getPos(), bonusLevel, silklevel));
        }
    }

    @SubscribeEvent
    public static void createAltar(PlayerInteractEvent.RightClickBlock rightClickBlock) {
        if (!ServerConfig.altarCraftable.booleanValue()) {
            return;
        }
        ItemStack itemStack = rightClickBlock.getItemStack();
        if (itemStack.m_41720_() == DSItems.elderDragonBone && !rightClickBlock.getEntity().m_5833_()) {
            Level world = rightClickBlock.getLevel();
            BlockPos blockPos = rightClickBlock.getPos();
            BlockState blockState = world.m_8055_(blockPos);
            Block block = blockState.m_60734_();
            boolean replace = false;
            rightClickBlock.getEntity().m_5833_();
            rightClickBlock.getEntity().m_7500_();
            BlockPlaceContext deirection = new BlockPlaceContext(rightClickBlock.getLevel(), rightClickBlock.getEntity(), rightClickBlock.getHand(), rightClickBlock.getItemStack(), new BlockHitResult(new Vec3(0.0, 0.0, 0.0), rightClickBlock.getEntity().m_6350_(), blockPos, false));
            if (block == Blocks.f_50069_) {
                world.m_46597_(blockPos, DSBlocks.dragon_altar_stone.m_5573_(deirection));
                replace = true;
            } else if (block == Blocks.f_50079_) {
                world.m_46597_(blockPos, DSBlocks.dragon_altar_mossy_cobblestone.m_5573_(deirection));
                replace = true;
            } else if (block == Blocks.f_50062_) {
                world.m_46597_(blockPos, DSBlocks.dragon_altar_sandstone.m_5573_(deirection));
                replace = true;
            } else if (block == Blocks.f_50394_) {
                world.m_46597_(blockPos, DSBlocks.dragon_altar_red_sandstone.m_5573_(deirection));
                replace = true;
            } else if (ResourceHelper.getKey(block).m_135815_().contains(ResourceHelper.getKey(Blocks.f_49999_).m_135815_())) {
                world.m_46597_(blockPos, DSBlocks.dragon_altar_oak_log.m_5573_(deirection));
                replace = true;
            } else if (ResourceHelper.getKey(block).m_135815_().contains(ResourceHelper.getKey(Blocks.f_50001_).m_135815_())) {
                world.m_46597_(blockPos, DSBlocks.dragon_altar_birch_log.m_5573_(deirection));
                replace = true;
            } else if (block == Blocks.f_50492_) {
                world.m_46597_(blockPos, DSBlocks.dragon_altar_purpur_block.m_5573_(deirection));
                replace = true;
            } else if (block == Blocks.f_50197_) {
                world.m_46597_(blockPos, DSBlocks.dragon_altar_nether_bricks.m_5573_(deirection));
                replace = true;
            } else if (block == Blocks.f_50730_) {
                rightClickBlock.getEntity().m_6350_();
                world.m_46597_(blockPos, DSBlocks.dragon_altar_blackstone.m_5573_(deirection));
                replace = true;
            }
            if (replace) {
                if (!rightClickBlock.getEntity().m_7500_()) {
                    itemStack.m_41774_(1);
                }
                rightClickBlock.setCanceled(true);
                world.m_5594_(rightClickBlock.getEntity(), blockPos, SoundEvents.f_12563_, SoundSource.PLAYERS, 1.0f, 1.0f);
                rightClickBlock.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    @SubscribeEvent
    public static void returnBeacon(PlayerEvent.ItemCraftedEvent craftedEvent) {
        Container inventory = craftedEvent.getInventory();
        ItemStack result = craftedEvent.getCrafting();
        int rem = ContainerHelper.m_18956_((Container)inventory, item -> item.m_41720_() == DSBlocks.fireDragonBeacon.m_5456_() || item.m_41720_() == DSBlocks.magicDragonBeacon.m_5456_() || item.m_41720_() == DSBlocks.peaceDragonBeacon.m_5456_(), (int)1, (boolean)true);
        if (rem == 0 && result.m_41720_() == DSBlocks.dragonBeacon.m_5456_()) {
            craftedEvent.getEntity().m_36356_(new ItemStack((ItemLike)Items.f_42065_));
        }
    }

    @SubscribeEvent
    public static void returnNetherStarHeart(PlayerEvent.ItemCraftedEvent craftedEvent) {
        Container inventory = craftedEvent.getInventory();
        ItemStack result = craftedEvent.getCrafting();
        int rem = ContainerHelper.m_18956_((Container)inventory, item -> item.m_41720_() == DSItems.starHeart, (int)1, (boolean)true);
        if (rem == 0 && result.m_41720_() == DSItems.starHeart.m_5456_()) {
            craftedEvent.getEntity().m_36356_(new ItemStack((ItemLike)Items.f_42686_));
        }
    }

    @SubscribeEvent
    public static void returnNetherStarBone(PlayerEvent.ItemCraftedEvent craftedEvent) {
        Container inventory = craftedEvent.getInventory();
        ItemStack result = craftedEvent.getCrafting();
        int rem = ContainerHelper.m_18956_((Container)inventory, item -> item.m_41720_() == DSItems.starBone, (int)1, (boolean)true);
        if (rem == 0 && result.m_41720_() == DSItems.starBone.m_5456_()) {
            craftedEvent.getEntity().m_36356_(new ItemStack((ItemLike)Items.f_42686_));
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent jumpEvent) {
        LivingEntity living = jumpEvent.getEntity();
        if (living.m_21124_(DragonEffects.TRAPPED) != null) {
            Vec3 deltaMovement = living.m_20184_();
            living.m_20334_(deltaMovement.f_82479_, deltaMovement.f_82480_ < 0.0 ? deltaMovement.f_82480_ : 0.0, deltaMovement.f_82481_);
            living.m_6862_(false);
            return;
        }
        DragonStateProvider.getCap((Entity)living).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                Double jumpBonus = 0.0;
                if (dragonStateHandler.getBody() != null) {
                    jumpBonus = DragonModifiers.getJumpBonus(dragonStateHandler);
                }
                living.m_5997_(0.0, jumpBonus.doubleValue(), 0.0);
                if (living instanceof ServerPlayer) {
                    if (living.m_20194_().m_129792_()) {
                        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PlayerJumpSync(living.m_19879_(), 20));
                    } else {
                        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PlayerJumpSync(living.m_19879_(), 10));
                    }
                }
            }
        });
    }
}

