/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;

public final class SortingHandler {
    private static final Comparator<ItemStack> FALLBACK_COMPARATOR = SortingHandler.jointComparator(Comparator.comparingInt(s -> Item.m_41393_((Item)s.m_41720_())), SortingHandler::damageCompare, (s1, s2) -> s2.m_41613_() - s1.m_41613_(), (s1, s2) -> s2.hashCode() - s1.hashCode());
    private static final Comparator<ItemStack> FOOD_COMPARATOR = SortingHandler.jointComparator(SortingHandler::foodHealCompare, SortingHandler::foodSaturationCompare);
    private static final Comparator<ItemStack> TOOL_COMPARATOR = SortingHandler.jointComparator(SortingHandler::toolPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> SWORD_COMPARATOR = SortingHandler.jointComparator(SortingHandler::swordPowerCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> ARMOR_COMPARATOR = SortingHandler.jointComparator(SortingHandler::armorSlotAndToughnessCompare, SortingHandler::enchantmentCompare, SortingHandler::damageCompare);
    private static final Comparator<ItemStack> BOW_COMPARATOR = SortingHandler.jointComparator(SortingHandler::enchantmentCompare, SortingHandler::damageCompare);

    public static void sortInventory(Player player) {
        AbstractContainerMenu c = player.f_36096_;
        for (Slot s : c.f_38839_) {
            Container inv = s.f_40218_;
            if (inv != player.m_150109_()) continue;
            InvWrapper wrapper = new InvWrapper(inv);
            SortingHandler.sortInventory((IItemHandler)wrapper, 9, 36);
            break;
        }
    }

    public static void sortInventory(IItemHandler handler, int iStart, int iEnd) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> restore = new ArrayList<ItemStack>();
        for (int i = iStart; i < iEnd; ++i) {
            ItemStack stackAt = handler.getStackInSlot(i);
            restore.add(stackAt.m_41777_());
            if (stackAt.m_41619_()) continue;
            stacks.add(stackAt.m_41777_());
        }
        SortingHandler.mergeStacks(stacks);
        SortingHandler.sortStackList(stacks);
        if (SortingHandler.setInventory(handler, stacks, iStart, iEnd) == InteractionResult.FAIL) {
            SortingHandler.setInventory(handler, restore, iStart, iEnd);
        }
    }

    private static InteractionResult setInventory(IItemHandler inventory, List<ItemStack> stacks, int iStart, int iEnd) {
        ItemStack stack;
        int j;
        int i;
        for (i = iStart; i < iEnd; ++i) {
            j = i - iStart;
            ItemStack itemStack = stack = j >= stacks.size() ? ItemStack.f_41583_ : stacks.get(j);
            if (stack.m_41619_() || inventory.isItemValid(i, stack)) continue;
            return InteractionResult.PASS;
        }
        for (i = iStart; i < iEnd; ++i) {
            j = i - iStart;
            stack = j >= stacks.size() ? ItemStack.f_41583_ : stacks.get(j);
            inventory.extractItem(i, inventory.getSlotLimit(i), false);
            if (stack.m_41619_() || inventory.insertItem(i, stack, false).m_41619_()) continue;
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public static void mergeStacks(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack set = SortingHandler.mergeStackWithOthers(list, i);
            list.set(i, set);
        }
        list.removeIf(stack -> stack.m_41619_() || stack.m_41613_() == 0);
    }

    private static ItemStack mergeStackWithOthers(List<ItemStack> list, int index) {
        ItemStack stack = list.get(index);
        if (stack.m_41619_()) {
            return stack;
        }
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stackAt;
            if (i == index || (stackAt = list.get(i)).m_41619_() || stackAt.m_41613_() >= stackAt.m_41741_() || !ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackAt) || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)stackAt)) continue;
            int setSize = stackAt.m_41613_() + stack.m_41613_();
            int carryover = Math.max(0, setSize - stackAt.m_41741_());
            stackAt.m_41764_(carryover);
            stack.m_41764_(setSize - carryover);
            if (stack.m_41613_() != stack.m_41741_()) continue;
            return stack;
        }
        return stack;
    }

    public static void sortStackList(List<ItemStack> list) {
        list.sort(SortingHandler::stackCompare);
    }

    private static int stackCompare(ItemStack stack1, ItemStack stack2) {
        ItemType type2;
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1.m_41619_()) {
            return -1;
        }
        if (stack2.m_41619_()) {
            return 1;
        }
        ItemType type1 = SortingHandler.getType(stack1);
        if (type1 == (type2 = SortingHandler.getType(stack2))) {
            return type1.comparator.compare(stack1, stack2);
        }
        return type1.ordinal() - type2.ordinal();
    }

    private static ItemType getType(ItemStack stack) {
        for (ItemType type : ItemType.values()) {
            if (!type.fitsInType(stack)) continue;
            return type;
        }
        throw new RuntimeException("Having an ItemStack that doesn't fit in any type is impossible.");
    }

    private static Predicate<ItemStack> inverseClassPredicate(Class<? extends Item> clazz) {
        return SortingHandler.classPredicate(clazz).negate();
    }

    private static Predicate<ItemStack> classPredicate(Class<? extends Item> clazz) {
        return s -> !s.m_41619_() && clazz.isInstance(s.m_41720_());
    }

    private static Predicate<ItemStack> itemPredicate(List<Item> list) {
        return s -> !s.m_41619_() && list.contains(s.m_41720_());
    }

    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> finalComparator, Comparator<ItemStack>[] otherComparators) {
        if (otherComparators == null) {
            return SortingHandler.jointComparator(finalComparator);
        }
        Comparator<ItemStack>[] resizedArray = Arrays.copyOf(otherComparators, otherComparators.length + 1);
        resizedArray[otherComparators.length] = finalComparator;
        return SortingHandler.jointComparator(resizedArray);
    }

    @SafeVarargs
    public static Comparator<ItemStack> jointComparator(Comparator<ItemStack> ... comparators) {
        return SortingHandler.jointComparatorFallback((s1, s2) -> {
            for (Comparator comparator : comparators) {
                int compare;
                if (comparator == null || (compare = comparator.compare(s1, s2)) == 0) continue;
                return compare;
            }
            return 0;
        }, FALLBACK_COMPARATOR);
    }

    private static Comparator<ItemStack> jointComparatorFallback(Comparator<ItemStack> comparator, Comparator<ItemStack> fallback) {
        return (s1, s2) -> {
            int compare = comparator.compare((ItemStack)s1, (ItemStack)s2);
            if (compare == 0) {
                return fallback == null ? 0 : fallback.compare((ItemStack)s1, (ItemStack)s2);
            }
            return compare;
        };
    }

    private static Comparator<ItemStack> listOrderComparator(List<Item> list) {
        return (stack1, stack2) -> {
            Item i1 = stack1.m_41720_();
            Item i2 = stack2.m_41720_();
            if (list.contains(i1)) {
                if (list.contains(i2)) {
                    return list.indexOf(i1) - list.indexOf(i2);
                }
                return 1;
            }
            if (list.contains(i2)) {
                return -1;
            }
            return 0;
        };
    }

    private static List<Item> list(Object ... items) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        for (Object o : items) {
            if (o == null) continue;
            if (o instanceof Item) {
                itemList.add((Item)o);
                continue;
            }
            if (o instanceof Block) {
                itemList.add(((Block)o).m_5456_());
                continue;
            }
            if (o instanceof ItemStack) {
                itemList.add(((ItemStack)o).m_41720_());
                continue;
            }
            if (!(o instanceof String)) continue;
            ForgeRegistries.ITEMS.getDelegate(new ResourceLocation((String)o)).ifPresent(item -> itemList.add((Item)item.get()));
        }
        return itemList;
    }

    private static int foodHealCompare(ItemStack stack1, ItemStack stack2) {
        return stack2.m_41720_().m_41473_().m_38744_() - stack1.m_41720_().m_41473_().m_38744_();
    }

    private static int foodSaturationCompare(ItemStack stack1, ItemStack stack2) {
        return (int)(stack2.m_41720_().m_41473_().m_38745_() * 100.0f - stack1.m_41720_().m_41473_().m_38745_() * 100.0f);
    }

    private static int enchantmentCompare(ItemStack stack1, ItemStack stack2) {
        return SortingHandler.enchantmentPower(stack2) - SortingHandler.enchantmentPower(stack1);
    }

    private static int enchantmentPower(ItemStack stack) {
        if (!stack.m_41793_()) {
            return 0;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        int total = 0;
        for (Integer i : enchantments.values()) {
            total += i.intValue();
        }
        return total;
    }

    private static int toolPowerCompare(ItemStack stack1, ItemStack stack2) {
        Tier mat1 = ((TieredItem)stack1.m_41720_()).m_43314_();
        Tier mat2 = ((TieredItem)stack2.m_41720_()).m_43314_();
        return (int)(mat2.m_6624_() * 100.0f - mat1.m_6624_() * 100.0f);
    }

    private static int swordPowerCompare(ItemStack stack1, ItemStack stack2) {
        Tier mat1 = ((SwordItem)stack1.m_41720_()).m_43314_();
        Tier mat2 = ((SwordItem)stack2.m_41720_()).m_43314_();
        return (int)(mat2.m_6631_() * 100.0f - mat1.m_6631_() * 100.0f);
    }

    private static int armorSlotAndToughnessCompare(ItemStack stack1, ItemStack stack2) {
        EquipmentSlot slot2;
        ArmorItem armor1 = (ArmorItem)stack1.m_41720_();
        ArmorItem armor2 = (ArmorItem)stack2.m_41720_();
        EquipmentSlot slot1 = armor1.m_40402_();
        if (slot1 == (slot2 = armor2.m_40402_())) {
            return armor2.m_40401_().m_7366_(armor2.m_266204_()) - armor2.m_40401_().m_7366_(armor1.m_266204_());
        }
        return slot2.m_20749_() - slot1.m_20749_();
    }

    public static int damageCompare(ItemStack stack1, ItemStack stack2) {
        return stack1.m_41773_() - stack2.m_41773_();
    }

    private static enum ItemType {
        FOOD(ItemStack::m_41614_, FOOD_COMPARATOR),
        TORCH(SortingHandler.list(Blocks.f_50081_), new Comparator[0]),
        TOOL_PICKAXE(SortingHandler.classPredicate(PickaxeItem.class), TOOL_COMPARATOR),
        TOOL_SHOVEL(SortingHandler.classPredicate(ShovelItem.class), TOOL_COMPARATOR),
        TOOL_AXE(SortingHandler.classPredicate(AxeItem.class), TOOL_COMPARATOR),
        TOOL_SWORD(SortingHandler.classPredicate(SwordItem.class), SWORD_COMPARATOR),
        TOOL_GENERIC(SortingHandler.classPredicate(TieredItem.class), TOOL_COMPARATOR),
        ARMOR(SortingHandler.classPredicate(ArmorItem.class), ARMOR_COMPARATOR),
        BOW(SortingHandler.classPredicate(BowItem.class), BOW_COMPARATOR),
        CROSSBOW(SortingHandler.classPredicate(CrossbowItem.class), BOW_COMPARATOR),
        TRIDENT(SortingHandler.classPredicate(TridentItem.class), BOW_COMPARATOR),
        ARROWS(SortingHandler.classPredicate(ArrowItem.class)),
        POTION(SortingHandler.classPredicate(PotionItem.class)),
        MINECART(SortingHandler.classPredicate(MinecartItem.class)),
        RAIL(SortingHandler.list(Blocks.f_50156_, Blocks.f_50030_, Blocks.f_50031_, Blocks.f_50285_), new Comparator[0]),
        DYE(SortingHandler.classPredicate(DyeItem.class)),
        ANY(SortingHandler.inverseClassPredicate(BlockItem.class)),
        BLOCK(SortingHandler.classPredicate(BlockItem.class));

        private final Predicate<ItemStack> predicate;
        private final Comparator<ItemStack> comparator;

        @SafeVarargs
        private ItemType(List<Item> list, Comparator<ItemStack> ... comparators) {
            this(SortingHandler.itemPredicate(list), SortingHandler.jointComparator(SortingHandler.listOrderComparator(list), comparators));
        }

        private ItemType(Predicate<ItemStack> predicate, Comparator<ItemStack> comparator) {
            this.predicate = predicate;
            this.comparator = comparator;
        }

        private ItemType(Predicate<ItemStack> predicate) {
            this(predicate, FALLBACK_COMPARATOR);
        }

        public boolean fitsInType(ItemStack stack) {
            return this.predicate.test(stack);
        }
    }
}

