/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.client.particles.DSParticles;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.SourceOfMagicBlock;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncMagicSourceStatus;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicPlaceholder;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.SourceOfMagicTileEntity;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class SourceOfMagicHandler {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == LogicalSide.CLIENT) {
            return;
        }
        Player player = event.player;
        if (DragonUtils.isDragon((Entity)player)) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            if (handler.getMagicData().onMagicSource) {
                BlockEntity sourceOfMagic;
                if (!(player.m_146900_().m_60734_() instanceof SourceOfMagicBlock) || handler.getMovementData().bite || player.m_6047_() && handler.getMagicData().magicSourceTimer > 40) {
                    handler.getMagicData().onMagicSource = false;
                    handler.getMagicData().magicSourceTimer = 0;
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncMagicSourceStatus(player.m_19879_(), false, 0));
                    return;
                }
                BlockPos pos1 = player.m_20183_();
                BlockEntity blockEntity = player.m_9236_().m_7702_(pos1);
                if (blockEntity instanceof SourceOfMagicPlaceholder) {
                    pos1 = ((SourceOfMagicPlaceholder)blockEntity).rootPos;
                }
                if ((sourceOfMagic = player.m_9236_().m_7702_(pos1)) instanceof SourceOfMagicTileEntity) {
                    SourceOfMagicTileEntity tile = (SourceOfMagicTileEntity)sourceOfMagic;
                    if (!tile.m_7983_()) {
                        BlockState pState = sourceOfMagic.m_58900_();
                        if (!SourceOfMagicBlock.shouldHarmPlayer(pState, (Entity)player) || player.m_7500_() || ServerConfig.canUseAllSourcesOfMagic.booleanValue()) {
                            if (ServerConfig.sourceOfMagicInfiniteMagic.booleanValue()) {
                                if (handler.getMagicData().magicSourceTimer >= Functions.secondsToTicks(10)) {
                                    handler.getMagicData().magicSourceTimer = 0;
                                    MobEffect effect = DragonEffects.SOURCE_OF_MAGIC;
                                    MobEffectInstance effectInstance = player.m_21124_(effect);
                                    int duration = SourceOfMagicTileEntity.consumables.get(tile.m_8020_(0).m_41720_());
                                    if (effectInstance == null) {
                                        player.m_7292_(new MobEffectInstance(effect, duration));
                                    } else {
                                        player.m_7292_(new MobEffectInstance(effect, effectInstance.m_19557_() + duration));
                                    }
                                    tile.m_7407_(0, 1);
                                } else {
                                    ++handler.getMagicData().magicSourceTimer;
                                }
                            }
                        } else if (ServerConfig.damageWrongSourceOfMagic.booleanValue() && player.f_19797_ % Functions.secondsToTicks(5) == 0) {
                            player.m_6469_(player.m_269291_().m_269425_(), 1.0f);
                        }
                    } else {
                        handler.getMagicData().magicSourceTimer = 0;
                        handler.getMagicData().onMagicSource = false;
                        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncMagicSourceStatus(player.m_19879_(), false, 0));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerParticles(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.side == LogicalSide.SERVER) {
            return;
        }
        Player player = event.player;
        if (DragonUtils.isDragon((Entity)player)) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            if (handler.getMagicData().onMagicSource) {
                BlockState pState;
                SourceOfMagicTileEntity tile;
                BlockEntity sourceOfMagic;
                BlockPos pos1 = player.m_20183_();
                BlockEntity blockEntity = player.m_9236_().m_7702_(pos1);
                if (blockEntity instanceof SourceOfMagicPlaceholder) {
                    pos1 = ((SourceOfMagicPlaceholder)blockEntity).rootPos;
                }
                if ((sourceOfMagic = player.m_9236_().m_7702_(pos1)) instanceof SourceOfMagicTileEntity && !(tile = (SourceOfMagicTileEntity)sourceOfMagic).m_7983_() && (!SourceOfMagicBlock.shouldHarmPlayer(pState = sourceOfMagic.m_58900_(), (Entity)player) || player.m_7500_() || ServerConfig.canUseAllSourcesOfMagic.booleanValue()) && ServerConfig.sourceOfMagicInfiniteMagic.booleanValue() && player.m_9236_().m_5776_()) {
                    Minecraft minecraft = Minecraft.m_91087_();
                    RandomSource random = player.m_217043_();
                    double x = -1.0 + random.m_188500_() * 2.0;
                    double z = -1.0 + random.m_188500_() * 2.0;
                    if (pState.m_60734_() == DSBlocks.seaSourceOfMagic || pState.m_60734_() == DSBlocks.forestSourceOfMagic) {
                        if (!minecraft.m_91104_()) {
                            player.m_9236_().m_7106_((ParticleOptions)DSParticles.magicBeaconParticle, player.m_20185_() + x, player.m_20186_() + 0.5, player.m_20189_() + z, 0.0, 0.0, 0.0);
                        }
                    } else if (pState.m_60734_() == DSBlocks.caveSourceOfMagic && !minecraft.m_91104_()) {
                        player.m_9236_().m_7106_((ParticleOptions)DSParticles.fireBeaconParticle, player.m_20185_() + x, player.m_20186_() + 0.5, player.m_20189_() + z, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void playerTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (DragonUtils.isDragon((Entity)player)) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            if (handler.getMagicData().onMagicSource) {
                Vec3 velocity = player.m_20184_();
                float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
                if ((double)Math.abs(groundSpeed) > 0.05) {
                    NetworkHandler.CHANNEL.sendToServer((Object)new SyncMagicSourceStatus(player.m_19879_(), false, 0));
                }
            }
        }
    }

    @SubscribeEvent
    public static void playerAttacked(LivingHurtEvent event) {
        Player player;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && !(player = (Player)entity).m_9236_().m_5776_()) {
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                if (cap.getMagicData().onMagicSource) {
                    cap.getMagicData().onMagicSource = false;
                    cap.getMagicData().magicSourceTimer = 0;
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncMagicSourceStatus(player.m_19879_(), false, 0));
                }
            });
        }
    }
}

