/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.VillageRelationShips;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.DragonHunter;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.KnightEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.PrinceHorseEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.PrincesHorseEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.goals.FollowMobGoal;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import by.dragonsurvivalteam.dragonsurvival.util.SpawningUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VillagerRelationsHandler {
    public static List<Supplier<EntityType<? extends PathfinderMob>>> dragonHunters;
    private static int timeLeft;

    @SubscribeEvent
    public static void onDeath(LivingDeathEvent deathEvent) {
        LivingEntity livingEntity = deathEvent.getEntity();
        Entity killer = deathEvent.getSource().m_7639_();
        if (killer instanceof Player) {
            Player playerEntity = (Player)killer;
            if (livingEntity instanceof AbstractVillager) {
                Level world = killer.m_9236_();
                if (!(livingEntity instanceof PrincesHorseEntity) && DragonUtils.isDragon(killer)) {
                    AbstractVillager villagerEntity = (AbstractVillager)livingEntity;
                    MerchantOffers merchantOffers = villagerEntity.m_6616_();
                    if (villagerEntity instanceof Villager) {
                        Villager villager = (Villager)villagerEntity;
                        int level = villager.m_7141_().m_35576_();
                        if (world.f_46441_.m_188503_(100) < 30) {
                            Optional offer = merchantOffers.stream().filter(merchantOffer -> merchantOffer.m_45368_().m_41720_() != Items.f_42616_).toList().stream().findAny();
                            offer.ifPresent(merchantOffer -> world.m_7967_((Entity)new ItemEntity(world, villager.m_20185_(), villager.m_20186_(), villager.m_20189_(), merchantOffer.m_45368_())));
                        }
                        if (!world.m_5776_()) {
                            playerEntity.m_6756_(level * ServerConfig.xpGain);
                        }
                    } else if (villagerEntity instanceof WanderingTrader) {
                        WanderingTrader wanderingTrader = (WanderingTrader)villagerEntity;
                        if (!world.m_5776_()) {
                            playerEntity.m_6756_(2 * ServerConfig.xpGain);
                            if (world.f_46441_.m_188503_(100) < 30) {
                                ItemStack itemStack = wanderingTrader.m_6616_().stream().filter(merchantOffer -> merchantOffer.m_45368_().m_41720_() != Items.f_42616_).toList().get(wanderingTrader.m_217043_().m_188503_(wanderingTrader.m_6616_().size())).m_45368_();
                                world.m_7967_((Entity)new ItemEntity(world, wanderingTrader.m_20185_(), wanderingTrader.m_20186_(), wanderingTrader.m_20189_(), itemStack));
                            }
                        }
                    }
                }
            }
            String typeName = ResourceHelper.getKey((Entity)livingEntity).toString();
            if (DragonUtils.isDragon((Entity)playerEntity) && ServerConfig.royalChaseStatusGivers.contains(typeName)) {
                VillagerRelationsHandler.applyEvilMarker(playerEntity);
            }
        }
    }

    public static void applyEvilMarker(Player playerEntity) {
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                MobEffectInstance effectInstance = playerEntity.m_21124_(DragonEffects.ROYAL_CHASE);
                if (effectInstance == null) {
                    playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(1)));
                } else {
                    int duration = effectInstance.m_19557_();
                    if (duration <= Functions.minutesToTicks(1)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(5), 1));
                    } else if (duration <= Functions.minutesToTicks(5)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(10), 2));
                    } else if (duration <= Functions.minutesToTicks(10)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(15), 3));
                    } else if (duration <= Functions.minutesToTicks(15)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(20), 4));
                    } else if (duration <= Functions.minutesToTicks(20)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(25), 5));
                    } else if (duration <= Functions.minutesToTicks(25)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(30), 6));
                    } else if (duration <= Functions.minutesToTicks(30)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(60), 7));
                    } else if (duration <= Functions.minutesToTicks(60)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(120), 8));
                    } else if (duration <= Functions.minutesToTicks(120)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(240), 9));
                    } else if (duration <= Functions.minutesToTicks(240)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(400), 10));
                    } else if (duration <= Functions.minutesToTicks(400)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(600), 11));
                    } else if (duration <= Functions.minutesToTicks(600)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(800), 12));
                    } else if (duration <= Functions.minutesToTicks(800)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(1000), 13));
                    } else if (duration <= Functions.minutesToTicks(1000)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(1200), 14));
                    } else if (duration <= Functions.minutesToTicks(1200)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(1500), 15));
                    } else if (duration <= Functions.minutesToTicks(1500)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(2000), 16));
                    } else if (duration <= Functions.minutesToTicks(2000)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(3000), 17));
                    } else if (duration <= Functions.minutesToTicks(3000)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(4000), 18));
                    } else if (duration <= Functions.minutesToTicks(4000)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(5000), 19));
                    } else if (duration <= Functions.minutesToTicks(5000)) {
                        playerEntity.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.minutesToTicks(6000), 20));
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void voidEvilStatus(MobEffectEvent.Added potionAddedEvent) {
        MobEffectInstance effectInstance = potionAddedEvent.getEffectInstance();
        LivingEntity livingEntity = potionAddedEvent.getEntity();
        if (effectInstance.m_19544_() == MobEffects.f_19595_) {
            livingEntity.m_21195_(DragonEffects.ROYAL_CHASE);
        }
    }

    @SubscribeEvent
    public static void specialTasks(EntityJoinLevelEvent joinWorldEvent) {
        Level world = joinWorldEvent.getLevel();
        Entity entity = joinWorldEvent.getEntity();
        if (entity instanceof IronGolem) {
            IronGolem golemEntity = (IronGolem)entity;
            golemEntity.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)golemEntity, Player.class, 0, true, false, livingEntity -> livingEntity.m_21023_(DragonEffects.ROYAL_CHASE)));
        }
        if (entity instanceof AbstractVillager) {
            AbstractVillager abstractVillager = (AbstractVillager)entity;
            if (!(entity instanceof PrinceHorseEntity)) {
                abstractVillager.f_21345_.m_25352_(10, (Goal)new AvoidEntityGoal((PathfinderMob)abstractVillager, Player.class, livingEntity -> livingEntity.m_21023_(DragonEffects.ROYAL_CHASE), 16.0f, 1.0, 1.0, pMob -> true));
            }
        }
    }

    @SubscribeEvent
    public static void interactions(PlayerInteractEvent.EntityInteract event) {
        Player playerEntity = event.getEntity();
        Entity livingEntity = event.getTarget();
        if (livingEntity instanceof AbstractVillager && playerEntity.m_21023_(DragonEffects.ROYAL_CHASE)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void hurtEntity(LivingDamageEvent attackEntityEvent) {
        Player attacker;
        LivingEntity attacked = attackEntityEvent.getEntity();
        Player player = attacker = attackEntityEvent.getSource().m_7639_() instanceof Player ? (Player)attackEntityEvent.getSource().m_7639_() : null;
        if (attacker == null) {
            return;
        }
        if (attacked instanceof AbstractVillager || attacked instanceof DragonHunter) {
            if (attacker.m_21023_(DragonEffects.ROYAL_CHASE)) {
                int duration = attacker.m_21124_(DragonEffects.ROYAL_CHASE).m_19557_();
                int amplifier = attacker.m_21124_(DragonEffects.ROYAL_CHASE).m_19564_();
                attacker.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, duration + Functions.secondsToTicks(5), amplifier));
            } else {
                attacker.m_7292_(new MobEffectInstance(DragonEffects.ROYAL_CHASE, Functions.secondsToTicks(5)));
            }
        }
    }

    @SubscribeEvent
    public static void spawnHunters(TickEvent.PlayerTickEvent playerTickEvent) {
        Player player;
        Level level;
        if (!dragonHunters.isEmpty() && playerTickEvent.phase == TickEvent.Phase.END && (level = (player = playerTickEvent.player).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!player.m_7500_() && !player.m_5833_() && player.m_6084_() && player.m_21023_(DragonEffects.ROYAL_CHASE) && DragonUtils.isDragon((Entity)player) && serverLevel.m_46472_() == Level.f_46428_) {
                VillageRelationShips villageRelationShips = DragonUtils.getHandler((Entity)player).getVillageRelationShips();
                if (villageRelationShips.hunterSpawnDelay == 0) {
                    BlockPos spawnPosition = SpawningUtils.findRandomSpawnPosition(player, 1, 4, 14.0f);
                    if (spawnPosition != null && spawnPosition.m_123342_() >= ServerConfig.riderSpawnLowerBound && spawnPosition.m_123342_() <= ServerConfig.riderSpawnUpperBound) {
                        if (serverLevel.m_204166_(spawnPosition).m_203656_(Tags.Biomes.IS_WATER)) {
                            return;
                        }
                        int levelOfEvil = VillagerRelationsHandler.computeLevelOfEvil(player);
                        for (int i = 0; i < levelOfEvil; ++i) {
                            SpawningUtils.spawn((Mob)Objects.requireNonNull((PathfinderMob)dragonHunters.get(serverLevel.f_46441_.m_188503_(dragonHunters.size())).get().m_20615_((Level)serverLevel)), spawnPosition, serverLevel);
                        }
                        villageRelationShips.hunterSpawnDelay = serverLevel.m_8736_(player.m_20183_(), 3) ? Functions.minutesToTicks(ServerConfig.hunterSpawnDelay / 3) + Functions.minutesToTicks(serverLevel.f_46441_.m_188503_(ServerConfig.hunterSpawnDelay / 6)) : Functions.minutesToTicks(ServerConfig.hunterSpawnDelay) + Functions.minutesToTicks(serverLevel.f_46441_.m_188503_(ServerConfig.hunterSpawnDelay / 3));
                    }
                } else {
                    --villageRelationShips.hunterSpawnDelay;
                }
            }
        }
    }

    public static int computeLevelOfEvil(Player playerEntity) {
        if (DragonUtils.isDragon((Entity)playerEntity) && playerEntity.m_21023_(DragonEffects.ROYAL_CHASE)) {
            MobEffectInstance effectInstance = playerEntity.m_21124_(DragonEffects.ROYAL_CHASE);
            assert (effectInstance != null);
            int timeLeft = effectInstance.m_19557_();
            if (timeLeft >= Functions.minutesToTicks(5000)) {
                return 20;
            }
            if (timeLeft >= Functions.minutesToTicks(4000)) {
                return 19;
            }
            if (timeLeft >= Functions.minutesToTicks(3000)) {
                return 18;
            }
            if (timeLeft >= Functions.minutesToTicks(2000)) {
                return 17;
            }
            if (timeLeft >= Functions.minutesToTicks(1500)) {
                return 16;
            }
            if (timeLeft >= Functions.minutesToTicks(1200)) {
                return 15;
            }
            if (timeLeft >= Functions.minutesToTicks(1000)) {
                return 14;
            }
            if (timeLeft >= Functions.minutesToTicks(800)) {
                return 13;
            }
            if (timeLeft >= Functions.minutesToTicks(600)) {
                return 12;
            }
            if (timeLeft >= Functions.minutesToTicks(400)) {
                return 11;
            }
            if (timeLeft >= Functions.minutesToTicks(240)) {
                return 10;
            }
            if (timeLeft >= Functions.minutesToTicks(120)) {
                return 9;
            }
            if (timeLeft >= Functions.minutesToTicks(60)) {
                return 8;
            }
            if (timeLeft >= Functions.minutesToTicks(30)) {
                return 7;
            }
            if (timeLeft >= Functions.minutesToTicks(25)) {
                return 6;
            }
            if (timeLeft >= Functions.minutesToTicks(20)) {
                return 5;
            }
            if (timeLeft >= Functions.minutesToTicks(15)) {
                return 4;
            }
            if (timeLeft >= Functions.minutesToTicks(10)) {
                return 3;
            }
            if (timeLeft >= Functions.minutesToTicks(5)) {
                return 2;
            }
            if (timeLeft >= Functions.minutesToTicks(1)) {
                return 1;
            }
        }
        return 0;
    }

    @SubscribeEvent
    public static void spawnPrinceOrPrincess(TickEvent.LevelTickEvent serverTickEvent) {
        ServerLevel serverWorld;
        Level world;
        if (ServerConfig.spawnPrinceAndPrincess.booleanValue() && (world = serverTickEvent.level) instanceof ServerLevel && !(serverWorld = (ServerLevel)world).m_6907_().isEmpty() && serverWorld.m_46472_() == Level.f_46428_) {
            if (timeLeft == 0) {
                BlockPos blockPos;
                ServerPlayer player = serverWorld.m_8890_();
                if (player != null && player.m_6084_() && !player.m_7500_() && !player.m_5833_() && (blockPos = SpawningUtils.findRandomSpawnPosition((Player)player, 1, 2, 20.0f)) != null && blockPos.m_123342_() >= ServerConfig.riderSpawnLowerBound && blockPos.m_123342_() <= ServerConfig.riderSpawnUpperBound && serverWorld.m_8802_(blockPos)) {
                    if (serverWorld.m_204166_(blockPos).m_203656_(Tags.Biomes.IS_WATER)) {
                        return;
                    }
                    EntityType entityType = world.f_46441_.m_188499_() ? (EntityType)DSEntities.PRINCESS_ON_HORSE.get() : (EntityType)DSEntities.PRINCE_ON_HORSE.get();
                    PrincesHorseEntity princessEntity = (PrincesHorseEntity)entityType.m_20615_(world);
                    princessEntity.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                    princessEntity.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(player.m_20183_()), MobSpawnType.NATURAL, null, null);
                    serverWorld.m_7967_((Entity)princessEntity);
                    int knights = world.f_46441_.m_188503_(3) + 3;
                    for (int i = 0; i < knights; ++i) {
                        KnightEntity knightHunter = (KnightEntity)((EntityType)DSEntities.KNIGHT.get()).m_20615_((Level)serverWorld);
                        knightHunter.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                        knightHunter.f_21345_.m_25352_(5, new FollowMobGoal(PrincesHorseEntity.class, (Mob)knightHunter, 8));
                        knightHunter.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(player.m_20183_()), MobSpawnType.NATURAL, null, null);
                        serverWorld.m_7967_((Entity)knightHunter);
                    }
                    timeLeft = Functions.minutesToTicks(ServerConfig.royalSpawnDelay) + Functions.minutesToTicks(world.f_46441_.m_188503_(ServerConfig.royalSpawnDelay / 2));
                }
            } else {
                --timeLeft;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent playerTickEvent) {
        Player playerEntity;
        if (playerTickEvent.phase == TickEvent.Phase.END && !(playerEntity = playerTickEvent.player).m_9236_().m_5776_() && playerEntity.m_21023_(DragonEffects.ROYAL_CHASE)) {
            DragonUtils.getHandler((Entity)playerEntity).getVillageRelationShips().evilStatusDuration = playerEntity.m_21124_(DragonEffects.ROYAL_CHASE).m_19557_();
        }
    }

    static {
        timeLeft = Functions.minutesToTicks(ServerConfig.royalSpawnDelay) + Functions.minutesToTicks(ThreadLocalRandom.current().nextInt(30));
    }
}

