/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncSpinStatus;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncChatEvent;
import by.dragonsurvivalteam.dragonsurvival.network.status.RefreshDragons;
import by.dragonsurvivalteam.dragonsurvival.network.syncing.CompleteDataSync;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class WingObtainmentController {
    private static final Map<String, Integer> dragonPhrases = new HashMap<String, Integer>();
    private static final UUID enderDragonUUID = UUID.fromString("426642b9-2e88-4350-afa8-f99f75af5479");
    private static ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    @OnlyIn(value=Dist.CLIENT)
    public static void loadDragonPhrases() {
        try {
            String file;
            ArrayList<String> langs = new ArrayList<String>();
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/dragonsurvival/lang");
            if (stream == null) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((file = reader.readLine()) != null) {
                langs.add(file);
            }
            reader.close();
            Gson gson = GsonFactory.getDefault();
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            for (String langFile : langs) {
                URL resource = Thread.currentThread().getContextClassLoader().getResource("assets/dragonsurvival/lang/" + langFile);
                Map langData = (Map)gson.fromJson(new String(Files.readAllBytes(Paths.get(resource.toURI()))), type);
                int phraseCount = 0;
                for (String key : langData.keySet()) {
                    if (!key.contains("ds.endmessage")) continue;
                    ++phraseCount;
                }
                if (phraseCount <= 0) continue;
                dragonPhrases.put(langFile.replace(".json", ""), phraseCount);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void inTheEnd(PlayerEvent.PlayerChangedDimensionEvent changedDimensionEvent) {
        Player player = changedDimensionEvent.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (changedDimensionEvent.getTo() == Level.f_46430_) {
            DragonStateProvider.getCap((Entity)player2).ifPresent(dragonStateHandler -> {
                if (dragonStateHandler.isDragon() && !dragonStateHandler.getMovementData().spinLearned && ServerFlightHandler.enderDragonGrantsSpin.booleanValue()) {
                    executorService.schedule(() -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SyncChatEvent(enderDragonUUID.toString(), "ds.endmessage")), 3L, TimeUnit.SECONDS);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientMessageRecieved(SyncChatEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        if (event.signerId.equals(enderDragonUUID.toString())) {
            Vec3 centerPoint = new Vec3(0.0, 128.0, 0.0);
            List enderDragons = player.m_9236_().m_45976_(EnderDragon.class, AABB.m_165882_((Vec3)centerPoint, (double)192.0, (double)192.0, (double)192.0));
            if (enderDragons.size() == 0) {
                return;
            }
            String dragonName = "<" + ((EnderDragon)enderDragons.get(0)).m_5446_().getString() + "> ";
            if (event.chatId.equals("ds.endmessage")) {
                String language = Minecraft.m_91087_().m_91102_().m_264236_();
                int messageId = player.m_217043_().m_188503_(dragonPhrases.getOrDefault(language, dragonPhrases.getOrDefault("en_us", 1)).intValue()) + 1;
                player.m_213846_((Component)Component.m_237113_((String)dragonName).m_7220_((Component)Component.m_237110_((String)("ds.endmessage." + messageId), (Object[])new Object[]{player.m_5446_().getString()})));
            } else if (event.chatId.equals("ds.dragon.grants.wings")) {
                player.m_213846_((Component)Component.m_237115_((String)"ds.dragon.grants.wings"));
            }
        }
    }

    @SubscribeEvent
    public static void serverChatEvent(ServerChatEvent chatEvent) {
        Component message = chatEvent.getMessage();
        ServerPlayer player = chatEvent.getPlayer();
        String lowercase = message.getString().toLowerCase();
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && !dragonStateHandler.getMovementData().spinLearned && ServerFlightHandler.enderDragonGrantsSpin.booleanValue() && player.m_9236_().m_46472_() == Level.f_46430_ && !player.m_284548_().m_8857_().isEmpty() && !lowercase.isEmpty()) {
                executorService.schedule(() -> player.m_213846_((Component)Component.m_237115_((String)"ds.dragon.grants.wings")), 2L, TimeUnit.SECONDS);
                dragonStateHandler.setHasFlight(true);
                dragonStateHandler.getMovementData().spinLearned = true;
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSpinStatus(player.m_19879_(), dragonStateHandler.getMovementData().spinAttack, dragonStateHandler.getMovementData().spinCooldown, dragonStateHandler.getMovementData().spinLearned));
                NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new CompleteDataSync((Player)player));
            }
        });
    }

    @SubscribeEvent
    public static void teleportAway(LivingDamageEvent damageEvent) {
        if (!ServerConfig.endVoidTeleport.booleanValue()) {
            return;
        }
        LivingEntity living = damageEvent.getEntity();
        if (living instanceof Player) {
            DamageSource damageSource = damageEvent.getSource();
            if (living.m_9236_().m_46472_() == Level.f_46430_ && damageSource == living.m_269291_().m_269341_() && living.m_20182_().f_82480_ < -60.0) {
                DragonStateProvider.getCap((Entity)living).ifPresent(dragonStateHandler -> {
                    if (dragonStateHandler.isDragon()) {
                        living.m_5489_(living.m_20194_().m_129783_());
                        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new RefreshDragons(living.m_19879_()));
                        damageEvent.setCanceled(true);
                    }
                });
            }
        }
    }
}

