/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.ClawInventory;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncBrokenTool;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ClawToolHandler {
    @SubscribeEvent
    public static void experiencePickup(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            ItemStack repairTime;
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < ClawInventory.Slot.size(); ++i) {
                ItemStack clawStack = cap.getClawToolData().getClawsInventory().m_8020_(i);
                int mending = clawStack.getEnchantmentLevel(Enchantments.f_44962_);
                if (mending <= 0 || !clawStack.m_41768_()) continue;
                stacks.add(clawStack);
            }
            if (!stacks.isEmpty() && !(repairTime = (ItemStack)stacks.get(player.m_217043_().m_188503_(stacks.size()))).m_41619_() && repairTime.m_41768_()) {
                int i = Math.min((int)((float)event.getOrb().f_20770_ * repairTime.getXpRepairRatio()), repairTime.m_41773_());
                event.getOrb().f_20770_ -= i * 2;
                repairTime.m_41721_(repairTime.m_41773_() - i);
            }
            event.getOrb().f_20770_ = Math.max(0, event.getOrb().f_20770_);
            player.m_21315_();
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerDieEvent(LivingDropsEvent event) {
        Player player;
        LivingEntity ent = event.getEntity();
        if (ent instanceof Player && !(player = (Player)ent).m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && !ServerConfig.keepClawItems.booleanValue()) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            for (int i = 0; i < ClawInventory.Slot.size(); ++i) {
                ItemStack stack = handler.getClawToolData().getClawsInventory().m_8020_(i);
                if (stack.m_41619_()) continue;
                if (!EnchantmentHelper.m_44924_((ItemStack)stack)) {
                    event.getDrops().add(new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack));
                }
                handler.getClawToolData().getClawsInventory().m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    @SubscribeEvent
    public static void dropBlocksMinedByPaw(PlayerEvent.HarvestCheck harvestCheck) {
        if (!ServerConfig.bonuses.booleanValue() || !ServerConfig.clawsAreTools.booleanValue()) {
            return;
        }
        Player playerEntity = harvestCheck.getEntity();
        DragonStateProvider.getCap((Entity)playerEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                ItemStack stack = playerEntity.m_21205_();
                BlockState blockState = harvestCheck.getTargetBlock();
                if (ToolUtils.shouldUseDragonTools(stack) && !harvestCheck.canHarvest()) {
                    harvestCheck.setCanHarvest(dragonStateHandler.canHarvestWithPaw(blockState));
                }
            }
        });
    }

    public static ItemStack getDragonHarvestTool(Player player, BlockState state) {
        ItemStack mainStack = player.m_150109_().m_36056_();
        float newSpeed = 0.0f;
        if (!ToolUtils.shouldUseDragonTools(mainStack)) {
            return mainStack;
        }
        ItemStack harvestTool = mainStack;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        for (int i = 1; i < ClawInventory.Slot.size(); ++i) {
            ItemStack breakingItem = handler.getClawToolData().getClawsInventory().m_8020_(i);
            if (breakingItem.m_41619_() || !breakingItem.m_41735_(state)) continue;
            float tempSpeed = breakingItem.m_41691_(state);
            Item item = breakingItem.m_41720_();
            if (item instanceof DiggerItem) {
                DiggerItem item2 = (DiggerItem)item;
                tempSpeed = item2.m_8102_(breakingItem, state);
            }
            if (!(tempSpeed > newSpeed)) continue;
            newSpeed = tempSpeed;
            harvestTool = breakingItem;
        }
        return harvestTool;
    }

    public static Pair<ItemStack, Integer> getDragonHarvestToolAndSlot(Player player, BlockState state) {
        ItemStack mainStack = player.m_150109_().m_36056_();
        float newSpeed = 0.0f;
        if (!ToolUtils.shouldUseDragonTools(mainStack)) {
            return Pair.of((Object)mainStack, (Object)-1);
        }
        ItemStack harvestTool = mainStack;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        int toolSlot = -1;
        for (int i = 0; i < ClawInventory.Slot.size(); ++i) {
            ItemStack breakingItem = handler.getClawToolData().getClawsInventory().m_8020_(i);
            if (breakingItem.m_41619_() || !breakingItem.m_41735_(state)) continue;
            float tempSpeed = breakingItem.m_41691_(state);
            Item item = breakingItem.m_41720_();
            if (item instanceof DiggerItem) {
                DiggerItem item2 = (DiggerItem)item;
                tempSpeed = item2.m_8102_(breakingItem, state);
            }
            if (!(tempSpeed > newSpeed)) continue;
            newSpeed = tempSpeed;
            harvestTool = breakingItem;
            toolSlot = i;
        }
        return Pair.of((Object)harvestTool, (Object)toolSlot);
    }

    public static ItemStack getDragonHarvestTool(Player player) {
        ItemStack mainStack = player.m_150109_().m_36056_();
        if (!ToolUtils.shouldUseDragonTools(mainStack)) {
            return mainStack;
        }
        Level world = player.m_9236_();
        BlockHitResult result = Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (result.m_6662_() != HitResult.Type.MISS) {
            BlockState state = world.m_8055_(result.m_82425_());
            return ClawToolHandler.getDragonHarvestTool(player, state);
        }
        return mainStack;
    }

    public static ItemStack getDragonSword(LivingEntity player) {
        if (!(player instanceof Player)) {
            return ItemStack.f_41583_;
        }
        ItemStack itemInHand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (!ToolUtils.shouldUseDragonTools(itemInHand)) {
            return ItemStack.f_41583_;
        }
        DragonStateHandler cap = DragonUtils.getHandler((Entity)player);
        return cap.getClawToolData().getClawsInventory().m_8020_(0);
    }

    @SubscribeEvent
    public static void onToolBreak(PlayerDestroyItemEvent event) {
        if (event.getHand() == null) {
            return;
        }
        Player player = event.getEntity();
        if (DragonUtils.isDragon((Entity)player)) {
            ItemStack clawTool = ClawToolHandler.getDragonHarvestTool(player);
            if (ItemStack.m_41728_((ItemStack)clawTool, (ItemStack)event.getOriginal())) {
                player.m_21190_(event.getHand());
            } else if (!player.m_9236_().m_5776_()) {
                DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
                if (handler.switchedTool || handler.switchedWeapon) {
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncBrokenTool(player.m_19879_(), handler.switchedTool ? handler.switchedToolSlot : ClawInventory.Slot.SWORD.ordinal()));
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class Event_busHandler {
        @SubscribeEvent
        public void modifyBreakSpeed(PlayerEvent.BreakSpeed event) {
            if (!ServerConfig.bonuses.booleanValue() || !ServerConfig.clawsAreTools.booleanValue()) {
                return;
            }
            Player player = event.getEntity();
            ItemStack mainStack = player.m_21205_();
            DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
            if (!handler.switchedTool && !ToolUtils.shouldUseDragonTools(mainStack)) {
                return;
            }
            if (!handler.isDragon()) {
                return;
            }
            BlockState state = event.getState();
            float originalSpeed = event.getOriginalSpeed();
            float bonus = 0.0f;
            float unlockedBonus = 0.0f;
            if (handler.getLevel() == DragonLevel.NEWBORN && ServerConfig.bonusUnlockedAt == DragonLevel.NEWBORN) {
                unlockedBonus = ServerConfig.bonusBreakSpeed.floatValue();
            } else if (handler.getLevel() == DragonLevel.YOUNG && ServerConfig.bonusUnlockedAt != DragonLevel.ADULT) {
                unlockedBonus = ServerConfig.bonusBreakSpeed.floatValue();
            } else if (handler.getLevel() == DragonLevel.ADULT) {
                unlockedBonus = ServerConfig.bonusBreakSpeedAdult.floatValue();
                bonus = ServerConfig.baseBreakSpeedAdult.floatValue();
            }
            for (int i = 0; i < ClawInventory.Slot.size(); ++i) {
                ItemStack clawTool = handler.getClawToolData().getClawsInventory().m_8020_(i);
                if ((!state.m_60834_() || !clawTool.m_41735_(state)) && !(clawTool.m_41691_(state) > 1.0f)) continue;
                bonus /= ServerConfig.bonusBreakSpeedReduction.floatValue();
                break;
            }
            for (TagKey<Block> tagKey : handler.getType().mineableBlocks()) {
                if (!state.m_204336_(tagKey)) continue;
                bonus = unlockedBonus;
                break;
            }
            event.setNewSpeed(event.getNewSpeed() * Math.max(1.0f, bonus));
        }
    }
}

