/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.client.particles.DSParticles;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.MagicCap;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.data.DataBlockTagProvider;
import by.dragonsurvivalteam.dragonsurvival.data.DataDamageTypeTagsProvider;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.CaveDragon.passive.BurnAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.ForestDragon.active.HunterAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.active.RevealingTheSoulAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.active.StormBreathAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.passive.SpectralImpactAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.TargetingFunctions;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class MagicHandler {
    private static final UUID DRAGON_PASSIVE_MOVEMENT_SPEED = UUID.fromString("cdc3be6e-e17d-4efa-90f4-9dd838e9b000");

    @SubscribeEvent
    public static void magicUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        AttributeInstance moveSpeed = player.m_21051_(Attributes.f_22279_);
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (moveSpeed.m_22111_(DRAGON_PASSIVE_MOVEMENT_SPEED) != null) {
                moveSpeed.m_22120_(DRAGON_PASSIVE_MOVEMENT_SPEED);
            }
            if (cap.isDragon()) {
                if (cap.getMagicData().abilities.isEmpty() || cap.getMagicData().innateDragonAbilities.isEmpty() || cap.getMagicData().activeDragonAbilities.isEmpty()) {
                    cap.getMagicData().initAbilities(cap.getType());
                }
                for (int i = 0; i < MagicCap.activeAbilitySlots; ++i) {
                    ActiveDragonAbility ability = cap.getMagicData().getAbilityFromSlot(i);
                    if (ability == null) continue;
                    ability.tickCooldown();
                }
            }
        });
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (!cap.isDragon()) {
                return;
            }
            for (DragonAbility ability : cap.getMagicData().abilities.values()) {
                ability.player = player;
            }
            if (player.m_21023_(DragonEffects.HUNTER)) {
                BlockState blockStateFeet = player.m_146900_();
                if (MagicHandler.isHunterRelevant(blockStateFeet)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 10, 0, false, false));
                }
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, 2, false, false));
            }
        });
    }

    private static boolean isHunterRelevant(BlockState blockState) {
        return blockState.m_204336_(DataBlockTagProvider.HUNTER_ABILITY_BLOCKS);
    }

    @SubscribeEvent
    public static void livingVisibility(LivingEvent.LivingVisibilityEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                if (!cap.isDragon()) {
                    return;
                }
                if (player.m_21023_(DragonEffects.HUNTER)) {
                    event.modifyVisibility(0.0);
                }
            });
        }
    }

    @SubscribeEvent
    public static void livingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        EntityStateHandler cap = DragonUtils.getEntityHandler((Entity)entity);
        if (entity.m_21023_(DragonEffects.BURN) && (entity.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) || entity.m_20071_())) {
            entity.m_21195_(DragonEffects.BURN);
        }
        if (entity.f_19797_ % 20 == 0) {
            MobEffectInstance burnEffect;
            MobEffectInstance chargedEffect;
            MobEffectInstance drainEffect = entity.m_21124_(DragonEffects.DRAIN);
            if (drainEffect != null && !DragonUtils.isDragonType((Entity)entity, (AbstractDragonType)DragonTypes.FOREST)) {
                Player player;
                Player player2 = player = cap.lastAfflicted != -1 && entity.m_9236_().m_6815_(cap.lastAfflicted) instanceof Player ? (Player)entity.m_9236_().m_6815_(cap.lastAfflicted) : null;
                if (player != null) {
                    TargetingFunctions.attackTargets((Entity)player, ent -> ent.m_6469_(DSDamageTypes.entityDamageSource(player.m_9236_(), DSDamageTypes.FOREST_DRAGON_DRAIN, (Entity)player), (float)(drainEffect.m_19564_() + 1)), new Entity[]{entity});
                } else {
                    entity.m_6469_(entity.m_269291_().m_269425_(), (float)(drainEffect.m_19564_() + 1));
                }
            }
            if ((chargedEffect = entity.m_21124_(DragonEffects.CHARGED)) != null) {
                Player player;
                Player player3 = player = cap.lastAfflicted != -1 && entity.m_9236_().m_6815_(cap.lastAfflicted) instanceof Player ? (Player)entity.m_9236_().m_6815_(cap.lastAfflicted) : null;
                if (!DragonUtils.isDragonType((Entity)entity, (AbstractDragonType)DragonTypes.SEA)) {
                    StormBreathAbility.chargedEffectSparkle(player, entity, StormBreathAbility.chargedChainRange, StormBreathAbility.chargedEffectChainCount, (double)(chargedEffect.m_19564_() + 1) * StormBreathAbility.chargedEffectDamageMultiplier);
                }
            }
            if ((burnEffect = entity.m_21124_(DragonEffects.BURN)) != null && !entity.m_5825_() && cap.lastPos != null) {
                double distance = entity.m_20238_(cap.lastPos);
                float damage = (float)(burnEffect.m_19564_() + 1) * Mth.m_14036_((float)((float)distance), (float)0.0f, (float)10.0f);
                if (damage > 0.0f) {
                    Player player;
                    if (!entity.m_6060_()) {
                        entity.m_7311_(1);
                    }
                    Player player4 = player = cap.lastAfflicted != -1 && entity.m_9236_().m_6815_(cap.lastAfflicted) instanceof Player ? (Player)entity.m_9236_().m_6815_(cap.lastAfflicted) : null;
                    if (player != null) {
                        TargetingFunctions.attackTargets((Entity)player, ent -> ent.m_6469_(DSDamageTypes.entityDamageSource(player.m_9236_(), DSDamageTypes.CAVE_DRAGON_BURN, (Entity)player), damage), new Entity[]{entity});
                    } else {
                        entity.m_6469_(entity.m_269291_().m_269549_(), damage);
                    }
                }
            }
            cap.lastPos = entity.m_20182_();
        }
    }

    @SubscribeEvent
    public static void playerStruckByLightning(EntityStruckByLightningEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                if (!cap.isDragon()) {
                    return;
                }
                if (Objects.equals(cap.getType(), DragonTypes.SEA)) {
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerDamaged(LivingDamageEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                if (!cap.isDragon()) {
                    return;
                }
                if (player.m_21023_(DragonEffects.HUNTER)) {
                    player.m_21195_(DragonEffects.HUNTER);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerHitEntity(CriticalHitEvent event) {
        Player player = event.getEntity();
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (!cap.isDragon()) {
                return;
            }
            if (player.m_21023_(DragonEffects.HUNTER)) {
                MobEffectInstance hunter = player.m_21124_(DragonEffects.HUNTER);
                player.m_21195_(DragonEffects.HUNTER);
                event.setDamageModifier(event.getDamageModifier() + (float)((double)(hunter.m_19564_() + 1) * HunterAbility.hunterDamageBonus));
                event.setResult(Event.Result.ALLOW);
            }
        });
    }

    @SubscribeEvent
    public static void livingHurt(LivingAttackEvent event) {
        Entity entity;
        if (event.getSource().m_269533_(DataDamageTypeTagsProvider.DRAGON_BREATH)) {
            return;
        }
        if (event.getEntity() != null && (entity = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                if (!handler.isDragon()) {
                    return;
                }
                if (Objects.equals(handler.getType(), DragonTypes.SEA)) {
                    boolean hit;
                    SpectralImpactAbility spectralImpact = DragonAbilities.getSelfAbility((LivingEntity)player, SpectralImpactAbility.class);
                    boolean bl = hit = player.m_217043_().m_188503_(100) <= spectralImpact.getChance();
                    if (hit) {
                        event.getEntity().m_6469_(DSDamageTypes.entityDamageSource(player.m_9236_(), DSDamageTypes.SPECTRAL_IMPACT, (Entity)player), (float)((double)event.getAmount() * 0.15));
                        double d0 = -Mth.m_14031_((float)(player.f_19857_ * ((float)Math.PI / 180)));
                        double d1 = Mth.m_14089_((float)(player.f_19857_ * ((float)Math.PI / 180)));
                        Level patt11452$temp = player.m_9236_();
                        if (patt11452$temp instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)patt11452$temp;
                            serverLevel.m_8767_((ParticleOptions)DSParticles.seaSweep, player.m_20185_() + d0, player.m_20227_(0.5), player.m_20189_() + d1, 0, d0, 0.0, d1, 0.0);
                        }
                    }
                } else if (Objects.equals(handler.getType(), DragonTypes.CAVE)) {
                    boolean hit;
                    BurnAbility burnAbility = DragonAbilities.getSelfAbility((LivingEntity)player, BurnAbility.class);
                    boolean bl = hit = player.m_217043_().m_188503_(100) < burnAbility.getChance();
                    if (hit) {
                        DragonUtils.getEntityHandler((Entity)event.getEntity()).lastAfflicted = player.m_19879_();
                        if (!player.m_9236_().m_5776_()) {
                            event.getEntity().m_7292_(new MobEffectInstance(DragonEffects.BURN, Functions.secondsToTicks(30)));
                        }
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void experienceDrop(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
                if (!cap.isDragon()) {
                    return;
                }
                double expMult = 1.0;
                AbstractDragonBody body = DragonUtils.getDragonBody((Entity)player);
                if (body != null) {
                    expMult = body.getExpMult();
                }
                if (player.m_21023_(DragonEffects.REVEALING_THE_SOUL)) {
                    int extra = (int)Math.min((double)RevealingTheSoulAbility.revealingTheSoulMaxEXP.intValue(), (double)event.getDroppedExperience() * RevealingTheSoulAbility.revealingTheSoulMultiplier);
                    event.setDroppedExperience((int)((double)(event.getDroppedExperience() + extra) * expMult));
                }
            });
        }
    }
}

