/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.handlers.magic;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.TreasureBlock;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.common.passive.MagicAbility;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncMagicStats;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ManaHandler {
    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = event.player;
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            if (cap.getMagicData().getCurrentlyCasting() != null) {
                return;
            }
            boolean goodConditions = ManaHandler.isPlayerInGoodConditions(player);
            int timeToRecover = goodConditions ? ServerConfig.favorableManaTicks : ServerConfig.normalManaTicks;
            if (player.m_21023_(DragonEffects.SOURCE_OF_MAGIC)) {
                timeToRecover = 1;
            }
            if (player.f_19797_ % Functions.secondsToTicks(timeToRecover) == 0 && cap.getMagicData().getCurrentMana() < ManaHandler.getMaxMana(player)) {
                ManaHandler.replenishMana(player, 1);
            }
        });
    }

    public static boolean isPlayerInGoodConditions(Player player) {
        if (!DragonUtils.isDragon((Entity)player)) {
            return false;
        }
        BlockState blockBelow = player.m_9236_().m_8055_(player.m_20183_().m_7495_());
        BlockState feetBlock = player.m_146900_();
        if (feetBlock.m_60734_() instanceof TreasureBlock || blockBelow.m_60734_() instanceof TreasureBlock) {
            return true;
        }
        if (player.m_21023_(DragonEffects.SOURCE_OF_MAGIC)) {
            return true;
        }
        return DragonStateProvider.getCap((Entity)player).map(cap -> {
            if (!(DragonConfigHandler.DRAGON_MANA_BLOCKS == null || !DragonConfigHandler.DRAGON_MANA_BLOCKS.containsKey(cap.getTypeName()) || !DragonConfigHandler.DRAGON_MANA_BLOCKS.get(cap.getTypeName()).contains(blockBelow.m_60734_()) && !DragonConfigHandler.DRAGON_MANA_BLOCKS.get(cap.getTypeName()).contains(feetBlock.m_60734_()) || blockBelow.m_60734_() instanceof AbstractFurnaceBlock || feetBlock.m_60734_() instanceof AbstractFurnaceBlock || blockBelow.m_60734_() instanceof AbstractCauldronBlock || feetBlock.m_60734_() instanceof AbstractCauldronBlock)) {
                return true;
            }
            return cap.getType().isInManaCondition(player, (DragonStateHandler)cap);
        }).orElse(false);
    }

    public static int getMaxMana(Player entity) {
        int mana = 1 + (ServerConfig.noEXPRequirements != false ? 9 : Math.max(0, (Math.min(50, entity.f_36078_) - 5) / 5) + (DragonAbilities.getSelfAbility((LivingEntity)entity, MagicAbility.class) != null ? DragonAbilities.getSelfAbility((LivingEntity)entity, MagicAbility.class).getMana() : 0));
        if (DragonUtils.getDragonBody((Entity)entity) != null) {
            mana = (int)((double)mana + DragonUtils.getDragonBody((Entity)entity).getManaBonus());
        }
        return Math.max(mana, 0);
    }

    public static boolean canConsumeMana(Player player, int manaCost) {
        manaCost -= ManaHandler.getCurrentMana(player);
        if (ServerConfig.consumeEXPAsMana.booleanValue()) {
            manaCost -= player.f_36079_ / 10;
        }
        return manaCost <= 0;
    }

    public static void replenishMana(Player entity, int mana) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        DragonStateProvider.getCap((Entity)entity).ifPresent(cap -> {
            cap.getMagicData().setCurrentMana(Math.min(ManaHandler.getMaxMana(entity), cap.getMagicData().getCurrentMana() + mana));
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), (Object)new SyncMagicStats(entity.m_19879_(), cap.getMagicData().getSelectedAbilitySlot(), cap.getMagicData().getCurrentMana(), cap.getMagicData().shouldRenderAbilities()));
        });
    }

    public static void consumeMana(Player entity, int mana) {
        if (entity == null || entity.m_7500_() || entity.m_21023_(DragonEffects.SOURCE_OF_MAGIC)) {
            return;
        }
        if (ServerConfig.consumeEXPAsMana.booleanValue() && entity.m_9236_().m_5776_() && ManaHandler.getCurrentMana(entity) < mana && (ManaHandler.getCurrentMana(entity) + entity.f_36079_ / 10 >= mana || entity.f_36078_ > 0)) {
            entity.m_5496_(SoundEvents.f_11871_, 0.01f, 0.01f);
        }
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        DragonStateProvider.getCap((Entity)entity).ifPresent(cap -> {
            if (ServerConfig.consumeEXPAsMana.booleanValue()) {
                if (ManaHandler.getCurrentMana(entity) < mana && (ManaHandler.getCurrentMana(entity) + entity.f_36079_ / 10 >= mana || entity.f_36078_ > 0)) {
                    int missingMana = mana - ManaHandler.getCurrentMana(entity);
                    int missingExp = missingMana * 10;
                    entity.m_6756_(-missingExp);
                    cap.getMagicData().setCurrentMana(0);
                } else {
                    cap.getMagicData().setCurrentMana(Math.max(0, cap.getMagicData().getCurrentMana() - mana));
                }
            } else {
                cap.getMagicData().setCurrentMana(Math.max(0, cap.getMagicData().getCurrentMana() - mana));
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)entity), (Object)new SyncMagicStats(entity.m_19879_(), cap.getMagicData().getSelectedAbilitySlot(), cap.getMagicData().getCurrentMana(), cap.getMagicData().shouldRenderAbilities()));
        });
    }

    public static int getCurrentMana(Player entity) {
        return DragonStateProvider.getCap((Entity)entity).map(cap -> Math.min(cap.getMagicData().getCurrentMana(), ManaHandler.getMaxMana(entity))).orElse(0);
    }
}

