/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.items;

import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ManaHandler;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DragonTreatItem
extends Item {
    public AbstractDragonType type;

    public DragonTreatItem(AbstractDragonType type, Item.Properties foodProperties) {
        super(foodProperties.m_41489_(new FoodProperties.Builder().m_38760_(1).m_38765_().m_38758_(0.4f).m_38757_().effect(() -> new MobEffectInstance(MobEffects.f_19612_, 300, 0), 1.0f).m_38767_()));
        this.type = type;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        boolean isEdible;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AbstractDragonType playerType = DragonUtils.getDragonType((Entity)player);
            if (DragonUtils.isDragonType(playerType, this.type)) {
                ManaHandler.replenishMana(player, ManaHandler.getMaxMana(player));
                player.m_7292_(new MobEffectInstance(DragonEffects.SOURCE_OF_MAGIC, Functions.minutesToTicks(1)));
            }
            isEdible = DragonFoodHandler.isEdible(stack, playerType);
        } else {
            isEdible = stack.m_41614_();
        }
        if (isEdible) {
            return livingEntity.m_5584_(level, stack);
        }
        return stack;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level level, @NotNull List<Component> components, @NotNull TooltipFlag tooltipFlag) {
        super.m_7373_(itemStack, level, components, tooltipFlag);
        components.add((Component)Component.m_237115_((String)("ds.description." + this.type.getTypeNameLowerCase() + "DragonTreat")));
    }
}

