/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.common.items.food;

import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DragonFoodItem
extends Item {
    private Supplier<MobEffectInstance>[] effects;
    private AbstractDragonType dragonType;
    private Consumer<LivingEntity> onEat;

    public DragonFoodItem(Item.Properties p_i48487_1_) {
        super(p_i48487_1_.m_41489_(DragonFoodItem.genFoodProperties(null, null)));
    }

    public DragonFoodItem(Item.Properties p_i48487_1_, Supplier<MobEffectInstance> ... effectInstances) {
        super(p_i48487_1_.m_41489_(DragonFoodItem.genFoodProperties(null, effectInstances)));
        this.effects = effectInstances;
    }

    public DragonFoodItem(Item.Properties p_i48487_1_, AbstractDragonType dragonType, Supplier<MobEffectInstance> ... effectInstances) {
        super(p_i48487_1_.m_41489_(DragonFoodItem.genFoodProperties(dragonType, effectInstances)));
        this.dragonType = dragonType;
        this.effects = effectInstances;
    }

    public DragonFoodItem(Item.Properties p_i48487_1_, AbstractDragonType dragonType, Consumer<LivingEntity> onEat, Supplier<MobEffectInstance> ... effectInstances) {
        super(p_i48487_1_.m_41489_(DragonFoodItem.genFoodProperties(dragonType, effectInstances)));
        this.dragonType = dragonType;
        this.effects = effectInstances;
        this.onEat = onEat;
    }

    public DragonFoodItem(Item.Properties p_i48487_1_, AbstractDragonType dragonType, Consumer<LivingEntity> onEat) {
        super(p_i48487_1_.m_41489_(DragonFoodItem.genFoodProperties(dragonType, null)));
        this.dragonType = dragonType;
        this.onEat = onEat;
    }

    @NotNull
    private static FoodProperties genFoodProperties(AbstractDragonType dragonType, Supplier<MobEffectInstance> ... effectInstances) {
        FoodProperties.Builder builder = new FoodProperties.Builder();
        builder.m_38760_(1);
        builder.m_38758_(0.4f);
        builder.effect(() -> new MobEffectInstance(MobEffects.f_19612_, 300, 0), 1.0f);
        if (effectInstances != null) {
            builder.m_38765_();
        }
        return builder.m_38767_();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, world, list, tooltipFlag);
        String langKey = "ds.description." + ResourceHelper.getKey(this).m_135815_();
        if (I18n.m_118936_((String)langKey)) {
            list.add((Component)Component.m_237115_((String)langKey));
        }
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        ItemStack stack = super.m_5922_(pStack, pLevel, pLivingEntity);
        if (this.onEat != null && DragonUtils.isDragon((Entity)pLivingEntity) && (this.dragonType == null || DragonUtils.isDragonType((Entity)pLivingEntity, this.dragonType))) {
            this.onEat.accept(pLivingEntity);
        }
        if (this.effects != null && this.effects.length > 0 && DragonUtils.isDragon((Entity)pLivingEntity) && (this.dragonType == null || DragonUtils.isDragonType((Entity)pLivingEntity, this.dragonType))) {
            for (Supplier<MobEffectInstance> effect : this.effects) {
                pLivingEntity.m_7292_(effect.get());
            }
        }
        return stack;
    }
}

