/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.config;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.config.ClientConfig;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigType;
import by.dragonsurvivalteam.dragonsurvival.config.obj.IgnoreConfigCheck;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.google.common.primitives.Primitives;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITagManager;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

@Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigHandler {
    public static ClientConfig CLIENT;
    public static ForgeConfigSpec clientSpec;
    public static ServerConfig SERVER;
    public static ForgeConfigSpec serverSpec;
    public static HashMap<String, Object> defaultConfigValues;
    public static HashMap<String, ConfigOption> configObjects;
    public static HashMap<String, Field> configFields;
    public static HashMap<ConfigSide, List<String>> configs;
    public static HashMap<String, ForgeConfigSpec.ConfigValue<?>> configValues;
    private static final HashMap<Class<?>, Tuple<Supplier<IForgeRegistry<?>>, Supplier<ResourceKey<? extends Registry<?>>>>> REGISTRY_HASH_MAP;

    public static void initTypes() {
        REGISTRY_HASH_MAP.put(Item.class, new Tuple(() -> ForgeRegistries.ITEMS, () -> ForgeRegistries.Keys.ITEMS));
        REGISTRY_HASH_MAP.put(Block.class, new Tuple(() -> ForgeRegistries.BLOCKS, () -> ForgeRegistries.Keys.BLOCKS));
        REGISTRY_HASH_MAP.put(EntityType.class, new Tuple(() -> ForgeRegistries.ENTITY_TYPES, () -> ForgeRegistries.Keys.ENTITY_TYPES));
        REGISTRY_HASH_MAP.put(BlockEntityType.class, new Tuple(() -> ForgeRegistries.BLOCK_ENTITY_TYPES, () -> ForgeRegistries.Keys.BLOCK_ENTITY_TYPES));
        REGISTRY_HASH_MAP.put(Biome.class, new Tuple(() -> ForgeRegistries.BIOMES, () -> ForgeRegistries.Keys.BIOMES));
        REGISTRY_HASH_MAP.put(MobEffect.class, new Tuple(() -> ForgeRegistries.MOB_EFFECTS, () -> ForgeRegistries.Keys.MOB_EFFECTS));
        REGISTRY_HASH_MAP.put(Potion.class, new Tuple(() -> ForgeRegistries.POTIONS, () -> ForgeRegistries.Keys.POTIONS));
    }

    private static List<Field> getFields() {
        ArrayList<Field> instances = new ArrayList<Field>();
        Type annotationType = Type.getType(ConfigOption.class);
        ModList.get().getAllScanData().forEach(s -> {
            List<ModFileScanData.AnnotationData> ebsTargets = s.getAnnotations().stream().filter(s1 -> s1.targetType() == ElementType.FIELD).filter(annotationData -> annotationType.equals((Object)annotationData.annotationType())).toList();
            ebsTargets.forEach(ad -> {
                Dist side;
                ModAnnotation.EnumHolder sidesValue = (ModAnnotation.EnumHolder)ad.annotationData().get("side");
                Dist dist = side = Objects.equals(sidesValue.getValue(), "CLIENT") ? Dist.CLIENT : Dist.DEDICATED_SERVER;
                if (side == FMLEnvironment.dist || side == Dist.DEDICATED_SERVER) {
                    try {
                        Class<?> c = Class.forName(ad.clazz().getClassName());
                        Field fe = c.getDeclaredField(ad.memberName());
                        instances.add(fe);
                    }
                    catch (Exception e) {
                        DragonSurvivalMod.LOGGER.error((Object)e);
                    }
                }
            });
        });
        return instances;
    }

    public static void initConfig() {
        ConfigHandler.initTypes();
        List<Field> fields = ConfigHandler.getFields();
        fields.forEach(field -> {
            if (!Modifier.isStatic(field.getModifiers())) {
                return;
            }
            ConfigOption configOption = field.getAnnotation(ConfigOption.class);
            try {
                defaultConfigValues.put(configOption.key(), field.get(null));
            }
            catch (IllegalAccessException e) {
                DragonSurvivalMod.LOGGER.error("There was a problem while trying to get the default config value of [" + ConfigHandler.createConfigPath(configOption) + "]", (Throwable)e);
            }
            configFields.put(configOption.key(), (Field)field);
            configObjects.put(configOption.key(), configOption);
            configs.computeIfAbsent(configOption.side(), key -> new ArrayList()).add(configOption.key());
        });
        if (FMLEnvironment.dist.isClient()) {
            Pair clientConfig = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
            CLIENT = (ClientConfig)clientConfig.getLeft();
            clientSpec = (ForgeConfigSpec)clientConfig.getRight();
            ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientSpec);
        }
        Pair serverConfig = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER = (ServerConfig)serverConfig.getLeft();
        serverSpec = (ForgeConfigSpec)serverConfig.getRight();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
    }

    public static void addConfigs(ForgeConfigSpec.Builder builder, ConfigSide side) {
        for (String key : configs.getOrDefault((Object)side, Collections.emptyList())) {
            String[] stringArray;
            ConfigOption configOption = configObjects.get(key);
            Field field = configFields.get(key);
            Object defaultValues = defaultConfigValues.get(configOption.key());
            if (configOption.category() != null && configOption.category().length > 0) {
                stringArray = configOption.category();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "general";
            }
            String[] categories = stringArray;
            String[] comment = configOption.comment() != null ? configOption.comment() : new String[]{};
            for (String category : categories) {
                builder.push(category);
            }
            builder.comment(comment);
            if (!configOption.localization().isBlank()) {
                builder.translation(configOption.localization());
            }
            try {
                boolean rang;
                Object tt = Primitives.isWrapperType(defaultValues.getClass()) ? Primitives.wrap(defaultValues.getClass()).cast(defaultValues) : defaultValues;
                ConfigRange range = field.isAnnotationPresent(ConfigRange.class) ? field.getAnnotation(ConfigRange.class) : null;
                boolean bl = rang = range != null;
                if (tt instanceof Integer) {
                    Integer intVal = (Integer)tt;
                    value = builder.defineInRange(configOption.key(), intVal.intValue(), rang ? (int)range.min() : Integer.MIN_VALUE, rang ? (int)range.max() : Integer.MAX_VALUE);
                    configValues.put(key, (ForgeConfigSpec.ConfigValue<?>)value);
                } else if (tt instanceof Float) {
                    Float floatVal = (Float)tt;
                    value = builder.defineInRange(configOption.key(), (double)floatVal.floatValue(), rang ? range.min() : (double)1.4E-45f, rang ? range.max() : 3.4028234663852886E38);
                    configValues.put(key, (ForgeConfigSpec.ConfigValue<?>)value);
                } else if (tt instanceof Long) {
                    Long longVal = (Long)tt;
                    value = builder.defineInRange(configOption.key(), longVal.longValue(), rang ? (long)range.min() : Long.MIN_VALUE, rang ? (long)range.max() : Long.MAX_VALUE);
                    configValues.put(key, (ForgeConfigSpec.ConfigValue<?>)value);
                } else if (tt instanceof Double) {
                    Double doubleVal = (Double)tt;
                    value = builder.defineInRange(configOption.key(), doubleVal.doubleValue(), rang ? range.min() : Double.MIN_VALUE, rang ? range.max() : Double.MAX_VALUE);
                    configValues.put(key, (ForgeConfigSpec.ConfigValue<?>)value);
                } else if (tt instanceof Boolean) {
                    Boolean boolValue = (Boolean)tt;
                    value = builder.define(configOption.key(), boolValue.booleanValue());
                    configValues.put(key, (ForgeConfigSpec.ConfigValue<?>)value);
                } else if (field.getType().isEnum()) {
                    value = builder.defineEnum(configOption.key(), (Enum)defaultValues, (Enum[])((Enum)defaultValues).getClass().getEnumConstants());
                    configValues.put(key, (ForgeConfigSpec.ConfigValue<?>)value);
                } else if (tt instanceof List) {
                    List list = (List)tt;
                    value = builder.defineList(configOption.key(), list, configValue -> field.isAnnotationPresent(IgnoreConfigCheck.class) || ConfigHandler.checkConfig(configOption, configValue));
                    configValues.put(key, (ForgeConfigSpec.ConfigValue<?>)value);
                } else {
                    value = builder.define(configOption.key(), defaultValues);
                    configValues.put(key, (ForgeConfigSpec.ConfigValue<?>)value);
                    DragonSurvivalMod.LOGGER.warn("Potential issue found for configuration: [" + configOption.key() + "]");
                }
            }
            catch (Exception e) {
                DragonSurvivalMod.LOGGER.error("Invalid configuration found: [" + configOption.key() + "]", (Throwable)e);
            }
            for (int i = 0; i < categories.length; ++i) {
                builder.pop();
            }
        }
    }

    public static boolean checkConfig(ConfigOption configOption, Object configValue) {
        return ConfigHandler.checkConfig(configOption.key(), configValue);
    }

    public static boolean checkConfig(String key, Object configValue) {
        return ConfigHandler.checkSpecific(key, configValue);
    }

    public static boolean checkSpecific(String key, Object configValue) {
        if (key.equals("caveDragon") || key.equals("forestDragon") || key.equals("seaDragon")) {
            if (configValue instanceof String) {
                String string = (String)configValue;
                String[] split = string.split(":");
                if (split.length == 2) {
                    return ResourceLocation.m_135830_((String)string);
                }
                if (split.length == 4) {
                    return ResourceLocation.m_135830_((String)(split[0] + ":" + split[1]));
                }
            }
            return false;
        }
        if (key.equals("hurtfulToCaveDragon") || key.equals("hurtfulToForestDragon") || key.equals("hurtfulToSeaDragon")) {
            String string;
            String[] split;
            if (configValue instanceof String && (split = (string = (String)configValue).split(":")).length == 3) {
                return ResourceLocation.m_135830_((String)(split[0] + ":" + split[1]));
            }
            return false;
        }
        if (key.equals("blacklistedItemsRegex")) {
            if (configValue instanceof String) {
                String string = (String)configValue;
                int length = string.split(":").length;
                return length == 2;
            }
            return false;
        }
        if (key.equals("blacklistedSlots")) {
            try {
                Integer.parseInt(String.valueOf(configValue));
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        if (key.equals("dirtTransformationBlocks") && configValue instanceof String) {
            String string = (String)configValue;
            String[] data = string.split(":");
            if (data.length == 3) {
                return ConfigHandler.isInteger(data[2]) && ResourceLocation.m_135830_((String)(data[0] + ":" + data[1]));
            }
            return false;
        }
        String string = String.valueOf(configValue);
        if (string.split(":").length == 2) {
            return ResourceLocation.m_135830_((String)string);
        }
        return false;
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(String.valueOf(string));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static Object getRelevantString(Object object) {
        if (object instanceof IForgeRegistry) {
            IForgeRegistry forgeRegistry = (IForgeRegistry)object;
            return forgeRegistry.getRegistryName().toString();
        }
        if (object instanceof Enum) {
            Enum enumValue = (Enum)object;
            return enumValue.name();
        }
        return object;
    }

    public static <T> List<T> parseResourceLocation(Class<T> type, ResourceLocation location) {
        Tuple registry = REGISTRY_HASH_MAP.getOrDefault(type, null);
        if (registry != null) {
            if (((IForgeRegistry)((Supplier)registry.m_14418_()).get()).containsKey(location)) {
                Optional optional = ((IForgeRegistry)((Supplier)registry.m_14418_()).get()).getHolder(location);
                if (optional.isPresent() && ((Holder)optional.get()).m_203633_()) {
                    return List.of(((Holder)optional.get()).m_203334_());
                }
            } else {
                TagKey tagKey = TagKey.m_203882_((ResourceKey)((ResourceKey)((Supplier)registry.m_14419_()).get()), (ResourceLocation)location);
                if (tagKey.m_207645_(((IForgeRegistry)((Supplier)registry.m_14418_()).get()).getRegistryKey())) {
                    ITagManager manager = ((IForgeRegistry)((Supplier)registry.m_14418_()).get()).tags();
                    return manager.getTag(tagKey).stream().toList();
                }
            }
        }
        return Collections.emptyList();
    }

    private static Object getRelevantValue(Field field, Object object) {
        if (object instanceof String) {
            String stringValue = (String)object;
            if (field.getType().isEnum()) {
                Class<?> cs = field.getType();
                return EnumGetMethod.ORDINAL_OR_NAME.get(object, cs);
            }
            ResourceLocation location = ResourceLocation.m_135820_((String)stringValue);
            List<?> list = ConfigHandler.parseResourceLocation(field.getType(), location);
            if (list != null) {
                if (field.getGenericType() instanceof List) {
                    return list.isEmpty() ? List.of(stringValue) : list;
                }
                return list.isEmpty() ? null : stringValue;
            }
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (field.getType().equals(Double.TYPE) || field.getType().equals(Double.class)) {
                return number.doubleValue();
            }
            if (field.getType().equals(Integer.TYPE) || field.getType().equals(Integer.class)) {
                return number.intValue();
            }
            if (field.getType().equals(Long.TYPE) || field.getType().equals(Long.class)) {
                return number.longValue();
            }
            if (field.getType().equals(Float.TYPE) || field.getType().equals(Float.class)) {
                return Float.valueOf(number.floatValue());
            }
            return number;
        }
        return object;
    }

    @SubscribeEvent
    public static void onModConfig(ModConfigEvent event) {
        ConfigHandler.onModConfig(event.getConfig().getType());
    }

    public static void onModConfig(ModConfig.Type type) {
        ConfigSide side = type == ModConfig.Type.SERVER ? ConfigSide.SERVER : ConfigSide.CLIENT;
        List<String> configList = configs.get((Object)side);
        for (String config : configList) {
            try {
                Object object;
                Field field;
                if (!configValues.containsKey(config) || !configFields.containsKey(config) || (field = configFields.get(config)) == null || (object = ConfigHandler.convertFromGeneric(field, configValues.get(config).get())) == null) continue;
                field.set(null, object);
            }
            catch (IllegalAccessException e) {
                DragonSurvivalMod.LOGGER.error("An error occured while setting the config [" + config + "]", (Throwable)e);
            }
        }
    }

    public static void updateConfigValue(String configKey, Object configValue) {
        if (configValues.containsKey(configKey)) {
            ConfigHandler.updateConfigValue(configValues.get(configKey), configValue);
        }
    }

    public static void updateConfigValue(ForgeConfigSpec.ConfigValue config, Object configValue) {
        config.set(ConfigHandler.convertToString(configValue));
        config.save();
        configValues.entrySet().stream().filter(configList -> configList.getValue() == config).findFirst().ifPresent(configList -> {
            try {
                Object object;
                Field field = configFields.get(configList.getKey());
                if (field != null && (object = ConfigHandler.convertFromGeneric(field, configValue)) != null) {
                    field.set(null, object);
                }
            }
            catch (IllegalAccessException e) {
                DragonSurvivalMod.LOGGER.error("An error occured while trying to update the config [" + config.getPath() + "] with the value [" + configValue + "]", (Throwable)e);
            }
        });
    }

    @Nullable
    private static Object convertToString(Object object) {
        ArrayList<Object> result;
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object listElement : collection) {
                list.add(ConfigHandler.getRelevantString(listElement));
            }
            result = list;
        } else {
            result = ConfigHandler.getRelevantString(object);
        }
        return result;
    }

    private static Object convertFromGeneric(Field field, Object object) throws IllegalAccessException {
        ArrayList<Object> result;
        if (field.getType().isAssignableFrom(Collection.class)) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object listValue : (Collection)object) {
                list.add(ConfigHandler.getRelevantValue(field, listValue));
            }
            result = list;
        } else {
            result = object;
        }
        return ConfigHandler.getRelevantValue(field, result);
    }

    public static <T> List<T> getResourceElements(Class<T> type, List<?> values) {
        Tuple registry = REGISTRY_HASH_MAP.getOrDefault(type, null);
        ArrayList list = new ArrayList();
        for (Object object : values) {
            if (object == null || !(object instanceof String)) continue;
            String stringValue = (String)object;
            ResourceLocation location = ResourceLocation.m_135820_((String)stringValue);
            Optional optional = ((IForgeRegistry)((Supplier)registry.m_14418_()).get()).getHolder(location);
            optional.ifPresent(holder -> list.add(holder.m_203334_()));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)((ResourceKey)((Supplier)registry.m_14419_()).get()), (ResourceLocation)location);
            if (!tagKey.m_207645_(((IForgeRegistry)((Supplier)registry.m_14418_()).get()).getRegistryKey())) continue;
            ITagManager manager = ((IForgeRegistry)((Supplier)registry.m_14418_()).get()).tags();
            list.addAll(manager.getTag(tagKey).stream().toList());
        }
        return list;
    }

    public static String createConfigPath(String[] category, String key) {
        StringBuilder path = new StringBuilder();
        for (String pathElement : category) {
            path.append(pathElement).append(".");
        }
        path.append(key);
        return path.toString();
    }

    public static String createConfigPath(ConfigOption configOption) {
        return ConfigHandler.createConfigPath(configOption.category(), configOption.key());
    }

    public static boolean isResource(ConfigOption configOption) {
        Field field = configFields.get(configOption.key());
        Class checkType = Primitives.unwrap(field.getType());
        if (field.isAnnotationPresent(ConfigType.class)) {
            ConfigType type = field.getAnnotation(ConfigType.class);
            checkType = Primitives.unwrap(type.value());
        }
        return ItemLike.class.isAssignableFrom(checkType) || checkType == Block.class || checkType == EntityType.class || checkType == MobEffect.class || checkType == Biome.class;
    }

    static {
        defaultConfigValues = new HashMap();
        configObjects = new HashMap();
        configFields = new HashMap();
        configs = new HashMap();
        configValues = new HashMap();
        REGISTRY_HASH_MAP = new HashMap();
    }
}

