/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.data;

import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonAltarBlock;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonDoor;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonPressurePlates;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.TreasureBlock;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class DataBlockStateProvider
extends BlockStateProvider {
    public DataBlockStateProvider(PackOutput output, String modId, ExistingFileHelper existingFileHelper) {
        super(output, modId, existingFileHelper);
    }

    protected void registerStatesAndModels() {
        DSBlocks.DS_BLOCKS.forEach((key, block) -> {
            if (!(block instanceof DragonDoor)) {
                if (block instanceof DragonPressurePlates) {
                    DragonPressurePlates plate = (DragonPressurePlates)((Object)block);
                    ResourceLocation texture = this.modLoc("block/" + key);
                    ModelBuilder pressurePlate = this.models().pressurePlate(key, texture);
                    ModelBuilder pressurePlateDown = this.models().pressurePlateDown(key + "_down", texture);
                    this.horizontalFacingPressurePlate(plate, (ModelFile)pressurePlateDown, (ModelFile)pressurePlate);
                } else if (block instanceof DragonAltarBlock) {
                    BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(key, "orientable")).texture("up", this.modLoc("block/" + key + "_top"))).texture("down", this.modLoc("block/" + key + "_top"))).texture("east", this.modLoc("block/" + key + "_east"))).texture("west", this.modLoc("block/" + key + "_west"))).texture("north", this.modLoc("block/" + key + "_north"))).texture("south", this.modLoc("block/" + key + "_south"))).texture("particle", this.modLoc("block/" + key + "_top"));
                    this.getVariantBuilder((Block)block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)builder).rotationY((int)((Direction)state.m_61143_((Property)DragonAltarBlock.FACING)).m_122435_()).build());
                } else if (block instanceof TreasureBlock) {
                    TreasureBlock treasureBlock = (TreasureBlock)((Object)block);
                    this.getVariantBuilder((Block)treasureBlock).forAllStatesExcept(state -> {
                        int layers = (Integer)state.m_61143_((Property)TreasureBlock.LAYERS);
                        BlockModelBuilder builder = layers != 8 ? (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(key + layers * 2, "block/snow_height" + layers * 2)).texture("particle", this.modLoc("block/" + key))).texture("texture", this.modLoc("block/" + key)) : (BlockModelBuilder)this.models().cubeAll(key, this.modLoc("block/" + key));
                        return ConfiguredModel.builder().modelFile((ModelFile)builder).build();
                    }, new Property[]{TreasureBlock.WATERLOGGED});
                }
            }
        });
    }

    public void horizontalFacingPressurePlate(DragonPressurePlates plate, ModelFile poweredModel, ModelFile unpoweredModel) {
        this.getVariantBuilder((Block)plate).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)DragonPressurePlates.f_55249_) != false ? poweredModel : unpoweredModel).rotationY(((int)((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + 180) % 360).build(), new Property[]{DragonPressurePlates.WATERLOGGED});
    }

    @NotNull
    public String m_6055_() {
        return "Dragon Survival Block states";
    }
}

