/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.data.loot;

import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DragonHeartLootModifier
extends LootModifier {
    public static final Supplier<Codec<DragonHeartLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DragonHeartLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DragonHeartLootModifier::new)));

    public DragonHeartLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    private static boolean canDropHeart(float health, float min, float max, List<String> entityList, Entity entity, boolean whiteList, boolean useList) {
        boolean meetsHealthRequirements = health >= min && health < max;
        boolean meetsListRequirements = !useList || entityList.contains(ResourceHelper.getKey(entity).toString()) == whiteList;
        return meetsHealthRequirements && meetsListRequirements;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        if (!(entity instanceof LivingEntity) || entity instanceof Player) {
            return generatedLoot;
        }
        Player player = (Player)context.m_78953_(LootContextParams.f_81456_);
        if (player != null && !DragonUtils.isDragon((Entity)player)) {
            return generatedLoot;
        }
        float health = ((LivingEntity)entity).m_21233_();
        boolean canDropWeakDragonHeart = DragonHeartLootModifier.canDropHeart(health, 14.0f, 20.0f, ServerConfig.weakDragonHeartEntityList, entity, ServerConfig.weakDragonHeartWhiteList, ServerConfig.weakDragonHeartUseList);
        boolean canDropNormalDragonHeart = DragonHeartLootModifier.canDropHeart(health, 20.0f, 50.0f, ServerConfig.dragonHeartEntityList, entity, ServerConfig.dragonHeartWhiteList, ServerConfig.dragonHeartUseList);
        boolean canDropElderDragonHeart = DragonHeartLootModifier.canDropHeart(health, 50.0f, Float.MAX_VALUE, ServerConfig.elderDragonHeartEntityList, entity, ServerConfig.elderDragonHeartWhiteList, ServerConfig.elderDragonHeartUseList);
        if (canDropWeakDragonHeart && (double)context.m_230907_().m_188503_(100) <= ServerConfig.weakDragonHeartChance * 100.0 + (double)context.getLootingModifier() * (ServerConfig.weakDragonHeartChance * 100.0 / 4.0)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)DSItems.weakDragonHeart));
        }
        if (canDropNormalDragonHeart && (double)context.m_230907_().m_188503_(100) <= ServerConfig.dragonHeartShardChance * 100.0 + (double)context.getLootingModifier() * (ServerConfig.dragonHeartShardChance * 100.0 / 4.0)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)DSItems.dragonHeartShard));
        }
        if (canDropElderDragonHeart && (double)context.m_230907_().m_188503_(100) <= ServerConfig.elderDragonHeartChance * 100.0 + (double)context.getLootingModifier() * (ServerConfig.elderDragonHeartChance * 100.0 / 4.0)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)DSItems.elderDragonHeart));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

