/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.data.loot;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DSItems;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DragonOreLootModifier
extends LootModifier {
    public static final Supplier<Codec<DragonOreLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> DragonOreLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DragonOreLootModifier::new)));
    TagKey<Block> ores = BlockTags.create((ResourceLocation)new ResourceLocation("forge", "ores"));

    public DragonOreLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity entity;
        BlockState blockState;
        if (context.m_78936_(LootContextParams.f_81461_) && (blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_)) != null && blockState.m_204336_(this.ores) && (entity = (Entity)context.m_78953_(LootContextParams.f_81455_)) instanceof Player) {
            Player player = (Player)entity;
            Vec3 breakPos = (Vec3)context.m_78953_(LootContextParams.f_81460_);
            if (breakPos != null) {
                ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
                int fortuneLevel = 0;
                int silkTouchLevel = 0;
                if (tool != null) {
                    fortuneLevel = tool.getEnchantmentLevel(Enchantments.f_44987_);
                    silkTouchLevel = tool.getEnchantmentLevel(Enchantments.f_44985_);
                }
                BlockPos blockPos = new BlockPos((int)breakPos.f_82479_, (int)breakPos.f_82480_, (int)breakPos.f_82481_);
                int expDrop = blockState.getExpDrop((LevelReader)context.m_78952_(), context.m_230907_(), blockPos, fortuneLevel, silkTouchLevel);
                if (expDrop > 0) {
                    DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
                    int fortuneRoll = 1;
                    if (fortuneLevel >= 1) {
                        fortuneRoll = context.m_230907_().m_188503_(fortuneLevel) + 1;
                    }
                    if (handler.isDragon()) {
                        if (context.m_230907_().m_188500_() < ServerConfig.dragonOreDustChance) {
                            generatedLoot.add((Object)new ItemStack((ItemLike)DSItems.elderDragonDust, fortuneRoll));
                        }
                        if (context.m_230907_().m_188500_() < ServerConfig.dragonOreBoneChance) {
                            generatedLoot.add((Object)new ItemStack((ItemLike)DSItems.elderDragonBone, fortuneRoll));
                        }
                    } else {
                        if (context.m_230907_().m_188500_() < ServerConfig.humanOreDustChance) {
                            generatedLoot.add((Object)new ItemStack((ItemLike)DSItems.elderDragonDust, fortuneRoll));
                        }
                        if (context.m_230907_().m_188500_() < ServerConfig.humanOreBoneChance) {
                            generatedLoot.add((Object)new ItemStack((ItemLike)DSItems.elderDragonBone, fortuneRoll));
                        }
                    }
                }
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

