/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.magic.common.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.BreathAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.innate.InnateDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.passive.PassiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncMagicCap;
import by.dragonsurvivalteam.dragonsurvival.util.BlockPosHelper;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public class DragonAbilities {
    public static HashMap<String, ArrayList<DragonAbility>> ABILITIES = new HashMap();
    public static HashMap<String, ArrayList<ActiveDragonAbility>> ACTIVE_ABILITIES = new HashMap();
    public static HashMap<String, ArrayList<PassiveDragonAbility>> PASSIVE_ABILITIES = new HashMap();
    public static HashMap<String, ArrayList<InnateDragonAbility>> INNATE_ABILITIES = new HashMap();
    public static HashMap<String, DragonAbility> ABILITY_LOOKUP = new HashMap();

    public static void initAbilities() {
        List<DragonAbility> abs = DragonAbilities.getInstances(RegisterDragonAbility.class, DragonAbility.class);
        for (DragonAbility ability : abs) {
            ActiveDragonAbility ab;
            if (ability == null) continue;
            ABILITY_LOOKUP.put(ability.getName(), ability);
            if (ability.getDragonType() == null) {
                for (String string : DragonTypes.getAllSubtypes()) {
                    ABILITIES.computeIfAbsent(string, s -> new ArrayList());
                    ABILITIES.get(string).add(ability);
                    if (ability instanceof InnateDragonAbility) {
                        InnateDragonAbility ab2 = (InnateDragonAbility)ability;
                        INNATE_ABILITIES.computeIfAbsent(string, s -> new ArrayList());
                        INNATE_ABILITIES.get(string).add(ab2);
                        continue;
                    }
                    if (ability instanceof PassiveDragonAbility) {
                        PassiveDragonAbility ab3 = (PassiveDragonAbility)ability;
                        PASSIVE_ABILITIES.computeIfAbsent(string, s -> new ArrayList());
                        PASSIVE_ABILITIES.get(string).add(ab3);
                        continue;
                    }
                    if (!(ability instanceof ActiveDragonAbility)) continue;
                    ab = (ActiveDragonAbility)ability;
                    ACTIVE_ABILITIES.computeIfAbsent(string, s -> new ArrayList());
                    ACTIVE_ABILITIES.get(string).add(ab);
                }
                continue;
            }
            for (AbstractDragonType abstractDragonType : DragonTypes.getSubtypesOfType(ability.getDragonType().getTypeName())) {
                if (!(ability instanceof ActiveDragonAbility)) {
                    ABILITIES.computeIfAbsent(abstractDragonType.getSubtypeName(), s -> new ArrayList());
                    ABILITIES.get(abstractDragonType.getSubtypeName()).add(ability);
                }
                if (ability instanceof InnateDragonAbility) {
                    InnateDragonAbility ab3 = (InnateDragonAbility)ability;
                    INNATE_ABILITIES.computeIfAbsent(abstractDragonType.getSubtypeName(), s -> new ArrayList());
                    INNATE_ABILITIES.get(abstractDragonType.getSubtypeName()).add(ab3);
                    continue;
                }
                if (ability instanceof PassiveDragonAbility) {
                    PassiveDragonAbility ab2 = (PassiveDragonAbility)ability;
                    PASSIVE_ABILITIES.computeIfAbsent(abstractDragonType.getSubtypeName(), s -> new ArrayList());
                    PASSIVE_ABILITIES.get(abstractDragonType.getSubtypeName()).add(ab2);
                    continue;
                }
                if (!(ability instanceof ActiveDragonAbility)) continue;
                ab = (ActiveDragonAbility)ability;
                if (ability.getDragonType().getSubtypeName() != abstractDragonType.getSubtypeName()) continue;
                ABILITIES.computeIfAbsent(abstractDragonType.getSubtypeName(), s -> new ArrayList());
                ABILITIES.get(abstractDragonType.getSubtypeName()).add(ability);
                ACTIVE_ABILITIES.computeIfAbsent(abstractDragonType.getSubtypeName(), s -> new ArrayList());
                ACTIVE_ABILITIES.get(abstractDragonType.getSubtypeName()).add(ab);
            }
        }
        ABILITIES.forEach((key, value) -> value.sort(Comparator.comparingInt(DragonAbility::getSortOrder)));
        INNATE_ABILITIES.forEach((key, value) -> value.sort(Comparator.comparingInt(DragonAbility::getSortOrder)));
        PASSIVE_ABILITIES.forEach((key, value) -> value.sort(Comparator.comparingInt(DragonAbility::getSortOrder)));
        ACTIVE_ABILITIES.forEach((key, value) -> value.sort(Comparator.comparingInt(DragonAbility::getSortOrder)));
    }

    private static <T> List<T> getInstances(Class<?> annotationClass, Class<T> instanceClass) {
        Type annotationType = Type.getType(annotationClass);
        List allScanData = ModList.get().getAllScanData();
        LinkedHashSet<String> pluginClassNames = new LinkedHashSet<String>();
        for (ModFileScanData scanData : allScanData) {
            Set annotations = scanData.getAnnotations();
            for (ModFileScanData.AnnotationData a : annotations) {
                if (!Objects.equals(a.annotationType(), annotationType)) continue;
                String memberName = a.memberName();
                pluginClassNames.add(memberName);
            }
        }
        ArrayList<T> instances = new ArrayList<T>();
        for (String className : pluginClassNames) {
            try {
                Class<?> asmClass = Class.forName(className);
                Class<T> asmInstanceClass = asmClass.asSubclass(instanceClass);
                Constructor<T> constructor = asmInstanceClass.getDeclaredConstructor(new Class[0]);
                T instance = constructor.newInstance(new Object[0]);
                instances.add(instance);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
        return instances;
    }

    public static void addAbility(LivingEntity player, Class<? extends DragonAbility> c) {
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        try {
            DragonAbility ability = c.newInstance();
            if (player instanceof Player) {
                Player p;
                ability.player = p = (Player)player;
            }
            handler.getMagicData().abilities.put(ability.getName(), ability);
            if (player.m_9236_().m_5776_()) {
                NetworkHandler.CHANNEL.sendToServer((Object)new SyncMagicCap(player.m_19879_(), handler.getMagicData()));
            } else {
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncMagicCap(player.m_19879_(), handler.getMagicData()));
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setAbilityLevel(LivingEntity player, Class<? extends DragonAbility> c, int level) {
        if (!DragonAbilities.hasAbility(player, c)) {
            DragonAbilities.addAbility(player, c);
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        handler.getMagicData().abilities.values().stream().filter(s -> s.getClass() == c).forEach(s -> {
            s.level = Mth.m_14045_((int)level, (int)s.getMinLevel(), (int)s.getMaxLevel());
        });
        if (player.m_9236_().m_5776_()) {
            NetworkHandler.CHANNEL.sendToServer((Object)new SyncMagicCap(player.m_19879_(), handler.getMagicData()));
        } else {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> player), (Object)new SyncMagicCap(player.m_19879_(), handler.getMagicData()));
        }
    }

    public static boolean hasAbility(LivingEntity player, Class<? extends DragonAbility> c, @Nullable AbstractDragonType type) {
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        return handler.getMagicData().abilities.values().stream().anyMatch(s -> {
            if (s.getClass() != c && !s.getClass().isAssignableFrom(c) && !c.isAssignableFrom(s.getClass())) {
                return false;
            }
            if (type == null) {
                return false;
            }
            return type.getSubtypeName() == null || type.getSubtypeName().equals(s.getDragonType().getSubtypeName());
        });
    }

    public static boolean hasAbility(LivingEntity player, Class<? extends DragonAbility> c) {
        return DragonAbilities.hasAbility(player, c, null);
    }

    public static boolean hasSelfAbility(LivingEntity player, Class<? extends DragonAbility> c) {
        AbstractDragonType dragonType = DragonUtils.getHandler((Entity)player).getType();
        if (dragonType == null) {
            return DragonAbilities.hasAbility(player, c, null);
        }
        return DragonAbilities.hasAbility(player, c, dragonType);
    }

    public static <T extends DragonAbility> T getAbility(LivingEntity player, Class<T> c, @Nullable String dragonType) {
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        Optional<DragonAbility> optionalT = handler.getMagicData().abilities.values().stream().filter(s -> {
            if (s.getClass() != c && !s.getClass().isAssignableFrom(c) && !c.isAssignableFrom(s.getClass())) {
                return false;
            }
            return dragonType == null || dragonType.equals(s.getDragonType().getTypeName());
        }).findAny();
        return (T)optionalT.orElseGet(() -> {
            if (Modifier.isAbstract(c.getModifiers())) {
                return null;
            }
            try {
                return (DragonAbility)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static <T extends DragonAbility> T getAbility(LivingEntity player, Class<T> c) {
        return DragonAbilities.getAbility(player, c, null);
    }

    public static <T extends DragonAbility> T getSelfAbility(LivingEntity player, Class<T> c) {
        AbstractDragonType dragonType = DragonUtils.getHandler((Entity)player).getType();
        if (dragonType == null) {
            return DragonAbilities.getAbility(player, c, null);
        }
        return DragonAbilities.getAbility(player, c, dragonType.getTypeName());
    }

    public static AABB calculateBreathArea(@NotNull Player player, double range) {
        return DragonAbilities.calculateBreathArea(player, DragonUtils.getHandler((Entity)player), range);
    }

    public static AABB calculateBreathArea(@NotNull Player player, DragonStateHandler handler, double range) {
        Vec3 viewVector = player.m_20154_().m_82490_(range);
        double defaultRadius = switch (handler.getLevel()) {
            default -> throw new IncompatibleClassChangeError();
            case DragonLevel.NEWBORN -> 0.3;
            case DragonLevel.YOUNG -> 0.7;
            case DragonLevel.ADULT -> 1.0;
        };
        double xOffset = DragonAbilities.getOffset(viewVector.m_7096_(), defaultRadius);
        double yOffset = Math.abs(viewVector.m_7098_());
        double zOffset = DragonAbilities.getOffset(viewVector.m_7094_(), defaultRadius);
        double xMin = player.m_20154_().m_7096_() < 0.0 ? xOffset : defaultRadius;
        double yMin = player.m_20154_().m_7098_() < 0.0 ? yOffset : 0.0;
        double zMin = player.m_20154_().m_7094_() < 0.0 ? zOffset : defaultRadius;
        Vec3 min = new Vec3(Math.abs(xMin), Math.abs(yMin), Math.abs(zMin));
        double xMax = player.m_20154_().m_7096_() > 0.0 ? xOffset : defaultRadius;
        double yMax = player.m_20154_().m_7098_() > 0.0 ? yOffset + (double)player.m_20192_() : (double)player.m_20192_();
        double zMax = player.m_20154_().m_7094_() > 0.0 ? zOffset : defaultRadius;
        Vec3 max = new Vec3(Math.abs(xMax), Math.abs(yMax), Math.abs(zMax));
        return new AABB(player.m_20182_().m_82546_(min), player.m_20182_().m_82549_(max));
    }

    private static double getOffset(double value, double defaultValue) {
        if (value < 0.0) {
            return Math.min(value, -defaultValue);
        }
        return Math.max(value, defaultValue);
    }

    public static Pair<BlockPos, Direction> breathStartPosition(Player player, BreathAbility breathAbility, int currentBreathRange) {
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 viewVector = player.m_20252_(1.0f).m_82490_((double)currentBreathRange);
        Vec3 vector3d2 = eyePosition.m_82549_(viewVector);
        BlockPos pos = null;
        BlockHitResult result = player.m_9236_().m_45547_(new ClipContext(eyePosition, vector3d2, ClipContext.Block.OUTLINE, breathAbility.clipContext(), null));
        if (result.m_6662_() == HitResult.Type.MISS) {
            pos = BlockPosHelper.get(vector3d2);
        } else if (result.m_6662_() == HitResult.Type.BLOCK) {
            pos = result.m_82425_();
        }
        return Pair.of((Object)pos, (Object)result.m_82434_());
    }
}

