/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.abilities.CaveDragon.active;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.common.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ChargeCastAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@RegisterDragonAbility
public class LavaVisionAbility
extends ChargeCastAbility {
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "lava_vision"}, key="lavaVision", comment={"Whether the lava vision ability should be enabled"})
    public static Boolean lavaVision = true;
    @ConfigRange(min=1.0, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "lava_vision"}, key="lavaVisionDuration", comment={"The duration in seconds of the lava vision effect given when the ability is used"})
    public static Double lavaVisionDuration = 100.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "lava_vision"}, key="lavaVisionCooldown", comment={"The cooldown in seconds of the lava vision ability"})
    public static Double lavaVisionCooldown = 30.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "lava_vision"}, key="lavaVisionCasttime", comment={"The cast time in seconds of the lava vision ability"})
    public static Double lavaVisionCasttime = 1.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "lava_vision"}, key="lavaVisionManaCost", comment={"The mana cost for using the lava vision ability"})
    public static Integer lavaVisionManaCost = 1;

    @Override
    public int getSortOrder() {
        return 4;
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = super.getInfo();
        components.add((Component)Component.m_237110_((String)"ds.skill.duration.seconds", (Object[])new Object[]{Functions.ticksToSeconds(this.getDuration())}));
        if (!Keybind.ABILITY4.m_90862_()) {
            String key = Keybind.ABILITY4.getKey().m_84875_().getString().toUpperCase(Locale.ROOT);
            if (key.isEmpty()) {
                key = Keybind.ABILITY4.getKey().m_84875_().getString();
            }
            components.add((Component)Component.m_237110_((String)"ds.skill.keybind", (Object[])new Object[]{key}));
        }
        return components;
    }

    @Override
    public int getManaCost() {
        return lavaVisionManaCost;
    }

    @Override
    public Integer[] getRequiredLevels() {
        return new Integer[]{0, 25, 45, 60};
    }

    @Override
    public int getSkillCooldown() {
        return Functions.secondsToTicks(lavaVisionCooldown);
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }

    @Override
    public AbilityAnimation getLoopingAnimation() {
        return new AbilityAnimation("cast_self_buff", true, false);
    }

    @Override
    public AbilityAnimation getStoppingAnimation() {
        return new AbilityAnimation("self_buff", 10.4, true, false);
    }

    public int getDuration() {
        return Functions.secondsToTicks(lavaVisionDuration);
    }

    @Override
    public String getName() {
        return "lava_vision";
    }

    @Override
    public AbstractDragonType getDragonType() {
        return DragonTypes.CAVE;
    }

    @Override
    public ResourceLocation[] getSkillTextures() {
        return new ResourceLocation[]{new ResourceLocation("dragonsurvival", "textures/skills/cave/lava_vision_0.png"), new ResourceLocation("dragonsurvival", "textures/skills/cave/lava_vision_1.png"), new ResourceLocation("dragonsurvival", "textures/skills/cave/lava_vision_2.png"), new ResourceLocation("dragonsurvival", "textures/skills/cave/lava_vision_3.png"), new ResourceLocation("dragonsurvival", "textures/skills/cave/lava_vision_4.png")};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        ArrayList<Component> list = super.getLevelUpInfo();
        list.add((Component)Component.m_237110_((String)"ds.skill.duration.seconds", (Object[])new Object[]{"+" + lavaVisionDuration}));
        return list;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getMinLevel() {
        return 0;
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || lavaVision == false;
    }

    @Override
    public int getSkillCastingTime() {
        return Functions.secondsToTicks(lavaVisionCasttime);
    }

    @Override
    public void onCasting(Player player, int currentCastTime) {
    }

    @Override
    public void castingComplete(Player player) {
        player.m_7292_(new MobEffectInstance(DragonEffects.LAVA_VISION, this.getDuration()));
        player.m_9236_().m_7785_(player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, SoundEvents.f_12497_, SoundSource.PLAYERS, 5.0f, 0.1f, false);
    }
}

