/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.abilities.CaveDragon.active;

import by.dragonsurvivalteam.dragonsurvival.client.particles.CaveDragon.LargeFireParticleData;
import by.dragonsurvivalteam.dragonsurvival.client.particles.CaveDragon.SmallFireParticleData;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.FireBreathSound;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.SoundRegistry;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigType;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.CaveDragon.passive.BurnAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.BreathAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.DistExecutor;

@RegisterDragonAbility
public class NetherBreathAbility
extends BreathAbility {
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreath", comment={"Whether the firebreath ability should be enabled"})
    public static Boolean fireBreath = true;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreathDamage", comment={"The amount of damage the firebreath ability deals. This value is multiplied by the skill level."})
    public static Double fireBreathDamage = 3.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreathInitialMana", comment={"The mana cost for starting the firebreath ability"})
    public static Integer fireBreathInitialMana = 2;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreathOvertimeMana", comment={"The mana cost of sustaining the firebreath ability"})
    public static Integer fireBreathOvertimeMana = 1;
    @ConfigRange(min=0.5, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreathManaTicks", comment={"How often in seconds, mana is consumed while using fire breath"})
    public static Double fireBreathManaTicks = 2.0;
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreathSpreadsFire", comment={"Whether the fire breath actually spreads fire when used"})
    public static Boolean fireBreathSpreadsFire = true;
    @ConfigType(value=Block.class)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreathBlockBreaks", comment={"Blocks that have a chance to be broken by fire breath. Formatting: block/modid:id"})
    public static List<String> fireBreathBlockBreaks = List.of("minecraft:impermeable", "minecraft:crops", "minecraft:flowers", "minecraft:replaceable_plants", "minecraft:cobweb");
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreathCooldown", comment={"The cooldown in seconds of the fire breath ability"})
    public static Double fireBreathCooldown = 5.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "cave_dragon", "actives", "fire_breath"}, key="fireBreathCasttime", comment={"The cast time in seconds of the fire breath ability"})
    public static Double fireBreathCasttime = 1.0;

    @Override
    public String getName() {
        return "nether_breath";
    }

    @Override
    public AbstractDragonType getDragonType() {
        return DragonTypes.CAVE;
    }

    @Override
    public ResourceLocation[] getSkillTextures() {
        return new ResourceLocation[]{new ResourceLocation("dragonsurvival", "textures/skills/cave/nether_breath_0.png"), new ResourceLocation("dragonsurvival", "textures/skills/cave/nether_breath_1.png"), new ResourceLocation("dragonsurvival", "textures/skills/cave/nether_breath_2.png"), new ResourceLocation("dragonsurvival", "textures/skills/cave/nether_breath_3.png"), new ResourceLocation("dragonsurvival", "textures/skills/cave/nether_breath_4.png")};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        ArrayList<Component> list = super.getLevelUpInfo();
        list.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{"+" + fireBreathDamage}));
        return list;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getMinLevel() {
        return 1;
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || fireBreath == false;
    }

    @Override
    public int getManaCost() {
        return fireBreathOvertimeMana;
    }

    @Override
    public Integer[] getRequiredLevels() {
        return new Integer[]{0, 10, 30, 50};
    }

    @Override
    public int getSkillCooldown() {
        return Functions.secondsToTicks(fireBreathCooldown);
    }

    @Override
    public void onBlock(BlockPos blockPosition, BlockState blockState, Direction direction) {
        if (!this.player.m_9236_().f_46443_) {
            BlockState blockAbove;
            if (fireBreathSpreadsFire.booleanValue()) {
                boolean allowPlacement;
                BlockPos firePosition = blockPosition.m_121945_(direction);
                if (FireBlock.m_49255_((Level)this.player.m_9236_(), (BlockPos)firePosition, (Direction)direction) && (allowPlacement = ForgeEventFactory.getMobGriefingEvent((Level)this.player.m_9236_(), (Entity)this.player)) && this.player.m_217043_().m_188503_(100) < 50) {
                    BlockState fireBlockState = FireBlock.m_49245_((BlockGetter)this.player.m_9236_(), (BlockPos)firePosition);
                    this.player.m_9236_().m_7731_(firePosition, fireBlockState, 11);
                    blockState.onCaughtFire(this.player.m_9236_(), blockPosition, direction, (LivingEntity)this.player);
                    if (blockState.m_60734_() == Blocks.f_50077_) {
                        this.player.m_9236_().m_7731_(blockPosition, Blocks.f_50016_.m_49966_(), 11);
                    }
                }
            }
            BurnAbility burnAbility = DragonAbilities.getSelfAbility((LivingEntity)this.player, BurnAbility.class);
            if (this.player.m_217043_().m_188503_(100) < burnAbility.level * 15 && (blockAbove = this.player.m_9236_().m_8055_(blockPosition.m_7494_())).m_60734_() == Blocks.f_50016_) {
                AreaEffectCloud entity = new AreaEffectCloud(EntityType.f_20476_, this.player.m_9236_());
                entity.m_19740_(0);
                entity.m_6034_((double)blockPosition.m_7494_().m_123341_(), (double)blockPosition.m_7494_().m_123342_(), (double)blockPosition.m_7494_().m_123343_());
                entity.m_19722_(new Potion(new MobEffectInstance[]{new MobEffectInstance(DragonEffects.BURN, Functions.secondsToTicks(10) * 4)}));
                entity.m_19734_(Functions.secondsToTicks(2));
                entity.m_19712_(1.0f);
                entity.m_19724_((ParticleOptions)new SmallFireParticleData(37.0f, false));
                entity.m_19718_((LivingEntity)this.player);
                this.player.m_9236_().m_7967_((Entity)entity);
            }
        } else {
            int i;
            for (i = 0; i < 4; ++i) {
                if (this.player.m_217043_().m_188503_(100) >= 20) continue;
                this.player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)blockPosition.m_7494_().m_123341_(), (double)blockPosition.m_7494_().m_123342_(), (double)blockPosition.m_7494_().m_123343_(), 0.0, 0.05, 0.0);
            }
            if (blockState.m_60734_() == Blocks.f_49990_) {
                for (i = 0; i < 4; ++i) {
                    if (this.player.m_217043_().m_188503_(100) >= 90) continue;
                    this.player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123774_, (double)blockPosition.m_7494_().m_123341_(), (double)blockPosition.m_7494_().m_123342_(), (double)blockPosition.m_7494_().m_123343_(), 0.0, 0.05, 0.0);
                }
            }
        }
    }

    @Override
    public void onChanneling(Player player, int castDuration) {
        super.onChanneling(player, castDuration);
        if (player.m_20071_() || player.m_9236_().m_46758_(player.m_20183_())) {
            if (player.m_9236_().m_5776_()) {
                if (player.f_19797_ % 10 == 0) {
                    player.m_5496_(SoundEvents.f_12031_, 0.25f, 1.0f);
                }
                for (int i = 0; i < 12; ++i) {
                    double xSpeed = this.speed * 1.0f * this.xComp;
                    double ySpeed = this.speed * 1.0f * this.yComp;
                    double zSpeed = this.speed * 1.0f * this.zComp;
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.dx, this.dy, this.dz, xSpeed, ySpeed, zSpeed);
                }
            }
            return;
        }
        if (player.m_9236_().m_5776_() && castDuration <= 0) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::sound);
        }
        if (player.m_9236_().m_5776_()) {
            double zSpeed;
            double ySpeed;
            double xSpeed;
            int i;
            for (i = 0; i < NetherBreathAbility.calculateNumberOfParticles(DragonUtils.getHandler((Entity)player).getSize()); ++i) {
                xSpeed = this.speed * 1.0f * this.xComp;
                ySpeed = this.speed * 1.0f * this.yComp;
                zSpeed = this.speed * 1.0f * this.zComp;
                player.m_9236_().m_7106_((ParticleOptions)new SmallFireParticleData(37.0f, true), this.dx, this.dy, this.dz, xSpeed, ySpeed, zSpeed);
            }
            for (i = 0; i < NetherBreathAbility.calculateNumberOfParticles(DragonUtils.getHandler((Entity)player).getSize()) / 2; ++i) {
                xSpeed = (double)(this.speed * this.xComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.xComp * this.xComp);
                ySpeed = (double)(this.speed * this.yComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.yComp * this.yComp);
                zSpeed = (double)(this.speed * this.zComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.zComp * this.zComp);
                player.m_9236_().m_7106_((ParticleOptions)new LargeFireParticleData(37.0f, false), this.dx, this.dy, this.dz, xSpeed, ySpeed, zSpeed);
            }
        }
        this.hitEntities();
        if (player.f_19797_ % 10 == 0) {
            this.hitBlocks();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sound() {
        Vec3 pos = this.player.m_20299_(1.0f);
        SimpleSoundInstance startingSound = new SimpleSoundInstance(SoundRegistry.fireBreathStart, SoundSource.PLAYERS, 1.0f, 1.0f, SoundInstance.m_235150_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)startingSound, 0);
        Minecraft.m_91087_().m_91106_().m_120386_(new ResourceLocation("dragonsurvival", "fire_breath_loop"), SoundSource.PLAYERS);
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)new FireBreathSound(this));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopSound() {
        if (SoundRegistry.fireBreathEnd != null) {
            Vec3 pos = this.player.m_20299_(1.0f);
            SimpleSoundInstance endSound = new SimpleSoundInstance(SoundRegistry.fireBreathEnd, SoundSource.PLAYERS, 1.0f, 1.0f, SoundInstance.m_235150_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)endSound, 0);
        }
        Minecraft.m_91087_().m_91106_().m_120386_(new ResourceLocation("dragonsurvival", "fire_breath_loop"), SoundSource.PLAYERS);
    }

    @Override
    public boolean canHitEntity(LivingEntity entity) {
        return (!(entity instanceof Player) || this.player.m_7099_((Player)entity)) && !entity.m_5825_();
    }

    @Override
    public void onEntityHit(LivingEntity entityHit) {
        if (!entityHit.m_6060_()) {
            entityHit.m_7311_(1);
        }
        super.onEntityHit(entityHit);
        if (!entityHit.m_9236_().m_5776_()) {
            BurnAbility burnAbility = DragonAbilities.getSelfAbility((LivingEntity)this.player, BurnAbility.class);
            if (entityHit.m_217043_().m_188503_(100) < burnAbility.level * 15) {
                DragonUtils.getEntityHandler((Entity)entityHit).lastAfflicted = this.player != null ? this.player.m_19879_() : -1;
                entityHit.m_7292_(new MobEffectInstance(DragonEffects.BURN, Functions.secondsToTicks(10), 0, false, true));
            }
        }
    }

    @Override
    public void onDamage(LivingEntity entity) {
        entity.m_20254_(30);
    }

    public static float getDamage(int level) {
        return (float)(fireBreathDamage * (double)level);
    }

    @Override
    public float getDamage() {
        return NetherBreathAbility.getDamage(this.getLevel());
    }

    @Override
    public int getSkillChargeTime() {
        return Functions.secondsToTicks(fireBreathCasttime);
    }

    @Override
    public int getContinuousManaCostTime() {
        return Functions.secondsToTicks(fireBreathManaTicks);
    }

    @Override
    public int getInitManaCost() {
        return fireBreathInitialMana;
    }

    @Override
    public void castComplete(Player player) {
        if (player.m_9236_().m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::stopSound);
        }
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }
}

