/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.abilities.ForestDragon.active;

import by.dragonsurvivalteam.dragonsurvival.client.particles.ForestDragon.LargePoisonParticleData;
import by.dragonsurvivalteam.dragonsurvival.client.particles.ForestDragon.SmallPoisonParticleData;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.PoisonBreathSound;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.SoundRegistry;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigType;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.BreathAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;

@RegisterDragonAbility
public class ForestBreathAbility
extends BreathAbility {
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreath", comment={"Whether the forest breath ability should be enabled"})
    public static Boolean forestBreath = true;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreathDamage", comment={"The amount of damage the forest breath ability deals. This value is multiplied by the skill level."})
    public static Double forestBreathDamage = 2.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreathCooldown", comment={"The cooldown in seconds of the forest breath ability"})
    public static Double forestBreathCooldown = 5.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreathCasttime", comment={"The casttime in seconds of the forest breath ability"})
    public static Double forestBreathCasttime = 1.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreathInitialMana", comment={"The mana cost for starting the forest breath ability"})
    public static Integer forestBreathInitialMana = 2;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreathOvertimeMana", comment={"The mana cost of sustaining the forest breath ability"})
    public static Integer forestBreathOvertimeMana = 1;
    @ConfigRange(min=0.5, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreathManaTicks", comment={"How often in seconds, mana is consumed while using forest breath"})
    public static Double forestBreathManaTicks = 2.0;
    @ConfigType(value=Block.class)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreathBlockBreaks", comment={"Blocks that have a chance to be broken by forest breath. Formatting: block/modid:id"})
    public static List<String> forestBreathBlockBreaks = List.of("minecraft:banners");
    @ConfigType(value=Block.class)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="forestBreathGrowBlacklist", comment={"Blocks that will not be grown by the forest breath. Formatting: block/modid:id"})
    public static List<String> forestBreathGrowBlacklist = List.of("minecraft:grass", "minecraft:grass_block");
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="allowDirtTransformation", comment={"Allow the forest breath to transform dirt into nature related blocks"})
    public static Boolean allowDirtTransformation = true;
    @ConfigType(value=Block.class)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "forest_breath"}, key="dirtTransformationBlocks", comment={"Blocks which dirt can be transformed into. Formatting: mod_id:block_id:chance (e.g. minecraft:podzol:7) (The chance is x out of 100)"})
    public static List<String> dirtTransformationBlocks = List.of("minecraft:moss_block:3", "minecraft:podzol:7", "minecraft:mycelium:7", "minecraft:grass_block:25");

    @Override
    public String getName() {
        return "poisonous_breath";
    }

    @Override
    public AbstractDragonType getDragonType() {
        return DragonTypes.FOREST;
    }

    @Override
    public ResourceLocation[] getSkillTextures() {
        return new ResourceLocation[]{new ResourceLocation("dragonsurvival", "textures/skills/forest/poisonous_breath_0.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/poisonous_breath_1.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/poisonous_breath_2.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/poisonous_breath_3.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/poisonous_breath_4.png")};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        ArrayList<Component> list = super.getLevelUpInfo();
        list.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{"+" + forestBreathDamage}));
        return list;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getMinLevel() {
        return 1;
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || forestBreath == false;
    }

    @Override
    public void onBlock(BlockPos blockPosition, BlockState blockState, Direction direction) {
        BonemealableBlock bonemealableBlock;
        Block block;
        Level level = this.player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (blockState.m_280296_() && this.player.m_217043_().m_188503_(100) < 30) {
            AreaEffectCloud entity = new AreaEffectCloud(EntityType.f_20476_, this.player.m_9236_());
            entity.m_19740_(0);
            entity.m_6034_((double)blockPosition.m_7494_().m_123341_(), (double)blockPosition.m_7494_().m_123342_(), (double)blockPosition.m_7494_().m_123343_());
            entity.m_19722_(new Potion(new MobEffectInstance[]{new MobEffectInstance(DragonEffects.DRAIN, Functions.secondsToTicks(10) * 4)}));
            entity.m_19734_(Functions.secondsToTicks(2));
            entity.m_19712_(1.0f);
            entity.m_19724_((ParticleOptions)new LargePoisonParticleData(37.0f, false));
            entity.m_19718_((LivingEntity)this.player);
            serverLevel.m_7967_((Entity)entity);
        }
        if (blockState.m_60734_() == Blocks.f_50250_ && this.player.m_217043_().m_188503_(100) < 10 && ((PotatoBlock)blockState.m_60734_()).m_52307_(blockState)) {
            serverLevel.m_46961_(blockPosition, false);
            serverLevel.m_7967_((Entity)new ItemEntity((Level)serverLevel, (double)blockPosition.m_123341_() + 0.5, (double)blockPosition.m_123342_(), (double)blockPosition.m_123343_() + 0.5, new ItemStack((ItemLike)Items.f_42675_)));
        }
        if (this.player.m_217043_().m_188503_(100) < 50 && (block = blockState.m_60734_()) instanceof BonemealableBlock && !DragonConfigHandler.FOREST_DRAGON_BREATH_GROW_BLACKLIST.contains(bonemealableBlock = (BonemealableBlock)block) && bonemealableBlock.m_7370_((LevelReader)serverLevel, blockPosition, blockState, false) && bonemealableBlock.m_214167_((Level)serverLevel, this.player.m_217043_(), blockPosition, blockState)) {
            for (int i = 0; i < 3; ++i) {
                if (bonemealableBlock instanceof DoublePlantBlock && !blockState.m_61138_((Property)DoublePlantBlock.f_52858_)) continue;
                bonemealableBlock.m_214148_(serverLevel, this.player.m_217043_(), blockPosition, blockState);
            }
        }
        if (allowDirtTransformation.booleanValue() && (blockState.m_60713_(Blocks.f_50493_) || blockState.m_60713_(Blocks.f_50546_)) && serverLevel.m_8055_(blockPosition.m_7494_()).m_60713_(Blocks.f_50016_)) {
            ArrayList<String> toProcess = new ArrayList<String>(dirtTransformationBlocks);
            while (!toProcess.isEmpty()) {
                ResourceLocation resourceLocation;
                int index = this.player.m_217043_().m_188503_(toProcess.size());
                String element = (String)toProcess.get(index);
                String[] data = element.split(":");
                if (this.player.m_217043_().m_188503_(100) < Integer.parseInt(data[2]) && ForgeRegistries.BLOCKS.containsKey(resourceLocation = new ResourceLocation(data[0], data[1]))) {
                    serverLevel.m_7731_(blockPosition, ((Block)ForgeRegistries.BLOCKS.getValue(resourceLocation)).m_49966_(), 3);
                    break;
                }
                toProcess.remove(index);
            }
        }
    }

    @Override
    public void onChanneling(Player player, int castDuration) {
        super.onChanneling(player, castDuration);
        if (player.m_21023_(DragonEffects.STRESS)) {
            if (player.m_9236_().m_5776_()) {
                if (player.f_19797_ % 10 == 0) {
                    player.m_5496_(SoundEvents.f_12031_, 0.25f, 1.0f);
                }
                for (int i = 0; i < 12; ++i) {
                    double xSpeed = this.speed * 1.0f * this.xComp;
                    double ySpeed = this.speed * 1.0f * this.yComp;
                    double zSpeed = this.speed * 1.0f * this.zComp;
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.dx, this.dy, this.dz, xSpeed, ySpeed, zSpeed);
                }
            }
            return;
        }
        if (player.m_9236_().m_5776_() && castDuration <= 0) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::sound);
        }
        if (player.m_9236_().m_5776_()) {
            double zSpeed;
            double ySpeed;
            double xSpeed;
            int i;
            for (i = 0; i < ForestBreathAbility.calculateNumberOfParticles(DragonUtils.getHandler((Entity)player).getSize()); ++i) {
                xSpeed = this.speed * 1.0f * this.xComp;
                ySpeed = this.speed * 1.0f * this.yComp;
                zSpeed = this.speed * 1.0f * this.zComp;
                player.m_9236_().m_7106_((ParticleOptions)new LargePoisonParticleData(37.0f, true), this.dx, this.dy, this.dz, xSpeed, ySpeed, zSpeed);
            }
            for (i = 0; i < ForestBreathAbility.calculateNumberOfParticles(DragonUtils.getHandler((Entity)player).getSize()) / 2; ++i) {
                xSpeed = (double)(this.speed * this.xComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.xComp * this.xComp);
                ySpeed = (double)(this.speed * this.yComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.yComp * this.yComp);
                zSpeed = (double)(this.speed * this.zComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.zComp * this.zComp);
                player.m_9236_().m_7106_((ParticleOptions)new SmallPoisonParticleData(37.0f, false), this.dx, this.dy, this.dz, xSpeed, ySpeed, zSpeed);
            }
        }
        this.hitEntities();
        if (player.f_19797_ % 10 == 0) {
            this.hitBlocks();
        }
    }

    @Override
    public int getManaCost() {
        return forestBreathOvertimeMana;
    }

    @Override
    public Integer[] getRequiredLevels() {
        return new Integer[]{0, 10, 30, 50};
    }

    @Override
    public int getSkillCooldown() {
        return Functions.secondsToTicks(forestBreathCooldown);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopSound() {
        if (SoundRegistry.forestBreathEnd != null) {
            Vec3 pos = this.player.m_20299_(1.0f);
            SimpleSoundInstance endSound = new SimpleSoundInstance(SoundRegistry.forestBreathEnd, SoundSource.PLAYERS, 1.0f, 1.0f, SoundInstance.m_235150_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)endSound, 0);
        }
        Minecraft.m_91087_().m_91106_().m_120386_(new ResourceLocation("dragonsurvival", "forest_breath_loop"), SoundSource.PLAYERS);
    }

    @Override
    public boolean canHitEntity(LivingEntity entity) {
        return !(entity instanceof Player) || this.player.m_7099_((Player)entity);
    }

    @Override
    public void onEntityHit(LivingEntity entityHit) {
        super.onEntityHit(entityHit);
        if (!entityHit.m_9236_().m_5776_() && entityHit.m_217043_().m_188503_(100) < 30) {
            DragonUtils.getEntityHandler((Entity)entityHit).lastAfflicted = this.player != null ? this.player.m_19879_() : -1;
            entityHit.m_7292_(new MobEffectInstance(DragonEffects.DRAIN, Functions.secondsToTicks(10), 0, false, true));
        }
    }

    @Override
    public void onDamage(LivingEntity entity) {
    }

    @Override
    public float getDamage() {
        return ForestBreathAbility.getDamage(this.getLevel());
    }

    public static float getDamage(int level) {
        return (float)(forestBreathDamage * (double)level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sound() {
        Vec3 pos = this.player.m_20299_(1.0f);
        SimpleSoundInstance startingSound = new SimpleSoundInstance(SoundRegistry.forestBreathStart, SoundSource.PLAYERS, 1.0f, 1.0f, SoundInstance.m_235150_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)startingSound, 0);
        Minecraft.m_91087_().m_91106_().m_120386_(new ResourceLocation("dragonsurvival", "forest_breath_loop"), SoundSource.PLAYERS);
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)new PoisonBreathSound(this));
    }

    @Override
    public int getSkillChargeTime() {
        return Functions.secondsToTicks(forestBreathCasttime);
    }

    @Override
    public int getContinuousManaCostTime() {
        return Functions.secondsToTicks(forestBreathManaTicks);
    }

    @Override
    public int getInitManaCost() {
        return forestBreathInitialMana;
    }

    @Override
    public void castComplete(Player player) {
        if (player.m_9236_().m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::stopSound);
        }
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }
}

