/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.abilities.ForestDragon.active;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.common.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ChargeCastAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@RegisterDragonAbility
public class HunterAbility
extends ChargeCastAbility {
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "hunter"}, key="hunter", comment={"Whether the hunter ability should be enabled"})
    public static Boolean hunter = true;
    @ConfigRange(min=1.0, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "hunter"}, key="hunterDuration", comment={"The duration in seconds of the hunter effect given when the ability is used"})
    public static Double hunterDuration = 30.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "hunter"}, key="hunterCooldown", comment={"The cooldown in seconds of the hunter ability"})
    public static Double hunterCooldown = 30.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "hunter"}, key="hunterCasttime", comment={"The cast time in seconds of the hunter ability"})
    public static Double hunterCasttime = 3.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "hunter"}, key="hunterDamageBonus", comment={"The bonus damage multiplier the hunter effect gives when invisible. This value is multiplied by the skill level."})
    public static Double hunterDamageBonus = 1.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "hunter"}, key="hunterManaCost", comment={"The mana cost for using the hunter ability"})
    public static Integer hunterManaCost = 1;

    @Override
    public int getSortOrder() {
        return 4;
    }

    @Override
    public int getSkillCastingTime() {
        return Functions.secondsToTicks(hunterCasttime);
    }

    @Override
    public void onCasting(Player player, int currentCastTime) {
    }

    @Override
    public void castingComplete(Player player) {
        player.m_7292_(new MobEffectInstance(DragonEffects.HUNTER, this.getDuration(), this.getLevel() - 1));
        player.m_9236_().m_7785_(player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, SoundEvents.f_12497_, SoundSource.PLAYERS, 5.0f, 0.1f, true);
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = super.getInfo();
        if (!Keybind.ABILITY4.m_90862_()) {
            String key = Keybind.ABILITY4.getKey().m_84875_().getString().toUpperCase(Locale.ROOT);
            if (key.isEmpty()) {
                key = Keybind.ABILITY4.getKey().m_84875_().getString();
            }
            components.add((Component)Component.m_237110_((String)"ds.skill.keybind", (Object[])new Object[]{key}));
        }
        return components;
    }

    @Override
    public int getManaCost() {
        return hunterManaCost;
    }

    @Override
    public Integer[] getRequiredLevels() {
        return new Integer[]{0, 25, 35, 55};
    }

    @Override
    public int getSkillCooldown() {
        return Functions.secondsToTicks(hunterCooldown);
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }

    @Override
    public AbilityAnimation getLoopingAnimation() {
        return new AbilityAnimation("cast_self_buff", true, false);
    }

    @Override
    public AbilityAnimation getStoppingAnimation() {
        return new AbilityAnimation("self_buff", 10.4, true, false);
    }

    public int getDuration() {
        return Functions.secondsToTicks(hunterDuration * (double)this.getLevel());
    }

    public double getDamage() {
        return hunterDamageBonus * (double)this.getLevel();
    }

    @Override
    public Component getDescription() {
        return Component.m_237110_((String)("ds.skill.description." + this.getName()), (Object[])new Object[]{"+" + hunterDamageBonus * (double)this.getLevel() + "x", this.getDuration()});
    }

    @Override
    public String getName() {
        return "hunter";
    }

    @Override
    public AbstractDragonType getDragonType() {
        return DragonTypes.FOREST;
    }

    @Override
    public ResourceLocation[] getSkillTextures() {
        return new ResourceLocation[]{new ResourceLocation("dragonsurvival", "textures/skills/forest/hunter_0.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/hunter_1.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/hunter_2.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/hunter_3.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/hunter_4.png")};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        ArrayList<Component> list = super.getLevelUpInfo();
        list.add((Component)Component.m_237110_((String)"ds.skill.duration.seconds", (Object[])new Object[]{"+" + hunterDuration}));
        list.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{"+" + hunterDamageBonus + "X"}));
        return list;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getMinLevel() {
        return 0;
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || hunter == false;
    }
}

