/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.abilities.ForestDragon.active;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.DragonSpikeEntity;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.InstantCastAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@RegisterDragonAbility
public class SpikeAbility
extends InstantCastAbility {
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "spike"}, key="spike", comment={"Whether the spike ability should be enabled"})
    public static Boolean spike = true;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "spike"}, key="spikeSpread", comment={"The amount each additional spike fired will add to its inaccuracy"})
    public static Float spikeSpread = Float.valueOf(1.0f);
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "spike"}, key="spikeMultishot", comment={"Whether the spike ability will fire an additional shot per level"})
    public static Boolean spikeMultishot = true;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "spike"}, key="spikeCooldown", comment={"The cooldown in seconds of the spike ability"})
    public static Double spikeCooldown = 3.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "spike"}, key="spikeDamage", comment={"The amount of damage the spike ability deals. This value is multiplied by the skill level."})
    public static Double spikeDamage = 2.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "forest_dragon", "actives", "spike"}, key="spikeManaCost", comment={"The mana cost for using the spike ability"})
    public static Integer spikeManaCost = 1;

    @Override
    public Component getDescription() {
        return Component.m_237110_((String)("ds.skill.description." + this.getName()), (Object[])new Object[]{Float.valueOf(this.getDamage())});
    }

    @Override
    public int getSortOrder() {
        return 2;
    }

    @Override
    public String getName() {
        return "spike";
    }

    @Override
    public AbstractDragonType getDragonType() {
        return DragonTypes.FOREST;
    }

    @Override
    public ResourceLocation[] getSkillTextures() {
        return new ResourceLocation[]{new ResourceLocation("dragonsurvival", "textures/skills/forest/spike_0.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/spike_1.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/spike_2.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/spike_3.png"), new ResourceLocation("dragonsurvival", "textures/skills/forest/spike_4.png")};
    }

    public float getDamage() {
        return (float)(spikeDamage * (double)this.getLevel());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        ArrayList<Component> list = super.getLevelUpInfo();
        list.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{"+" + spikeDamage}));
        return list;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getMinLevel() {
        return 0;
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || spike == false;
    }

    @Override
    public int getManaCost() {
        return spikeManaCost;
    }

    @Override
    public Integer[] getRequiredLevels() {
        return new Integer[]{0, 20, 30, 40};
    }

    @Override
    public int getSkillCooldown() {
        return Functions.secondsToTicks(spikeCooldown);
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = super.getInfo();
        components.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{Float.valueOf(this.getDamage())}));
        if (!Keybind.ABILITY2.m_90862_()) {
            String key = Keybind.ABILITY2.getKey().m_84875_().getString().toUpperCase(Locale.ROOT);
            if (key.isEmpty()) {
                key = Keybind.ABILITY2.getKey().m_84875_().getString();
            }
            components.add((Component)Component.m_237110_((String)"ds.skill.keybind", (Object[])new Object[]{key}));
        }
        return components;
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }

    @Override
    public void onCast(Player player) {
        Vec3 vector3d = player.m_20252_(1.0f);
        double speed = 1.0;
        double d2 = vector3d.f_82479_ * speed;
        double d3 = vector3d.f_82480_ * speed;
        double d4 = vector3d.f_82481_ * speed;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        handler.getMovementData().bite = true;
        for (int i = 0; i < this.getLevel(); ++i) {
            DragonSpikeEntity entity = new DragonSpikeEntity((EntityType<? extends AbstractArrow>)((EntityType)DSEntities.DRAGON_SPIKE.get()), player.m_9236_(), (LivingEntity)player);
            entity.m_6034_(entity.m_20185_() + d2, entity.m_20186_() + d3, entity.m_20189_() + d4);
            entity.setArrow_level(this.getLevel());
            entity.m_36781_(this.getDamage());
            entity.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            entity.m_37251_((Entity)player, player.f_19858_, player.f_19857_, 0.0f, 4.0f, (float)i * spikeSpread.floatValue());
            player.m_9236_().m_7967_((Entity)entity);
            if (!spikeMultishot.booleanValue()) break;
        }
    }
}

