/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.active;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.BallLightningEntity;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ChargeCastAbility;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@RegisterDragonAbility
public class BallLightningAbility
extends ChargeCastAbility {
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "ball_lightning"}, key="ballLightning", comment={"Whether the lightning ball ability should be enabled"})
    public static Boolean ballLightning = true;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "ball_lightning"}, key="ballLightningCooldown", comment={"The cooldown in seconds of the ball lightning ability"})
    public static Double ballLightningCooldown = 20.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "ball_lightning"}, key="ballLightningCasttime", comment={"The cast time in seconds of the ball lightning ability"})
    public static Double ballLightningCasttime = 2.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "ball_lightning"}, key="ballLightningDamage", comment={"The amount of damage the lightning ball ability deals. This value is multiplied by the skill level."})
    public static Double ballLightningDamage = 4.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "ball_lightning"}, key="ballLightningManaCost", comment={"The mana cost for using the lightning ball ability"})
    public static Integer ballLightningManaCost = 1;

    @Override
    public int getManaCost() {
        return ballLightningManaCost;
    }

    @Override
    public int getSortOrder() {
        return 2;
    }

    @Override
    public Integer[] getRequiredLevels() {
        return new Integer[]{0, 20, 45, 50};
    }

    @Override
    public int getSkillCooldown() {
        return Functions.secondsToTicks(ballLightningCooldown);
    }

    @Override
    public int getSkillCastingTime() {
        return Functions.secondsToTicks(ballLightningCasttime);
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }

    @Override
    public void onCasting(Player player, int currentCastTime) {
    }

    @Override
    public void castingComplete(Player player) {
        Vec3 vector3d = player.m_20252_(1.0f);
        double speed = 1.0;
        double d2 = vector3d.f_82479_ * speed;
        double d3 = vector3d.f_82480_ * speed;
        double d4 = vector3d.f_82481_ * speed;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        float f1 = -((float)handler.getMovementData().bodyYaw) * ((float)Math.PI / 180);
        float f4 = Mth.m_14031_((float)f1);
        float f5 = Mth.m_14089_((float)f1);
        Double size = (Double)DragonStateProvider.getCap((Entity)player).map(DragonStateHandler::getSize).get();
        double x = player.m_20185_() + (double)f4;
        double y = player.m_20186_() + size / 20.0 - 0.2;
        double z = player.m_20189_() + (double)f5;
        BallLightningEntity entity = new BallLightningEntity(player.m_9236_(), (LivingEntity)player, d2, d3, d4);
        entity.m_6034_(x + vector3d.f_82479_ * speed, y, z + vector3d.f_82481_ * speed);
        entity.setLevel(this.getLevel());
        entity.m_37251_((Entity)player, player.f_19858_, player.f_19857_, 0.0f, (float)speed, 1.0f);
        player.m_9236_().m_7967_((Entity)entity);
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = super.getInfo();
        components.add((Component)Component.m_237110_((String)"ds.skill.aoe", (Object[])new Object[]{this.getRange() + "x" + this.getRange() + "x" + this.getRange()}));
        components.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{Float.valueOf(this.getDamage())}));
        if (!Keybind.ABILITY2.m_90862_()) {
            String key = Keybind.ABILITY2.getKey().m_84875_().getString().toUpperCase(Locale.ROOT);
            if (key.isEmpty()) {
                key = Keybind.ABILITY2.getKey().m_84875_().getString();
            }
            components.add((Component)Component.m_237110_((String)"ds.skill.keybind", (Object[])new Object[]{key}));
        }
        return components;
    }

    public int getRange() {
        return 4;
    }

    public float getDamage() {
        return BallLightningAbility.getDamage(this.getLevel());
    }

    public static float getDamage(int level) {
        return (float)(ballLightningDamage * (double)level);
    }

    @Override
    public Component getDescription() {
        return Component.m_237110_((String)("ds.skill.description." + this.getName()), (Object[])new Object[]{Float.valueOf(this.getDamage())});
    }

    @Override
    public String getName() {
        return "ball_lightning";
    }

    @Override
    public AbstractDragonType getDragonType() {
        return DragonTypes.SEA;
    }

    @Override
    public ResourceLocation[] getSkillTextures() {
        return new ResourceLocation[]{new ResourceLocation("dragonsurvival", "textures/skills/sea/ball_lightning_0.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/ball_lightning_1.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/ball_lightning_2.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/ball_lightning_3.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/ball_lightning_4.png")};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        ArrayList<Component> list = super.getLevelUpInfo();
        list.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{"+" + ballLightningDamage}));
        return list;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getMinLevel() {
        return 0;
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || ballLightning == false;
    }
}

