/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.active;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.common.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ChargeCastAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@RegisterDragonAbility
public class SeaEyesAbility
extends ChargeCastAbility {
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "sea_vision"}, key="seaVision", comment={"Whether the sea vision ability should be enabled"})
    public static Boolean seaEyes = true;
    @ConfigRange(min=1.0, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "sea_vision"}, key="seaVisionDuration", comment={"The duration in seconds of the sea vision effect given when the ability is used"})
    public static Double seaEyesDuration = 100.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "sea_vision"}, key="seaVisionCooldown", comment={"The cooldown in seconds of the sea vision ability"})
    public static Double seaEyesCooldown = 60.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "sea_vision"}, key="seaEyesCasttime", comment={"The cast time in seconds of the sea vision ability"})
    public static Double seaEyesCasttime = 1.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "sea_vision"}, key="seaVisionManaCost", comment={"The mana cost for using the sea vision ability"})
    public static Integer seaEyesManaCost = 1;

    @Override
    public int getSkillCastingTime() {
        return Functions.secondsToTicks(seaEyesCasttime);
    }

    @Override
    public int getSortOrder() {
        return 4;
    }

    @Override
    public void onCasting(Player player, int currentCastTime) {
    }

    @Override
    public void castingComplete(Player player) {
        player.m_7292_(new MobEffectInstance(DragonEffects.WATER_VISION, this.getDuration()));
        player.m_9236_().m_7785_(player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, SoundEvents.f_12497_, SoundSource.PLAYERS, 5.0f, 0.1f, true);
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = super.getInfo();
        components.add((Component)Component.m_237110_((String)"ds.skill.duration.seconds", (Object[])new Object[]{Functions.ticksToSeconds(this.getDuration())}));
        if (!Keybind.ABILITY4.m_90862_()) {
            String key = Keybind.ABILITY4.getKey().m_84875_().getString().toUpperCase(Locale.ROOT);
            if (key.isEmpty()) {
                key = Keybind.ABILITY4.getKey().m_84875_().getString();
            }
            components.add((Component)Component.m_237110_((String)"ds.skill.keybind", (Object[])new Object[]{key}));
        }
        return components;
    }

    @Override
    public int getManaCost() {
        return seaEyesManaCost;
    }

    @Override
    public Integer[] getRequiredLevels() {
        return new Integer[]{0, 15, 45, 60};
    }

    @Override
    public int getSkillCooldown() {
        return Functions.secondsToTicks(seaEyesCooldown);
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }

    @Override
    public AbilityAnimation getLoopingAnimation() {
        return new AbilityAnimation("cast_self_buff", true, false);
    }

    @Override
    public AbilityAnimation getStoppingAnimation() {
        return new AbilityAnimation("self_buff", 10.4, true, false);
    }

    public int getDuration() {
        return Functions.secondsToTicks(seaEyesDuration * (double)this.getLevel());
    }

    @Override
    public Component getDescription() {
        return Component.m_237110_((String)("ds.skill.description." + this.getName()), (Object[])new Object[]{Functions.ticksToSeconds(this.getDuration())});
    }

    @Override
    public String getName() {
        return "sea_eyes";
    }

    @Override
    public AbstractDragonType getDragonType() {
        return DragonTypes.SEA;
    }

    @Override
    public ResourceLocation[] getSkillTextures() {
        return new ResourceLocation[]{new ResourceLocation("dragonsurvival", "textures/skills/sea/sea_eyes_0.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/sea_eyes_1.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/sea_eyes_2.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/sea_eyes_3.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/sea_eyes_4.png")};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        ArrayList<Component> list = super.getLevelUpInfo();
        list.add((Component)Component.m_237110_((String)"ds.skill.duration.seconds", (Object[])new Object[]{"+" + seaEyesDuration}));
        return list;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getMinLevel() {
        return 0;
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || seaEyes == false;
    }
}

