/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.abilities.SeaDragon.active;

import by.dragonsurvivalteam.dragonsurvival.client.particles.SeaDragon.LargeLightningParticleData;
import by.dragonsurvivalteam.dragonsurvival.client.particles.SeaDragon.SmallLightningParticleData;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.SoundRegistry;
import by.dragonsurvivalteam.dragonsurvival.client.sounds.StormBreathSound;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigType;
import by.dragonsurvivalteam.dragonsurvival.magic.common.RegisterDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.BreathAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import by.dragonsurvivalteam.dragonsurvival.util.TargetingFunctions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

@RegisterDragonAbility
public class StormBreathAbility
extends BreathAbility {
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreath", comment={"Whether the storm breath ability should be enabled"})
    public static Boolean stormBreath = true;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreathDamage", comment={"The amount of damage the storm breath ability deals. This value is multiplied by the skill level."})
    public static Double stormBreathDamage = 1.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreathInitialMana", comment={"The mana cost for starting the storm breath ability"})
    public static Integer stormBreathInitialMana = 2;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreathCooldown", comment={"The cooldown in seconds of the storm breath ability"})
    public static Double stormBreathCooldown = 10.0;
    @ConfigRange(min=0.05, max=10000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreathCasttime", comment={"The cast time in seconds of the storm breath ability"})
    public static Double stormBreathCasttime = 1.0;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreathOvertimeMana", comment={"The mana cost of sustaining the storm breath ability"})
    public static Integer stormBreathOvertimeMana = 1;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreathManaTicks", comment={"How often in seconds, mana is consumed while using storm breath"})
    public static Double stormBreathManaTicks = 2.0;
    @ConfigType(value=Block.class)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreathBlockBreaks", comment={"Blocks that have a chance to be broken by storm breath. Formatting: block/modid:id"})
    public static List<String> stormBreathBlockBreaks = List.of("minecraft:impermeable", "minecraft:flowers", "minecraft:replaceable_plants");
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="stormBreathChainCount", comment={"How many mobs stormbreath is able to chain to at once"})
    public static Integer stormBreathChainCount = 2;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="chargedEffectChainCount", comment={"How many mobs the charged effect is able to chain to at once"})
    public static Integer chargedEffectChainCount = 2;
    @ConfigRange(min=-1.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="chargedEffectMaxChain", comment={"How many times the charged effect is able to chain."})
    public static Integer chargedEffectMaxChain = 5;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="chargedChainRange", comment={"The max distance in blocks the storm breath and charged effect is able to chain to mobs"})
    public static Integer chargedChainRange = 4;
    @ConfigRange(min=0.0, max=100.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="chargedEffectDamageMultiplier", comment={"The charged effect damage (starts at 1, scaling with effect level) will get multiplied by this amount"})
    public static Double chargedEffectDamageMultiplier = 1.0;
    @ConfigType(value=EntityType.class)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="chargedSpreadBlacklist", comment={"List of entities that will not spread the charged effect. Format: modid:id"})
    public static List<String> chargedSpreadBlacklist = List.of("minecraft:armor_stand", "minecraft:cat", "minecraft:cart", "minecraft:guardian", "minecraft:elder_guardian", "minecraft:enderman", "upgrade_aquatic:thrasher", "upgrade_aquatic:great_thrasher");
    @ConfigType(value=EntityType.class)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic", "abilities", "sea_dragon", "actives", "storm_breath"}, key="chargedBlacklist", comment={"List of entities that will not receive the charged effect at all Format: modid:id"})
    public static List<String> chargedBlacklist = List.of("minecraft:armor_stand", "minecraft:cat", "minecraft:cart", "minecraft:guardian", "minecraft:elder_guardian", "minecraft:enderman", "upgrade_aquatic:thrasher", "upgrade_aquatic:great_thrasher");

    public static void onDamageChecks(LivingEntity entity) {
        Creeper creeper;
        if (entity instanceof Creeper && !(creeper = (Creeper)entity).m_7090_()) {
            creeper.m_20088_().m_135381_(Creeper.f_32274_, (Object)true);
        }
    }

    public static void spark(LivingEntity source, LivingEntity target) {
        if (source.m_9236_().m_5776_()) {
            float eyeHeight = source instanceof Player ? 0.0f : source.m_20192_();
            Vec3 start = source.m_20318_(eyeHeight);
            Vec3 end = target.m_20318_(target.m_20192_());
            int parts = 20;
            double xDif = (end.f_82479_ - start.f_82479_) / (double)parts;
            double yDif = (end.f_82480_ - start.f_82480_) / (double)parts;
            double zDif = (end.f_82481_ - start.f_82481_) / (double)parts;
            if (end.f_82479_ - start.f_82479_ >= 64.0 || end.f_82480_ - start.f_82480_ >= 64.0 || end.f_82481_ - start.f_82481_ >= 64.0) {
                return;
            }
            for (int i = 0; i < parts; ++i) {
                double x = start.f_82479_ + xDif * (double)i;
                double y = start.f_82480_ + yDif * (double)i + (double)eyeHeight;
                double z = start.f_82481_ + zDif * (double)i;
                source.m_9236_().m_7106_((ParticleOptions)new SmallLightningParticleData(37.0f, true), x, y, z, xDif, yDif, zDif);
            }
        }
    }

    @Override
    public int getManaCost() {
        return stormBreathOvertimeMana;
    }

    @Override
    public Integer[] getRequiredLevels() {
        return new Integer[]{0, 10, 30, 50};
    }

    @Override
    public int getSkillCooldown() {
        return Functions.secondsToTicks(stormBreathCooldown);
    }

    public static void chargedEffectSparkle(Player player, LivingEntity source, int chainRange, int maxChainTargets, double damage) {
        List<LivingEntity> secondaryTargets = StormBreathAbility.getEntityLivingBaseNearby(source, chainRange);
        secondaryTargets.removeIf(e -> !StormBreathAbility.isValidTarget(source, e));
        if (secondaryTargets.size() > maxChainTargets) {
            secondaryTargets.sort((c1, c2) -> Boolean.compare(c1.m_21023_(DragonEffects.CHARGED), c2.m_21023_(DragonEffects.CHARGED)));
            secondaryTargets = secondaryTargets.subList(0, maxChainTargets);
        }
        secondaryTargets.add(source);
        for (LivingEntity target : secondaryTargets) {
            if (player != null) {
                TargetingFunctions.attackTargets((Entity)player, eTarget -> eTarget.m_6469_(player.m_269291_().m_269299_((Entity)source, (LivingEntity)player), (float)damage), new Entity[]{target});
            } else {
                target.m_6469_(target.m_269291_().m_269333_(source), (float)damage);
            }
            StormBreathAbility.onDamageChecks(target);
            if (chargedSpreadBlacklist.contains(ResourceHelper.getKey((Entity)source).toString()) || target == source) continue;
            EntityStateHandler capSource = DragonUtils.getEntityHandler((Entity)source);
            EntityStateHandler entityCap = DragonUtils.getEntityHandler((Entity)target);
            entityCap.chainCount = capSource.chainCount + 1;
            if (!(target.m_9236_().m_5776_() || target.m_217043_().m_188503_(100) >= 40 || entityCap.chainCount >= chargedEffectMaxChain && chargedEffectMaxChain != -1)) {
                entityCap.lastAfflicted = player != null ? player.m_19879_() : -1;
                target.m_7292_(new MobEffectInstance(DragonEffects.CHARGED, Functions.secondsToTicks(10), 0, false, true));
            }
            if (player != null && player.m_217043_().m_188503_(100) < 50 && !player.m_9236_().m_5776_()) {
                player.m_7292_(new MobEffectInstance(DragonEffects.CHARGED, Functions.secondsToTicks(30)));
            }
            StormBreathAbility.spark(source, target);
        }
    }

    public static float getDamage(int level) {
        return (float)(stormBreathDamage * (double)level);
    }

    public static boolean isValidTarget(LivingEntity attacker, LivingEntity target) {
        if (target == null || attacker == null) {
            return false;
        }
        if (chargedBlacklist.contains(ResourceHelper.getKey((Entity)target).toString())) {
            return false;
        }
        if (chargedSpreadBlacklist.contains(ResourceHelper.getKey((Entity)attacker).toString())) {
            return false;
        }
        if (target.m_21188_() == attacker && target.m_21213_() + Functions.secondsToTicks(1) < target.f_19797_) {
            return false;
        }
        return TargetingFunctions.isValidTarget((Entity)attacker, (Entity)target) && !DragonUtils.isDragonType((Entity)target, (AbstractDragonType)DragonTypes.SEA);
    }

    public void hurtTarget(LivingEntity entity) {
        TargetingFunctions.attackTargets((Entity)this.getPlayer(), e -> e.m_6469_(DSDamageTypes.entityDamageSource(this.player.m_9236_(), this, (Entity)this.player), this.getDamage()), new Entity[]{entity});
        this.onDamage(entity);
        if (this.player.m_217043_().m_188503_(100) < 50 && !this.player.m_9236_().m_5776_()) {
            this.player.m_7292_(new MobEffectInstance(DragonEffects.CHARGED, Functions.secondsToTicks(30)));
        }
        if (!entity.m_9236_().m_5776_() && !chargedBlacklist.contains(ResourceHelper.getKey((Entity)entity).toString()) && entity.m_217043_().m_188503_(100) < 40) {
            EntityStateHandler cap = DragonUtils.getEntityHandler((Entity)entity);
            cap.lastAfflicted = this.player.m_19879_();
            cap.chainCount = 1;
            entity.m_7292_(new MobEffectInstance(DragonEffects.CHARGED, Functions.secondsToTicks(10), 0, false, true));
        }
    }

    @Override
    public String getName() {
        return "storm_breath";
    }

    @Override
    public ClipContext.Fluid clipContext() {
        return ClipContext.Fluid.NONE;
    }

    @Override
    public AbstractDragonType getDragonType() {
        return DragonTypes.SEA;
    }

    @Override
    public ResourceLocation[] getSkillTextures() {
        return new ResourceLocation[]{new ResourceLocation("dragonsurvival", "textures/skills/sea/storm_breath_0.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/storm_breath_1.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/storm_breath_2.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/storm_breath_3.png"), new ResourceLocation("dragonsurvival", "textures/skills/sea/storm_breath_4.png")};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        ArrayList<Component> list = super.getLevelUpInfo();
        list.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{"+" + stormBreathDamage}));
        return list;
    }

    @Override
    public int getMaxLevel() {
        return 4;
    }

    @Override
    public int getMinLevel() {
        return 1;
    }

    @Override
    public boolean isDisabled() {
        return super.isDisabled() || stormBreath == false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sound() {
        Vec3 pos = this.player.m_20299_(1.0f);
        SimpleSoundInstance startingSound = new SimpleSoundInstance(SoundRegistry.stormBreathStart, SoundSource.PLAYERS, 1.0f, 1.0f, SoundInstance.m_235150_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)startingSound, 0);
        Minecraft.m_91087_().m_91106_().m_120386_(new ResourceLocation("dragonsurvival", "storm_breath_loop"), SoundSource.PLAYERS);
        Minecraft.m_91087_().m_91106_().m_120372_((TickableSoundInstance)new StormBreathSound(this));
    }

    @Override
    public void onBlock(BlockPos pos, BlockState blockState, Direction direction) {
        AreaEffectCloud entity;
        Level level = this.player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (blockState.m_280296_() && this.player.m_217043_().m_188503_(100) < 30) {
            entity = new AreaEffectCloud(EntityType.f_20476_, this.player.m_9236_());
            entity.m_19740_(0);
            entity.m_6034_((double)pos.m_7494_().m_123341_(), (double)pos.m_7494_().m_123342_(), (double)pos.m_7494_().m_123343_());
            entity.m_19722_(new Potion(new MobEffectInstance[]{new MobEffectInstance(DragonEffects.CHARGED, Functions.secondsToTicks(10) * 4)}));
            entity.m_19734_(Functions.secondsToTicks(2));
            entity.m_19712_(1.0f);
            entity.m_19724_((ParticleOptions)new SmallLightningParticleData(37.0f, false));
            entity.m_19718_((LivingEntity)this.player);
            serverLevel.m_7967_((Entity)entity);
        }
        if (blockState.m_60819_().m_205070_(FluidTags.f_13131_) && this.player.m_217043_().m_188503_(100) < 30) {
            entity = new AreaEffectCloud(EntityType.f_20476_, this.player.m_9236_());
            entity.m_19740_(0);
            entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            entity.m_19722_(new Potion(new MobEffectInstance[]{new MobEffectInstance(DragonEffects.CHARGED, Functions.secondsToTicks(10) * 4)}));
            entity.m_19734_(Functions.secondsToTicks(2));
            entity.m_19712_(0.45f);
            entity.m_19724_((ParticleOptions)new SmallLightningParticleData(37.0f, true));
            entity.m_19718_((LivingEntity)this.player);
            serverLevel.m_7967_((Entity)entity);
        }
        Level level2 = this.player.m_9236_();
        if (level2.f_46443_ && this.player.f_19797_ % 40 == 0 && level2.m_46470_() && this.player.m_217043_().m_188503_(100) < 30 && level2.m_45527_(pos)) {
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(this.player.m_9236_());
            lightningboltentity.m_20219_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
            lightningboltentity.m_20879_((ServerPlayer)this.player);
            level2.m_7967_((Entity)lightningboltentity);
            level2.m_5594_(this.player, pos, SoundEvents.f_12090_, SoundSource.WEATHER, 5.0f, 1.0f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopSound() {
        if (SoundRegistry.stormBreathEnd != null) {
            Vec3 pos = this.player.m_20299_(1.0f);
            SimpleSoundInstance endSound = new SimpleSoundInstance(SoundRegistry.stormBreathEnd, SoundSource.PLAYERS, 1.0f, 1.0f, SoundInstance.m_235150_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
            Minecraft.m_91087_().m_91106_().m_120369_((SoundInstance)endSound, 0);
        }
        Minecraft.m_91087_().m_91106_().m_120386_(new ResourceLocation("dragonsurvival", "storm_breath_loop"), SoundSource.PLAYERS);
    }

    @Override
    public void onChanneling(Player player, int castDuration) {
        super.onChanneling(player, castDuration);
        if (player.m_9236_().m_5776_() && castDuration <= 0) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::sound);
        }
        if (player.m_9236_().m_5776_()) {
            double zSpeed;
            double ySpeed;
            double xSpeed;
            int i;
            for (i = 0; i < StormBreathAbility.calculateNumberOfParticles(DragonUtils.getHandler((Entity)player).getSize()) / 6; ++i) {
                xSpeed = this.speed * 1.0f * this.xComp;
                ySpeed = this.speed * 1.0f * this.yComp;
                zSpeed = this.speed * 1.0f * this.zComp;
                player.m_9236_().m_7106_((ParticleOptions)new SmallLightningParticleData(37.0f, true), this.dx, this.dy, this.dz, xSpeed, ySpeed, zSpeed);
            }
            for (i = 0; i < StormBreathAbility.calculateNumberOfParticles(DragonUtils.getHandler((Entity)player).getSize()) / 12; ++i) {
                xSpeed = (double)(this.speed * this.xComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.xComp * this.xComp);
                ySpeed = (double)(this.speed * this.yComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.yComp * this.yComp);
                zSpeed = (double)(this.speed * this.zComp) + (double)this.spread * 0.7 * (double)(player.m_217043_().m_188501_() * 2.0f - 1.0f) * Math.sqrt(1.0f - this.zComp * this.zComp);
                player.m_9236_().m_7106_((ParticleOptions)new LargeLightningParticleData(37.0f, false), this.dx, this.dy, this.dz, xSpeed, ySpeed, zSpeed);
            }
        }
        this.hitEntities();
        if (player.f_19797_ % 10 == 0) {
            this.hitBlocks();
        }
    }

    @Override
    public boolean canHitEntity(LivingEntity entity) {
        return !(entity instanceof Player) || this.player.m_7099_((Player)entity);
    }

    @Override
    public void onDamage(LivingEntity entity) {
        StormBreathAbility.onDamageChecks(entity);
    }

    @Override
    public void onEntityHit(LivingEntity entityHit) {
        this.hurtTarget(entityHit);
        StormBreathAbility.chargedEffectSparkle(this.player, entityHit, chargedChainRange, stormBreathChainCount, chargedEffectDamageMultiplier);
    }

    @Override
    public float getDamage() {
        return StormBreathAbility.getDamage(this.getLevel());
    }

    @Override
    public int getSkillChargeTime() {
        return Functions.secondsToTicks(stormBreathCasttime);
    }

    @Override
    public int getContinuousManaCostTime() {
        return Functions.secondsToTicks(stormBreathManaTicks);
    }

    @Override
    public int getInitManaCost() {
        return stormBreathInitialMana;
    }

    @Override
    public void castComplete(Player player) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::stopSound);
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }
}

