/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.common;

import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class DragonAbility {
    protected static NumberFormat nf = NumberFormat.getInstance();
    public Player player;
    public int level;

    public void onKeyPressed(Player player, Runnable onFinish, long castStartTime, long clientTime) {
    }

    public void onKeyReleased(Player player) {
    }

    public Player getPlayer() {
        return this.player;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getTitle() {
        return Component.m_237115_((String)("ds.skill." + this.getName()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getDescription() {
        return Component.m_237115_((String)("ds.skill.description." + this.getName()));
    }

    public abstract String getName();

    public abstract AbstractDragonType getDragonType();

    @OnlyIn(value=Dist.CLIENT)
    public abstract ResourceLocation[] getSkillTextures();

    public ResourceLocation getIcon() {
        return this.getSkillTextures()[Mth.m_14045_((int)this.getLevel(), (int)0, (int)(this.getSkillTextures().length - 1))];
    }

    public int getSortOrder() {
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getInfo() {
        return new ArrayList<Component>();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getLevelUpInfo() {
        return new ArrayList<Component>();
    }

    public CompoundTag saveNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("level", this.level);
        return nbt;
    }

    public void loadNBT(CompoundTag nbt) {
        this.level = nbt.m_128451_("level");
    }

    public abstract int getMaxLevel();

    public abstract int getMinLevel();

    public boolean isDisabled() {
        if (!ServerConfig.dragonAbilities.booleanValue()) {
            return true;
        }
        if (Objects.equals(this.getDragonType(), DragonTypes.CAVE) && !ServerConfig.caveDragonAbilities.booleanValue()) {
            return true;
        }
        if (Objects.equals(this.getDragonType(), DragonTypes.SEA) && !ServerConfig.seaDragonAbilities.booleanValue()) {
            return true;
        }
        return Objects.equals(this.getDragonType(), DragonTypes.FOREST) && ServerConfig.forestDragonAbilities == false;
    }

    public int getLevel() {
        if (this.isDisabled()) {
            return 0;
        }
        return this.level;
    }

    public void setLevel(int level) {
        this.level = Mth.m_14045_((int)level, (int)this.getMinLevel(), (int)this.getMaxLevel());
    }

    static {
        nf.setMaximumFractionDigits(1);
    }
}

