/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.common.active;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.magic.ClientMagicHUDHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ManaHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.common.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.magic.common.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public abstract class ActiveDragonAbility
extends DragonAbility {
    private int currentCooldown;

    public abstract int getManaCost();

    public void startCooldown() {
        this.currentCooldown = this.getSkillCooldown();
    }

    @Override
    public CompoundTag saveNBT() {
        CompoundTag nbt = super.saveNBT();
        return nbt;
    }

    @Override
    public void loadNBT(CompoundTag nbt) {
        super.loadNBT(nbt);
    }

    public abstract Integer[] getRequiredLevels();

    public abstract int getSkillCooldown();

    public int getNextRequiredLevel() {
        if (this.getLevel() <= this.getMaxLevel() && this.getRequiredLevels().length > this.getLevel() && this.getLevel() > 0) {
            return this.getRequiredLevels()[this.getLevel()];
        }
        return 0;
    }

    @Override
    public int getLevel() {
        if (this.isDisabled()) {
            return 0;
        }
        if (this.getRequiredLevels() != null && this.getPlayer() != null) {
            int level = 0;
            Integer[] integerArray = this.getRequiredLevels();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int req = integerArray[i];
                if (this.getPlayer().f_36078_ < req && !ServerConfig.noEXPRequirements.booleanValue()) continue;
                ++level;
            }
            return level;
        }
        return super.getLevel();
    }

    public int getCurrentRequiredLevel() {
        if (this.getRequiredLevels().length >= this.getLevel() && this.getLevel() > 0) {
            return this.getRequiredLevels()[this.getLevel() - 1];
        }
        return 0;
    }

    public int getLevelCost() {
        return 1 + (int)(0.75 * (double)this.getLevel());
    }

    public boolean canCastSkill(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!this.canConsumeMana(player)) {
            ClientMagicHUDHandler.castingError(Component.m_237115_((String)"ds.skill_mana_check_failure"));
            return false;
        }
        if (this.getCurrentCooldown() != 0) {
            ClientMagicHUDHandler.castingError(Component.m_237110_((String)"ds.skill_cooldown_check_failure", (Object[])new Object[]{nf.format((float)this.getCurrentCooldown() / 20.0f) + "s"}).m_130940_(ChatFormatting.RED));
            return false;
        }
        if ((this.requiresStationaryCasting() || ServerFlightHandler.isGliding(player)) && (handler.isWingsSpread() && player.m_21255_() || !player.m_20096_() && player.f_19789_ > 0.15f)) {
            ClientMagicHUDHandler.castingError(Component.m_237115_((String)"ds.skill.nofly"));
            return false;
        }
        return !player.m_5833_();
    }

    public boolean canConsumeMana(Player player) {
        return ManaHandler.canConsumeMana(player, this.getManaCost());
    }

    public void tickCooldown() {
        if (this.getCurrentCooldown() > 0) {
            this.setCurrentCooldown(this.getCurrentCooldown() - 1);
        } else if (this.getCurrentCooldown() < 0) {
            this.setCurrentCooldown(0);
        }
    }

    public boolean requiresStationaryCasting() {
        return true;
    }

    public AbilityAnimation getStartingAnimation() {
        return null;
    }

    public AbilityAnimation getLoopingAnimation() {
        return null;
    }

    public AbilityAnimation getStoppingAnimation() {
        return null;
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = super.getInfo();
        components.add((Component)Component.m_237110_((String)"ds.skill.mana_cost", (Object[])new Object[]{this.getManaCost()}));
        if (this.getSkillCooldown() > 0) {
            components.add((Component)Component.m_237110_((String)"ds.skill.cooldown", (Object[])new Object[]{Functions.ticksToSeconds(this.getSkillCooldown())}));
        }
        return components;
    }

    public void setCurrentCooldown(int currentCooldown) {
        this.currentCooldown = currentCooldown;
    }

    public int getCurrentCooldown() {
        return this.currentCooldown;
    }
}

