/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.common.active;

import by.dragonsurvivalteam.dragonsurvival.client.handlers.Keybind;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.common.AbilityAnimation;
import by.dragonsurvivalteam.dragonsurvival.magic.common.ISecondAnimation;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ChannelingCastAbility;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import by.dragonsurvivalteam.dragonsurvival.server.handlers.ServerFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import by.dragonsurvivalteam.dragonsurvival.util.TargetingFunctions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class BreathAbility
extends ChannelingCastAbility
implements ISecondAnimation {
    @ConfigRange(min=0.0, max=10.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"magic"}, key="baseBreathRange", comment={"The base range of the breath attack (breath range increases with dragon growth)"})
    public static Integer baseBreathRange = 3;
    public int currentBreathRange;
    public float yaw;
    public float pitch;
    public float speed;
    public float spread;
    public float xComp;
    public float yComp;
    public float zComp;
    public double dx;
    public double dy;
    public double dz;

    public static List<LivingEntity> getEntityLivingBaseNearby(LivingEntity source, double radius) {
        return BreathAbility.getEntitiesNearby(source, LivingEntity.class, radius);
    }

    public static <T extends Entity> List<T> getEntitiesNearby(LivingEntity source, Class<T> entityClass, double radius) {
        return source.m_9236_().m_6443_(entityClass, source.m_20191_().m_82377_(radius, radius, radius), entity -> entity != source && (double)source.m_20270_(entity) <= radius + (double)(entity.m_20205_() / 2.0f) && entity.m_20186_() <= source.m_20186_() + radius);
    }

    @Override
    public boolean requiresStationaryCasting() {
        return false;
    }

    @Override
    public boolean canCastSkill(Player player) {
        if (ServerFlightHandler.isGliding(player)) {
            return false;
        }
        return super.canCastSkill(player);
    }

    @Override
    public void onCharging(Player player, int currentChargeTime) {
    }

    @Override
    public void onChanneling(Player player, int castDuration) {
        Vec3 breathPos;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        this.currentBreathRange = BreathAbility.calculateCurrentBreathRange(handler.getSize());
        this.yaw = (float)Math.toRadians(-player.m_146908_());
        this.pitch = (float)Math.toRadians(-player.m_146909_());
        this.speed = BreathAbility.calculateCurrentBreathSpeed(handler.getSize());
        this.spread = BreathAbility.calculateSpread(handler.getSize());
        this.xComp = (float)(Math.sin(this.yaw) * Math.cos(this.pitch));
        this.yComp = (float)Math.sin(this.pitch);
        this.zComp = (float)(Math.cos(this.yaw) * Math.cos(this.pitch));
        Vec3 eyePos = player.m_146892_();
        Vec3 lookAngle = player.m_20154_();
        double size = handler.getSize();
        if (player.m_150110_().f_35935_) {
            Vec3 forward = lookAngle.m_82490_(2.0);
            breathPos = eyePos.m_82549_(forward).m_82520_(0.0, -0.1 - 0.5 * (size / 30.0), 0.0);
        } else {
            Vec3 forward = lookAngle.m_82490_(1.0);
            breathPos = eyePos.m_82549_(forward).m_82520_(0.0, (double)-0.1f - (double)0.2f * (size / 30.0), 0.0);
        }
        this.dx = breathPos.f_82479_;
        this.dy = breathPos.f_82480_;
        this.dz = breathPos.f_82481_;
    }

    @Override
    public AbilityAnimation getLoopingAnimation() {
        return new AbilityAnimation("breath", false, false);
    }

    public void hitEntities() {
        AABB breathArea = DragonAbilities.calculateBreathArea(this.player, this.currentBreathRange);
        List entities = this.player.m_9236_().m_6249_((Entity)this.player, breathArea, entity -> {
            LivingEntity livingEntity;
            if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_5833_() && livingEntity.m_6084_() && TargetingFunctions.isValidTarget((Entity)this.getPlayer(), (Entity)livingEntity) && this.canHitEntity(livingEntity)) {
                return livingEntity.m_21188_() != this.player || livingEntity.m_21213_() + Functions.secondsToTicks(1) >= livingEntity.f_19797_;
            }
            return false;
        });
        entities.forEach(entity -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.onEntityHit(livingEntity);
            }
        });
    }

    public abstract boolean canHitEntity(LivingEntity var1);

    public void onEntityHit(LivingEntity entityHit) {
        if (TargetingFunctions.attackTargets((Entity)this.getPlayer(), entity -> entity.m_6469_(DSDamageTypes.entityDamageSource(this.player.m_9236_(), this, (Entity)this.player), this.getDamage()), new Entity[]{entityHit})) {
            entityHit.m_20256_(entityHit.m_20184_().m_82542_(0.25, 1.0, 0.25));
            this.onDamage(entityHit);
        }
    }

    public abstract void onDamage(LivingEntity var1);

    public abstract float getDamage();

    public List<LivingEntity> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(LivingEntity.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double radius) {
        return this.player.m_9236_().m_6443_(entityClass, this.player.m_20191_().m_82377_(dX, dY, dZ), entity -> entity != this.player && (double)this.player.m_20270_(entity) <= radius + (double)(entity.m_20205_() / 2.0f) && entity.m_20186_() <= this.player.m_20186_() + dY);
    }

    public ClipContext.Fluid clipContext() {
        return ClipContext.Fluid.ANY;
    }

    public void hitBlocks() {
        Pair<BlockPos, Direction> data = DragonAbilities.breathStartPosition(this.player, this, this.currentBreathRange);
        BlockPos position = (BlockPos)data.getFirst();
        Direction direction = (Direction)data.getSecond();
        if (position == null) {
            return;
        }
        BlockPos.MutableBlockPos mutablePosition = position.m_122032_();
        for (int x = -(this.currentBreathRange / 2); x < this.currentBreathRange / 2; ++x) {
            for (int y = -(this.currentBreathRange / 2); y < this.currentBreathRange / 2; ++y) {
                for (int z = -(this.currentBreathRange / 2); z < this.currentBreathRange / 2; ++z) {
                    BlockState state;
                    mutablePosition.m_122190_((Vec3i)position).m_122184_(x, y, z);
                    if (!(mutablePosition.m_123331_((Vec3i)position) <= (double)this.currentBreathRange) || (state = this.player.m_9236_().m_8055_((BlockPos)mutablePosition)).m_60734_() == Blocks.f_50016_) continue;
                    if (DragonConfigHandler.DRAGON_BREATH_BLOCKS != null && DragonConfigHandler.DRAGON_BREATH_BLOCKS.containsKey(this.getDragonType().getTypeName()) && DragonConfigHandler.DRAGON_BREATH_BLOCKS.get(this.getDragonType().getTypeName()).contains(state.m_60734_()) && !this.player.m_9236_().m_5776_() && this.player.m_217043_().m_188501_() * 100.0f <= (float)this.blockBreakChance()) {
                        this.player.m_9236_().m_46953_((BlockPos)mutablePosition, false, (Entity)this.player);
                        continue;
                    }
                    this.onBlock((BlockPos)mutablePosition, state, direction);
                }
            }
        }
    }

    public abstract void onBlock(BlockPos var1, BlockState var2, Direction var3);

    public int blockBreakChance() {
        return 90;
    }

    @Override
    public int getSortOrder() {
        return 1;
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = new ArrayList<Component>();
        DragonStateHandler handler = DragonUtils.getHandler((Entity)this.player);
        int range = BreathAbility.calculateCurrentBreathRange(handler.getSize());
        components.add((Component)Component.m_237110_((String)"ds.skill.mana_cost", (Object[])new Object[]{this.getInitManaCost()}));
        components.add((Component)Component.m_237110_((String)"ds.skill.channel_cost", (Object[])new Object[]{this.getManaCost(), 2}));
        components.add((Component)Component.m_237110_((String)"ds.skill.cast_time", (Object[])new Object[]{Functions.ticksToSeconds(this.getSkillChargeTime())}));
        components.add((Component)Component.m_237110_((String)"ds.skill.cooldown", (Object[])new Object[]{Functions.ticksToSeconds(this.getSkillCooldown())}));
        components.add((Component)Component.m_237110_((String)"ds.skill.damage", (Object[])new Object[]{Float.valueOf(this.getDamage())}));
        components.add((Component)Component.m_237110_((String)"ds.skill.range.blocks", (Object[])new Object[]{range}));
        if (!Keybind.ABILITY1.m_90862_()) {
            String key = Keybind.ABILITY1.getKey().m_84875_().getString().toUpperCase(Locale.ROOT);
            if (key.isEmpty()) {
                key = Keybind.ABILITY1.getKey().m_84875_().getString();
            }
            components.add((Component)Component.m_237110_((String)"ds.skill.keybind", (Object[])new Object[]{key}));
        }
        return components;
    }

    private static float calculateSpread(double size) {
        return (float)Math.sqrt(size / (double)DragonLevel.ADULT.size) / 5.0f + 0.05f;
    }

    public static int calculateNumberOfParticles(double size) {
        return (int)Math.max(Math.min(100.0, size * 0.6), 12.0);
    }

    public static int calculateCurrentBreathRange(double size) {
        float sizeFactor = Math.min((float)size / (float)DragonLevel.ADULT.size, 1.0f);
        float additionalBreathRange = sizeFactor * 4.0f + (float)size * 0.05f;
        return baseBreathRange + (int)additionalBreathRange;
    }

    public static float calculateCurrentBreathSpeed(double size) {
        float sizeFactor = Math.min((float)size / (float)DragonLevel.ADULT.size, 1.0f);
        return sizeFactor * 0.3f + (float)size * 0.004f;
    }
}

